/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer;

import java.awt.Component;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cytoscape.analyzer.AnalyzerManager;
import org.cytoscape.analyzer.ResultsPanel;
import org.cytoscape.analyzer.util.NetworkInterpretation;
import org.cytoscape.analyzer.util.NetworkStats;
import org.cytoscape.analyzer.util.SumCountPair;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.CytoPanelState;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CySubNetwork;

public abstract class NetworkAnalyzer {
    public static final boolean verbose = false;
    static String columnName = "statistics";
    AnalyzerManager manager;
    protected CySwingApplication desktop;
    public CyNetwork network;
    protected NetworkInterpretation interpr;
    protected NetworkStats stats;
    public int progress;
    public boolean cancelled;
    protected boolean degreeOnly;
    private Set<CyEdge> removedEdges;

    public abstract boolean isDirected();

    public String getNetworkTitle() {
        return this.stats.getTitle();
    }

    public NetworkStats getStats() {
        return this.stats;
    }

    public int getCurrentProgress() {
        return this.progress;
    }

    public void doOutput() {
        String json = this.stats.jsonOutput();
        CyTable hiddenTable = this.network.getTable(CyNetwork.class, "HIDDEN");
        CyColumn col = hiddenTable.getColumn(columnName);
        if (col == null) {
            hiddenTable.createColumn(columnName, String.class, true);
            col = hiddenTable.getColumn(columnName);
        }
        hiddenTable.getRow((Object)this.network.getSUID()).set(columnName, (Object)json);
        String out = this.stats.htmlOutput();
        CytoPanel panel = this.desktop.getCytoPanel(CytoPanelName.EAST);
        panel.setState(CytoPanelState.DOCK);
        int nPanels = panel.getCytoPanelComponentCount();
        for (int c = 0; c < nPanels; ++c) {
            Component comp = panel.getComponentAt(c);
            if (!(comp instanceof ResultsPanel)) continue;
            ResultsPanel results = (ResultsPanel)comp;
            results.setResults(this.stats);
            panel.setSelectedIndex(c);
        }
    }

    public int getMaxProgress() {
        return this.stats.getInt("nodeCount") + 1;
    }

    public abstract void computeAll();

    public void cancel() {
        this.cancelled = true;
    }

    public boolean isGlobal() {
        return true;
    }

    protected NetworkAnalyzer(CyNetwork aNetwork, NetworkInterpretation aInterpr, CySwingApplication app, AnalyzerManager mgr) {
        this.network = aNetwork;
        this.interpr = aInterpr;
        this.stats = new NetworkStats(aNetwork, aInterpr.getInterpretSuffix());
        this.progress = 0;
        this.desktop = app;
        this.manager = mgr;
    }

    protected void analysisStarting() {
        this.manager.registerResultsPanel();
        if (this.interpr.isIgnoreUSL()) {
            this.removedEdges = new HashSet<CyEdge>();
            for (CyEdge edge : this.network.getEdgeList()) {
                if (edge.isDirected() || edge.getSource() != edge.getTarget()) continue;
                this.removedEdges.add(edge);
            }
            this.network.removeEdges(this.removedEdges);
            this.stats.set("edgeCount", new Integer(this.network.getEdgeCount()));
        }
    }

    protected void analysisFinished() {
        if (this.interpr.isIgnoreUSL()) {
            for (CyEdge e : this.removedEdges) {
                ((CySubNetwork)this.network).addEdge(e);
            }
        }
    }

    public void accumulate(Map<Integer, SumCountPair> aMapping, int aKey, double aValue) {
        this.accumulate(aMapping, new Integer(aKey), aValue);
    }

    protected void accumulate(Map<Integer, SumCountPair> aMapping, Integer aKey, double aValue) {
        SumCountPair sequenceStat = aMapping.get(aKey);
        if (sequenceStat != null) {
            sequenceStat.add(aValue);
        } else {
            aMapping.put(aKey, new SumCountPair(aValue));
        }
    }

    public double accumulateCCs(Map<Integer, SumCountPair> aCCps, Point2D.Double[] aAverages) {
        double total = 0.0;
        Set<Integer> neighborCounts = aCCps.keySet();
        int i = 0;
        for (Integer nc : neighborCounts) {
            SumCountPair coefs = aCCps.get(nc);
            total += coefs.getSum();
            aAverages[i++] = new Point2D.Double(nc.doubleValue(), coefs.getAverage());
        }
        return total;
    }
}

