/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.cytoscape.analyzer.NetworkAnalyzer;
import org.cytoscape.analyzer.util.ConnectedComponentInfo;
import org.cytoscape.analyzer.util.CyNetworkUtils;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;

public class ConnComponentAnalyzer {
    List<ConnectedComponentInfo> components = null;
    NetworkAnalyzer analyzer;
    private CyNetwork network;

    public ConnComponentAnalyzer(NetworkAnalyzer analz, CyNetwork aNetwork) {
        this.network = aNetwork;
        this.analyzer = analz;
        this.components = null;
    }

    public static Set<CyNode> getNodesOf(CyNetwork aNetwork, ConnectedComponentInfo aCompInfo) {
        HashSet<CyNode> nodes = new HashSet<CyNode>(aCompInfo.getSize());
        nodes.add(aCompInfo.getNode());
        LinkedList<CyNode> toTraverse = new LinkedList<CyNode>();
        toTraverse.add(aCompInfo.getNode());
        while (!toTraverse.isEmpty()) {
            CyNode node = (CyNode)toTraverse.removeFirst();
            Set<CyNode> neighbors = CyNetworkUtils.getNeighbors(aNetwork, node);
            for (CyNode nb : neighbors) {
                if (nodes.contains(nb)) continue;
                nodes.add(nb);
                toTraverse.add(nb);
            }
        }
        return nodes;
    }

    public List<ConnectedComponentInfo> findComponents() {
        int untravCount = this.network.getNodeCount();
        HashSet<CyNode> traversed = new HashSet<CyNode>(untravCount);
        HashSet<ConnectedComponentInfo> ccis = new HashSet<ConnectedComponentInfo>();
        for (CyNode node : this.network.getNodeList()) {
            if (traversed.contains(node)) continue;
            int ccSize = this.traverseReachable(node, traversed);
            untravCount -= ccSize;
            ccis.add(new ConnectedComponentInfo(this.analyzer, ccSize, node, false));
        }
        this.components = new ArrayList<ConnectedComponentInfo>(ccis);
        Collections.sort(this.components);
        return this.components;
    }

    public ConnectedComponentInfo findLargestComponent() {
        if (this.components == null) {
            this.findComponents();
        }
        return this.components.get(this.components.size() - 1);
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public Set<CyNode> getNodesOf(ConnectedComponentInfo aCompInfo) {
        return ConnComponentAnalyzer.getNodesOf(this.network, aCompInfo);
    }

    private int traverseReachable(CyNode aNode, Set<CyNode> aTraversed) {
        int size = 1;
        LinkedList<CyNode> toTraverse = new LinkedList<CyNode>();
        aTraversed.add(aNode);
        toTraverse.add(aNode);
        while (!toTraverse.isEmpty()) {
            CyNode currentNode = (CyNode)toTraverse.removeFirst();
            Set<CyNode> neighbors = CyNetworkUtils.getNeighbors(this.network, currentNode);
            for (CyNode nb : neighbors) {
                if (aTraversed.contains(nb)) continue;
                ++size;
                toTraverse.add(nb);
                aTraversed.add(nb);
            }
        }
        return size;
    }
}

