/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.network.merge.internal.ui;

import java.util.ArrayList;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.network.merge.internal.model.MatchingAttribute;

class MatchNodeTable
extends JTable {
    private final MatchingAttribute matchingAttribute;
    private final MatchNodeTableModel model;

    public MatchNodeTable(MatchingAttribute matchingAttribute) {
        this.matchingAttribute = matchingAttribute;
        this.model = new MatchNodeTableModel();
        this.setModel(this.model);
    }

    protected void setColumnEditorAndCellRenderer() {
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String colName;
            TableColumn column = this.getColumnModel().getColumn(i);
            CyNetwork net = this.model.getNetork(i);
            CyTable table = net.getDefaultNodeTable();
            Vector<String> colNames = new Vector<String>();
            for (CyColumn cyCol : table.getColumns()) {
                colName = cyCol.getName();
                if (colName.equals("SUID")) continue;
                colNames.add(colName);
            }
            CyColumn cyCol = this.matchingAttribute.getAttributeForMatching(net);
            JComboBox comboBox = new JComboBox(colNames);
            if (cyCol != null) {
                colName = cyCol.getName();
                comboBox.setSelectedItem(colName);
            }
            column.setCellEditor(new DefaultCellEditor(comboBox));
        }
    }

    public void fireTableStructureChanged() {
        this.model.fireTableStructureChanged();
        this.setColumnEditorAndCellRenderer();
    }

    private class MatchNodeTableModel
    extends AbstractTableModel {
        ArrayList<CyNetwork> networks;

        public MatchNodeTableModel() {
            this.resetNetworks();
        }

        @Override
        public int getColumnCount() {
            return MatchNodeTable.this.matchingAttribute.getSizeNetwork();
        }

        @Override
        public int getRowCount() {
            int n = MatchNodeTable.this.matchingAttribute.getSizeNetwork();
            return n == 0 ? 0 : 1;
        }

        @Override
        public String getColumnName(int col) {
            return this.networks.get(col).toString();
        }

        @Override
        public Object getValueAt(int row, int col) {
            return MatchNodeTable.this.matchingAttribute.getAttributeForMatching(this.networks.get(col)).getName();
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            CyNetwork net;
            CyTable table;
            CyColumn cyCol;
            if (value != null && (cyCol = (table = (net = this.networks.get(col)).getDefaultNodeTable()).getColumn((String)value)) != null) {
                MatchNodeTable.this.matchingAttribute.putAttributeForMatching(net, cyCol);
                this.fireTableDataChanged();
            }
        }

        @Override
        public void fireTableStructureChanged() {
            this.resetNetworks();
            super.fireTableStructureChanged();
        }

        private void resetNetworks() {
            this.networks = new ArrayList<CyNetwork>(MatchNodeTable.this.matchingAttribute.getNetworkSet());
        }

        public CyNetwork getNetork(int col) {
            return this.networks.get(col);
        }
    }
}

