/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.network.merge.internal.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.network.merge.internal.AttributeBasedNetworkMerge;
import org.cytoscape.network.merge.internal.NetworkMerge;
import org.cytoscape.network.merge.internal.conflict.AttributeConflictCollector;
import org.cytoscape.network.merge.internal.model.AttributeMapping;
import org.cytoscape.network.merge.internal.model.MatchingAttribute;
import org.cytoscape.network.merge.internal.task.FixAnnotationsTask;
import org.cytoscape.network.merge.internal.task.HandleConflictsTask;
import org.cytoscape.network.merge.internal.util.DefaultAttributeMerger;
import org.cytoscape.network.merge.internal.util.DefaultAttributeValueMatcher;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.create.CreateNetworkViewTaskFactory;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

public class NetworkMergeTask
extends AbstractTask
implements ObservableTask {
    private final List<CyNetwork> selectedNetworkList;
    private final NetworkMerge.Operation operation;
    private final boolean subtractOnlyUnconnectedNodes;
    private final AttributeConflictCollector conflictCollector;
    private final CreateNetworkViewTaskFactory netViewCreator;
    private final CyServiceRegistrar serviceRegistrar;
    private final MatchingAttribute matchingAttribute;
    private final AttributeMapping nodeAttributeMapping;
    private final AttributeMapping edgeAttributeMapping;
    private final AttributeMapping networkAttributeMapping;
    private boolean inNetworkMerge;
    private boolean nodesOnly;
    private final CyNetworkFactory cnf;
    private final CyNetworkManager networkManager;
    private final CyNetworkViewManager viewManager;
    private final AnnotationManager annotationManager;
    private final String networkName;
    private CyNetwork newNetwork;
    private AttributeBasedNetworkMerge networkMerge;

    public NetworkMergeTask(CyServiceRegistrar serviceRegistrar, String networkName, MatchingAttribute matchingAttribute, AttributeMapping nodeAttributeMapping, AttributeMapping edgeAttributeMapping, AttributeMapping networkAttributeMapping, List<CyNetwork> selectedNetworkList, NetworkMerge.Operation operation, boolean subtractOnlyUnconnectedNodes, AttributeConflictCollector conflictCollector, boolean inNetworkMerge, boolean nodesOnly) {
        this.serviceRegistrar = serviceRegistrar;
        this.selectedNetworkList = selectedNetworkList;
        this.operation = operation;
        this.subtractOnlyUnconnectedNodes = subtractOnlyUnconnectedNodes;
        this.conflictCollector = conflictCollector;
        this.matchingAttribute = matchingAttribute;
        this.inNetworkMerge = inNetworkMerge;
        this.nodesOnly = nodesOnly;
        this.nodeAttributeMapping = nodeAttributeMapping;
        this.edgeAttributeMapping = edgeAttributeMapping;
        this.networkAttributeMapping = networkAttributeMapping;
        this.networkName = networkName;
        this.cnf = (CyNetworkFactory)serviceRegistrar.getService(CyNetworkFactory.class);
        this.networkManager = (CyNetworkManager)serviceRegistrar.getService(CyNetworkManager.class);
        this.netViewCreator = (CreateNetworkViewTaskFactory)serviceRegistrar.getService(CreateNetworkViewTaskFactory.class);
        this.viewManager = (CyNetworkViewManager)serviceRegistrar.getService(CyNetworkViewManager.class);
        this.annotationManager = (AnnotationManager)serviceRegistrar.getService(AnnotationManager.class);
    }

    public void cancel() {
        this.cancelled = true;
        if (this.networkMerge != null) {
            this.networkMerge.interrupt();
        }
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setProgress(0.0);
        taskMonitor.setTitle("Merging Networks");
        Map<CyNetworkView, List<Annotation>> annotationMap = this.getAnnotations(this.selectedNetworkList);
        taskMonitor.setStatusMessage("Creating new merged network...");
        this.newNetwork = this.cnf.createNetwork();
        this.newNetwork.getRow((CyIdentifiable)this.newNetwork).set("name", (Object)this.networkName);
        this.networkManager.addNetwork(this.newNetwork);
        taskMonitor.setStatusMessage("Merging networks...");
        DefaultAttributeValueMatcher attributeValueMatcher = new DefaultAttributeValueMatcher();
        DefaultAttributeMerger attributeMerger = new DefaultAttributeMerger(this.conflictCollector);
        this.networkMerge = new AttributeBasedNetworkMerge(this.matchingAttribute, this.nodeAttributeMapping, this.edgeAttributeMapping, this.networkAttributeMapping, attributeMerger, attributeValueMatcher, taskMonitor);
        this.networkMerge.setWithinNetworkMerge(this.inNetworkMerge);
        this.networkMerge.mergeNetwork(this.newNetwork, this.selectedNetworkList, this.operation, this.subtractOnlyUnconnectedNodes, this.nodesOnly);
        if (!this.conflictCollector.isEmpty() && !this.cancelled) {
            taskMonitor.setStatusMessage("Processing conflicts...");
            HandleConflictsTask hcTask = new HandleConflictsTask(this.conflictCollector);
            this.insertTasksAfterCurrentTask(new Task[]{hcTask});
        }
        if (this.cancelled) {
            taskMonitor.setStatusMessage("Network merge canceled.");
            taskMonitor.setProgress(1.0);
            this.networkManager.destroyNetwork(this.newNetwork);
            this.newNetwork = null;
            this.networkMerge = null;
            return;
        }
        if (annotationMap.size() > 0) {
            FixAnnotationsTask fixAnnotationsTask = new FixAnnotationsTask(this.serviceRegistrar, this.newNetwork, annotationMap);
            this.insertTasksAfterCurrentTask(new Task[]{fixAnnotationsTask});
        }
        taskMonitor.setStatusMessage("Creating view...");
        HashSet<CyNetwork> networks = new HashSet<CyNetwork>();
        networks.add(this.newNetwork);
        this.insertTasksAfterCurrentTask(this.netViewCreator.createTaskIterator(networks));
        taskMonitor.setProgress(1.0);
    }

    private Map<CyNetworkView, List<Annotation>> getAnnotations(List<CyNetwork> networkList) {
        HashMap<CyNetworkView, List<Annotation>> annotationMap = new HashMap<CyNetworkView, List<Annotation>>();
        ArrayList viewList = new ArrayList(networkList.size());
        for (CyNetwork network : this.selectedNetworkList) {
            if (!this.viewManager.viewExists(network)) continue;
            viewList.addAll(this.viewManager.getNetworkViews(network));
        }
        for (CyNetworkView view : viewList) {
            List annotations = this.annotationManager.getAnnotations(view);
            if (annotations == null || annotations.size() <= 0) continue;
            annotationMap.put(view, annotations);
        }
        return annotationMap;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, CyNetwork.class, JSONResult.class);
    }

    public <R> R getResults(Class<? extends R> type) {
        if (type.equals(CyNetwork.class)) {
            return (R)this.newNetwork;
        }
        if (type.equals(String.class)) {
            if (this.newNetwork == null) {
                return (R)"<none>";
            }
            return (R)this.newNetwork.toString();
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.newNetwork == null) {
                    return "{}";
                }
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                return cyJSONUtil.toJson(this.newNetwork);
            };
            return (R)res;
        }
        return (R)this.newNetwork;
    }
}

