/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.network.merge.internal.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationFactory;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.view.presentation.annotations.ArrowAnnotation;
import org.cytoscape.view.presentation.annotations.BoundedTextAnnotation;
import org.cytoscape.view.presentation.annotations.GroupAnnotation;
import org.cytoscape.view.presentation.annotations.ImageAnnotation;
import org.cytoscape.view.presentation.annotations.ShapeAnnotation;
import org.cytoscape.view.presentation.annotations.TextAnnotation;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class FixAnnotationsTask
extends AbstractTask {
    private final CyServiceRegistrar serviceRegistrar;
    private final CyNetworkViewManager viewManager;
    private final AnnotationManager annotationManager;
    private final CyNetwork newNetwork;
    private final Map<CyNetworkView, List<Annotation>> annotationMap;

    public FixAnnotationsTask(CyServiceRegistrar serviceRegistrar, CyNetwork newNetwork, Map<CyNetworkView, List<Annotation>> annotationMap) {
        this.serviceRegistrar = serviceRegistrar;
        this.viewManager = (CyNetworkViewManager)serviceRegistrar.getService(CyNetworkViewManager.class);
        this.annotationManager = (AnnotationManager)serviceRegistrar.getService(AnnotationManager.class);
        this.newNetwork = newNetwork;
        this.annotationMap = annotationMap;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setStatusMessage("Fixing annotations...");
        CyNetworkView newNetworkView = (CyNetworkView)new ArrayList(this.viewManager.getNetworkViews(this.newNetwork)).get(0);
        ArrayList<Annotation> newAnnotations = new ArrayList<Annotation>();
        for (CyNetworkView view : this.annotationMap.keySet()) {
            double centerX = (Double)view.getVisualProperty(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION);
            double centerY = (Double)view.getVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION);
            for (Annotation ann : this.annotationMap.get(view)) {
                Map argMap = ann.getArgMap();
                double x = Double.parseDouble((String)argMap.get("x"));
                double y = Double.parseDouble((String)argMap.get("y"));
                argMap.put("x", String.valueOf(x - centerX));
                argMap.put("y", String.valueOf(y - centerY));
                Annotation newAnnotation = this.createAnnotation(argMap, ann, newNetworkView);
                newAnnotations.add(newAnnotation);
            }
        }
        this.annotationManager.addAnnotations(newAnnotations);
    }

    private Annotation createAnnotation(Map<String, String> argMap, Annotation ann, CyNetworkView newNetworkView) {
        String type = argMap.get("type");
        if (type.contains("ShapeAnnotation")) {
            AnnotationFactory factory = (AnnotationFactory)this.serviceRegistrar.getService(AnnotationFactory.class, "(type=ShapeAnnotation.class)");
            return factory.createAnnotation(ShapeAnnotation.class, newNetworkView, argMap);
        }
        if (type.contains("GroupAnnotation")) {
            AnnotationFactory factory = (AnnotationFactory)this.serviceRegistrar.getService(AnnotationFactory.class, "(type=GroupAnnotation.class)");
            return factory.createAnnotation(GroupAnnotation.class, newNetworkView, argMap);
        }
        if (type.contains("TextAnnotation")) {
            AnnotationFactory factory = (AnnotationFactory)this.serviceRegistrar.getService(AnnotationFactory.class, "(type=TextAnnotation.class)");
            return factory.createAnnotation(TextAnnotation.class, newNetworkView, argMap);
        }
        if (type.contains("BoundedTextAnnotation")) {
            AnnotationFactory factory = (AnnotationFactory)this.serviceRegistrar.getService(AnnotationFactory.class, "(type=BoundedTextAnnotation.class)");
            return factory.createAnnotation(BoundedTextAnnotation.class, newNetworkView, argMap);
        }
        if (type.contains("ImageAnnotation")) {
            AnnotationFactory factory = (AnnotationFactory)this.serviceRegistrar.getService(AnnotationFactory.class, "(type=ImageAnnotation.class)");
            return factory.createAnnotation(ImageAnnotation.class, newNetworkView, argMap);
        }
        if (type.contains("ArrowAnnotation")) {
            AnnotationFactory factory = (AnnotationFactory)this.serviceRegistrar.getService(AnnotationFactory.class, "(type=ArrowAnnotation.class)");
            return factory.createAnnotation(ArrowAnnotation.class, newNetworkView, argMap);
        }
        return null;
    }

    private AnnotationFactory<?> getAnnotationFactory(String type) {
        if (type.contains("ShapeAnnotation")) {
            return (AnnotationFactory)this.serviceRegistrar.getService(AnnotationFactory.class, "(type=ShapeAnnotation.class)");
        }
        if (type.contains("GroupAnnotation")) {
            return (AnnotationFactory)this.serviceRegistrar.getService(AnnotationFactory.class, "(type=GroupAnnotation.class)");
        }
        if (type.contains("TextAnnotation")) {
            return (AnnotationFactory)this.serviceRegistrar.getService(AnnotationFactory.class, "(type=TextAnnotation.class)");
        }
        if (type.contains("BoundedTextAnnotation")) {
            return (AnnotationFactory)this.serviceRegistrar.getService(AnnotationFactory.class, "(type=BoundedTextAnnotation.class)");
        }
        if (type.contains("ImageAnnotation")) {
            return (AnnotationFactory)this.serviceRegistrar.getService(AnnotationFactory.class, "(type=ImageAnnotation.class)");
        }
        if (type.contains("ArrowAnnotation")) {
            return (AnnotationFactory)this.serviceRegistrar.getService(AnnotationFactory.class, "(type=ArrowAnnotation.class)");
        }
        return null;
    }
}

