/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.network.merge.internal.conflict;

import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.network.merge.internal.conflict.AttributeConflictCollector;
import org.cytoscape.network.merge.internal.conflict.AttributeConflictHandler;

public class AttributeConflictManager {
    final AttributeConflictCollector conflictCollector;
    final List<AttributeConflictHandler> conflictHandlers;

    public AttributeConflictManager(AttributeConflictCollector conflictCollector, List<AttributeConflictHandler> conflictHandlers) {
        if (conflictCollector == null || conflictHandlers == null) {
            throw new NullPointerException();
        }
        if (conflictHandlers.isEmpty()) {
            throw new IllegalArgumentException("No conflict handler");
        }
        this.conflictCollector = conflictCollector;
        this.conflictHandlers = conflictHandlers;
    }

    public void handleConflicts() {
        Map<CyIdentifiable, CyColumn> mapToIDToAttr = this.conflictCollector.getMapToGOAttr();
        block0: for (Map.Entry<CyIdentifiable, CyColumn> entryToIDToAttr : mapToIDToAttr.entrySet()) {
            CyIdentifiable toID = entryToIDToAttr.getKey();
            CyColumn toAttr = entryToIDToAttr.getValue();
            Map<CyIdentifiable, CyColumn> mapFromIDFromAttr = this.conflictCollector.getConflicts(toID, toAttr);
            for (AttributeConflictHandler handler : this.conflictHandlers) {
                if (!handler.handleIt(toID, toAttr, mapFromIDFromAttr)) continue;
                this.conflictCollector.removeConflicts(toID, toAttr);
                continue block0;
            }
        }
    }
}

