/*
 * Decompiled with CFR 0.152.
 */
package csapps.layout.algorithms.hierarchicalLayout;

import csapps.layout.algorithms.hierarchicalLayout.Edge;
import csapps.layout.algorithms.hierarchicalLayout.Graph;
import csapps.layout.algorithms.hierarchicalLayout.HierarchicalLayoutContext;
import csapps.layout.algorithms.hierarchicalLayout.HierarchyFlowLayoutOrderNode;
import csapps.layout.algorithms.hierarchicalLayout.LayerOrderNode;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.layout.AbstractLayoutTask;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.values.Bend;
import org.cytoscape.view.presentation.property.values.BendFactory;
import org.cytoscape.view.presentation.property.values.Handle;
import org.cytoscape.view.presentation.property.values.HandleFactory;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.UndoSupport;

public class HierarchicalLayoutAlgorithmTask
extends AbstractLayoutTask {
    private HashMap<Integer, HierarchyFlowLayoutOrderNode> nodes2HFLON = new HashMap();
    private final HierarchicalLayoutContext context;
    private final CyServiceRegistrar serviceRegistrar;

    public HierarchicalLayoutAlgorithmTask(String displayName, CyNetworkView networkView, Set<View<CyNode>> nodesToLayOut, HierarchicalLayoutContext context, String attrName, UndoSupport undo, CyServiceRegistrar serviceRegistrar) {
        super(displayName, networkView, nodesToLayOut, attrName, undo);
        this.context = context;
        this.serviceRegistrar = serviceRegistrar;
    }

    protected void doLayout(TaskMonitor tm) {
        View ev;
        int nodeIndex;
        int i;
        int x;
        tm.setProgress(0.0);
        tm.setStatusMessage("Capturing snapshot of network and selected nodes...");
        if (this.cancelled) {
            return;
        }
        int numLayoutNodes = this.nodesToLayOut.size();
        if (numLayoutNodes == 1) {
            return;
        }
        HashMap<Long, Integer> suid2Index = new HashMap<Long, Integer>(numLayoutNodes);
        ArrayList nodeViews = new ArrayList(this.nodesToLayOut);
        int index = 0;
        for (Object view : nodeViews) {
            if (this.cancelled) {
                return;
            }
            CyNode node = (CyNode)view.getModel();
            Long suid = node.getSUID();
            suid2Index.put(suid, index);
            ++index;
        }
        if (this.cancelled) {
            return;
        }
        LinkedList<Edge> edges = new LinkedList<Edge>();
        for (View ev2 : this.networkView.getEdgeViewsIterable()) {
            if (this.cancelled) {
                return;
            }
            Integer edgeFrom = (Integer)suid2Index.get(((CyEdge)ev2.getModel()).getSource().getSUID());
            Integer edgeTo = (Integer)suid2Index.get(((CyEdge)ev2.getModel()).getTarget().getSUID());
            if (edgeFrom == null || edgeTo == null || numLayoutNodes > 1 && (edgeFrom >= numLayoutNodes || edgeTo >= numLayoutNodes)) continue;
            Edge theEdge = new Edge(edgeFrom, edgeTo);
            edges.add(theEdge);
        }
        Edge[] edge = new Edge[edges.size()];
        edges.toArray(edge);
        Graph graph = new Graph(numLayoutNodes, edge);
        int[] cI = graph.componentIndex();
        tm.setProgress(0.05);
        tm.setStatusMessage("Finding connected components...");
        if (this.cancelled) {
            return;
        }
        int[] renumber = new int[cI.length];
        Graph[] component = graph.partition(cI, renumber);
        int numComponents = component.length;
        int[][] layer = new int[numComponents][];
        int[][] horizontalPosition = new int[numComponents][];
        Graph[] reduced = new Graph[component.length];
        Graph[] reducedTmp = new Graph[component.length];
        HashMap[] dummy2Edge = new HashMap[component.length];
        int[] dummyStartForComp = new int[component.length];
        HashMap[] myEdges2EdgeViews = new HashMap[component.length];
        for (x = 0; x < component.length; ++x) {
            int dummyStart;
            tm.setStatusMessage("Making acyclic transitive reduction...");
            Thread.yield();
            if (this.cancelled) {
                return;
            }
            reducedTmp[x] = component[x].getReducedGraph();
            tm.setStatusMessage("Layering nodes vertically...");
            Thread.yield();
            if (this.cancelled) {
                return;
            }
            layer[x] = reducedTmp[x].getVertexLayers();
            LinkedList<Integer> layerWithDummy = new LinkedList<Integer>();
            for (int i2 = 0; i2 < layer[x].length; ++i2) {
                layerWithDummy.add(layer[x][i2]);
            }
            Edge[] allEdges = component[x].GetEdges();
            LinkedList<Edge> edgesWithAdd = new LinkedList<Edge>();
            dummyStartForComp[x] = dummyStart = component[x].getNodecount();
            dummy2Edge[x] = new HashMap();
            for (int i3 = 0; i3 < allEdges.length; ++i3) {
                int to;
                if (this.cancelled) {
                    return;
                }
                int from = allEdges[i3].getFrom();
                if (layer[x][from] == layer[x][to = allEdges[i3].getTo()] + 1) {
                    edgesWithAdd.add(allEdges[i3]);
                    continue;
                }
                if (layer[x][from] < layer[x][to]) {
                    int tmp = from;
                    from = to;
                    to = tmp;
                }
                layerWithDummy.add(layer[x][to] + 1);
                dummy2Edge[x].put(layerWithDummy.size() - 1, allEdges[i3]);
                edgesWithAdd.add(new Edge(layerWithDummy.size() - 1, to));
                for (int j = layer[x][to] + 2; j < layer[x][from]; ++j) {
                    layerWithDummy.add(j);
                    dummy2Edge[x].put(layerWithDummy.size() - 1, allEdges[i3]);
                    edgesWithAdd.add(new Edge(layerWithDummy.size() - 1, layerWithDummy.size() - 2));
                }
                edgesWithAdd.add(new Edge(from, layerWithDummy.size() - 1));
            }
            allEdges = new Edge[edgesWithAdd.size()];
            edgesWithAdd.toArray(allEdges);
            reduced[x] = new Graph(layerWithDummy.size(), allEdges);
            reduced[x].setDummyNodesStart(dummyStart);
            reduced[x].setReduced(true);
            int[] layerNew = new int[layerWithDummy.size()];
            Iterator iter = layerWithDummy.iterator();
            for (int i4 = 0; i4 < layerNew.length; ++i4) {
                layerNew[i4] = (Integer)iter.next();
            }
            layer[x] = layerNew;
            tm.setStatusMessage("Positioning nodes within layer...");
            Thread.yield();
            if (this.cancelled) {
                return;
            }
            horizontalPosition[x] = reduced[x].getHorizontalPositionReverse(layer[x]);
            this.setProgress(tm, 0.05f, (float)x / (float)component.length, 0.15f);
        }
        tm.setProgress(0.15);
        int resize = renumber.length;
        for (int i5 = 0; i5 < component.length; ++i5) {
            resize += layer[i5].length - dummyStartForComp[i5];
        }
        int[] newRenumber = new int[resize];
        int[] newcI = new int[resize];
        for (int i6 = 0; i6 < renumber.length; ++i6) {
            newRenumber[i6] = renumber[i6];
            newcI[i6] = cI[i6];
        }
        int t = renumber.length;
        for (i = 0; i < reduced.length; ++i) {
            int j = reduced[i].getDummyNodesStart();
            while (j < reduced[i].getNodecount()) {
                newRenumber[t] = j++;
                newcI[t] = i;
                ++t;
            }
        }
        tm.setProgress(0.2);
        renumber = newRenumber;
        cI = newcI;
        edges = new LinkedList();
        for (i = 0; i < reduced.length; ++i) {
            edge = reduced[i].GetEdges();
            for (int j = 0; j < edge.length; ++j) {
                int from = -1;
                int to = -1;
                for (int k = 0; k < cI.length; ++k) {
                    if (this.cancelled) {
                        return;
                    }
                    if (cI[k] == i && renumber[k] == edge[j].getFrom()) {
                        from = k;
                    }
                    if (cI[k] == i && renumber[k] == edge[j].getTo()) {
                        to = k;
                    }
                    if (from != -1 && to != -1) break;
                }
                edges.add(new Edge(from, to));
            }
            this.setProgress(tm, 0.2f, (float)i / (float)reduced.length, 0.3f);
        }
        edge = new Edge[edges.size()];
        edges.toArray(edge);
        graph = new Graph(resize, edge);
        tm.setProgress(0.3);
        tm.setStatusMessage("Repositioning nodes in view...");
        Thread.yield();
        if (this.cancelled) {
            return;
        }
        Object[] flowLayoutOrder = new HierarchyFlowLayoutOrderNode[resize];
        for (x = 0; x < resize; ++x) {
            if (this.cancelled) {
                return;
            }
            flowLayoutOrder[x] = x < numLayoutNodes ? new HierarchyFlowLayoutOrderNode((View<CyNode>)((View)nodeViews.get(x)), cI[x], reduced[cI[x]].getNodecount(), layer[cI[x]][renumber[x]], horizontalPosition[cI[x]][renumber[x]], x) : new HierarchyFlowLayoutOrderNode(null, cI[x], reduced[cI[x]].getNodecount(), layer[cI[x]][renumber[x]], horizontalPosition[cI[x]][renumber[x]], x);
            this.nodes2HFLON.put(x, (HierarchyFlowLayoutOrderNode)flowLayoutOrder[x]);
            this.setProgress(tm, 0.3f, (float)x / (float)resize, 0.4f);
        }
        tm.setProgress(0.4);
        Arrays.sort(flowLayoutOrder);
        int lastComponent = -1;
        int lastLayer = -1;
        int startBandY = this.context.topEdge;
        int cleanBandY = this.context.topEdge;
        int startComponentX = this.context.leftEdge;
        int cleanComponentX = this.context.leftEdge;
        int startLayerY = this.context.topEdge;
        int cleanLayerY = this.context.topEdge;
        int cleanLayerX = this.context.leftEdge;
        int[] layerStart = new int[numLayoutNodes + 1];
        int lastComponentEnd = -1;
        for (nodeIndex = 0; nodeIndex < resize; ++nodeIndex) {
            int currentRight;
            int currentBottom;
            if (this.cancelled) {
                return;
            }
            Object node = flowLayoutOrder[nodeIndex];
            int currentComponent = ((HierarchyFlowLayoutOrderNode)node).componentNumber;
            int currentLayer = ((HierarchyFlowLayoutOrderNode)node).layer;
            View<CyNode> currentView = ((HierarchyFlowLayoutOrderNode)node).nodeView;
            tm.setStatusMessage("Layering nodes vertically...");
            Thread.yield();
            if (lastComponent == -1) {
                lastComponent = currentComponent;
                lastLayer = currentLayer;
                layerStart[currentLayer] = -1;
            }
            if (lastComponent != currentComponent) {
                int[] minXArray = new int[1];
                int maxX = this.horizontalNodePositioning(nodeIndex - ((HierarchyFlowLayoutOrderNode)flowLayoutOrder[nodeIndex - 1]).componentSize, nodeIndex - 1, (HierarchyFlowLayoutOrderNode[])flowLayoutOrder, graph, renumber, cI, dummyStartForComp, minXArray);
                int minX = minXArray[0];
                lastComponentEnd = nodeIndex - 1;
                for (int i7 = nodeIndex - ((HierarchyFlowLayoutOrderNode)flowLayoutOrder[nodeIndex - 1]).componentSize; i7 <= nodeIndex - 1; ++i7) {
                    ((HierarchyFlowLayoutOrderNode)flowLayoutOrder[i7]).xPos -= minX - startComponentX;
                }
                layerStart[lastLayer] = startComponentX;
                if ((maxX -= minX - startComponentX) > (startComponentX = cleanComponentX + this.context.componentSpacing)) {
                    startComponentX = maxX + this.context.componentSpacing;
                }
                if (startComponentX > this.context.rightMargin) {
                    cleanBandY = startBandY = cleanBandY + this.context.bandGap;
                    startComponentX = this.context.leftEdge;
                    cleanComponentX = this.context.leftEdge;
                }
                cleanLayerY = startLayerY = startBandY;
                cleanLayerX = startComponentX;
                layerStart[currentLayer] = -1;
            } else if (lastLayer != currentLayer) {
                layerStart[lastLayer] = startComponentX;
                cleanLayerY = startLayerY = cleanLayerY + this.context.nodeVerticalSpacing;
                cleanLayerX = startComponentX;
                layerStart[currentLayer] = -1;
            }
            ((HierarchyFlowLayoutOrderNode)node).setXPos(cleanLayerX);
            ((HierarchyFlowLayoutOrderNode)node).setYPos(startLayerY);
            cleanLayerX += this.context.nodeHorizontalSpacing;
            if (currentView != null) {
                currentBottom = startLayerY + ((Double)currentView.getVisualProperty(BasicVisualLexicon.NODE_HEIGHT)).intValue();
                currentRight = cleanLayerX + ((Double)currentView.getVisualProperty(BasicVisualLexicon.NODE_WIDTH)).intValue();
            } else {
                currentBottom = startLayerY;
                currentRight = cleanLayerX;
            }
            if (currentBottom > cleanBandY) {
                cleanBandY = currentBottom;
            }
            if (currentRight > cleanComponentX) {
                cleanComponentX = currentRight;
            }
            if (currentBottom > cleanLayerY) {
                cleanLayerY = currentBottom;
            }
            if (currentRight > cleanLayerX) {
                cleanLayerX = currentRight;
            }
            lastComponent = currentComponent;
            lastLayer = currentLayer;
            this.setProgress(tm, 0.4f, (float)nodeIndex / (float)resize, 0.8f);
        }
        tm.setProgress(0.8);
        if (this.cancelled) {
            return;
        }
        int[] minXArray = new int[1];
        this.horizontalNodePositioning(lastComponentEnd + 1, resize - 1, (HierarchyFlowLayoutOrderNode[])flowLayoutOrder, graph, renumber, cI, dummyStartForComp, minXArray);
        int minX = minXArray[0];
        for (int i8 = lastComponentEnd + 1; i8 < resize; ++i8) {
            ((HierarchyFlowLayoutOrderNode)flowLayoutOrder[i8]).xPos -= minX - startComponentX;
        }
        int edgeCount = ((CyNetwork)this.networkView.getModel()).getEdgeCount();
        int count = 0;
        for (View ev3 : this.networkView.getEdgeViewsIterable()) {
            if (this.cancelled) {
                return;
            }
            Integer edgeFrom = (Integer)suid2Index.get(((CyEdge)ev3.getModel()).getSource().getSUID());
            Integer edgeTo = (Integer)suid2Index.get(((CyEdge)ev3.getModel()).getTarget().getSUID());
            if (edgeFrom == null || edgeTo == null) continue;
            if (numLayoutNodes <= 1 || edgeFrom < numLayoutNodes && edgeTo < numLayoutNodes) {
                Edge theEdge = component[cI[edgeFrom]].GetTheEdge(renumber[edgeFrom], renumber[edgeTo]);
                if (myEdges2EdgeViews[cI[edgeFrom]] == null) {
                    myEdges2EdgeViews[cI[edgeFrom.intValue()]] = new HashMap();
                }
                myEdges2EdgeViews[cI[edgeFrom]].put(theEdge, ev3);
            }
            this.setProgress(tm, 0.8f, (float)count / (float)edgeCount, 0.9f);
            ++count;
        }
        tm.setProgress(0.9);
        for (nodeIndex = 0; nodeIndex < resize; ++nodeIndex) {
            if (this.cancelled) {
                return;
            }
            Object node = flowLayoutOrder[nodeIndex];
            if (((HierarchyFlowLayoutOrderNode)node).nodeView == null) continue;
            View<CyNode> currentView = ((HierarchyFlowLayoutOrderNode)node).nodeView;
            currentView.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)((HierarchyFlowLayoutOrderNode)node).getXPos());
            currentView.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)((HierarchyFlowLayoutOrderNode)node).getYPos());
        }
        tm.setProgress(0.925);
        HandleFactory handleFactory = (HandleFactory)this.serviceRegistrar.getService(HandleFactory.class);
        BendFactory bendFactory = (BendFactory)this.serviceRegistrar.getService(BendFactory.class);
        for (nodeIndex = 0; nodeIndex < resize; ++nodeIndex) {
            Edge theEdge;
            if (this.cancelled) {
                return;
            }
            Object node = flowLayoutOrder[nodeIndex];
            if (((HierarchyFlowLayoutOrderNode)node).nodeView != null || (ev = (View)myEdges2EdgeViews[cI[((HierarchyFlowLayoutOrderNode)node).graphIndex]].get(theEdge = (Edge)dummy2Edge[cI[((HierarchyFlowLayoutOrderNode)node).graphIndex]].get(renumber[((HierarchyFlowLayoutOrderNode)node).graphIndex]))) == null) continue;
            View source = this.networkView.getNodeView(((CyEdge)ev.getModel()).getSource());
            View target = this.networkView.getNodeView(((CyEdge)ev.getModel()).getTarget());
            double k = (this.getYPositionOf((View<CyNode>)target) - this.getYPositionOf((View<CyNode>)source)) / (this.getXPositionOf((View<CyNode>)target) - this.getXPositionOf((View<CyNode>)source));
            double xPos = this.getXPositionOf((View<CyNode>)source);
            if (k != 0.0) {
                xPos += ((double)((HierarchyFlowLayoutOrderNode)node).yPos - this.getYPositionOf((View<CyNode>)source)) / k;
            }
            Bend b = bendFactory.createBend();
            Handle h = handleFactory.createHandle(this.networkView, ev, xPos, (double)((HierarchyFlowLayoutOrderNode)node).yPos);
            b.insertHandleAt(0, h);
            ev.setVisualProperty((VisualProperty)BasicVisualLexicon.EDGE_BEND, (Object)b);
        }
        tm.setProgress(0.95);
        block21: for (nodeIndex = 0; nodeIndex < resize; ++nodeIndex) {
            Edge theEdge;
            if (this.cancelled) {
                return;
            }
            Object node = flowLayoutOrder[nodeIndex];
            if (((HierarchyFlowLayoutOrderNode)node).nodeView != null || (ev = (View)myEdges2EdgeViews[cI[((HierarchyFlowLayoutOrderNode)node).graphIndex]].get(theEdge = (Edge)dummy2Edge[cI[((HierarchyFlowLayoutOrderNode)node).graphIndex]].get(renumber[((HierarchyFlowLayoutOrderNode)node).graphIndex]))) == null) continue;
            List handles = ((Bend)ev.getVisualProperty((VisualProperty)BasicVisualLexicon.EDGE_BEND)).getAllHandles();
            for (Handle h : handles) {
                Point2D handelPt = h.calculateHandleLocation(this.networkView, ev);
                if (handelPt.getY() != (double)((HierarchyFlowLayoutOrderNode)node).yPos) continue;
                h.defineHandle(this.networkView, ev, (double)((HierarchyFlowLayoutOrderNode)node).xPos, (double)((HierarchyFlowLayoutOrderNode)node).yPos);
                continue block21;
            }
        }
        tm.setProgress(1.0);
    }

    private double getXPositionOf(View<CyNode> nodeView) {
        return (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
    }

    private double getYPositionOf(View<CyNode> nodeView) {
        return (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
    }

    private double edgeLength2Layers(HierarchyFlowLayoutOrderNode[] nodes, LinkedList<Integer>[] edgesFrom, LinkedList<Integer>[] edgesTo, int x, int direct, int startInd, int endInd) {
        int xHlp;
        double layerMin = 0.0;
        HashMap<Integer, HierarchyFlowLayoutOrderNode> nodesBak2HFLON = new HashMap<Integer, HierarchyFlowLayoutOrderNode>();
        for (int i = startInd; i <= endInd; ++i) {
            nodesBak2HFLON.put(nodes[i].graphIndex, nodes[i]);
        }
        if (direct == -1) {
            Integer neigh;
            double curPos;
            Iterator iterToHlp;
            for (xHlp = x; xHlp < nodes.length && nodes[xHlp].layer == nodes[x].layer; ++xHlp) {
                if (this.cancelled) {
                    return layerMin;
                }
                iterToHlp = edgesTo[nodes[xHlp].graphIndex].iterator();
                curPos = nodes[xHlp].xPos;
                while (iterToHlp.hasNext()) {
                    neigh = (Integer)iterToHlp.next();
                    layerMin += Math.abs((double)((HierarchyFlowLayoutOrderNode)nodesBak2HFLON.get((Object)neigh)).xPos - curPos) / (double)this.context.nodeHorizontalSpacing;
                }
            }
            for (xHlp = x - 1; xHlp >= 0 && nodes[xHlp].layer == nodes[x].layer; --xHlp) {
                if (this.cancelled) {
                    return layerMin;
                }
                iterToHlp = edgesTo[nodes[xHlp].graphIndex].iterator();
                curPos = nodes[xHlp].xPos;
                while (iterToHlp.hasNext()) {
                    neigh = (Integer)iterToHlp.next();
                    layerMin += Math.abs((double)((HierarchyFlowLayoutOrderNode)nodesBak2HFLON.get((Object)neigh)).xPos - curPos) / (double)this.context.nodeHorizontalSpacing;
                }
            }
        } else {
            Integer neigh;
            double curPos;
            Iterator iterFromHlp;
            for (xHlp = x; xHlp < nodes.length && nodes[xHlp].layer == nodes[x].layer; ++xHlp) {
                if (this.cancelled) {
                    return layerMin;
                }
                iterFromHlp = edgesFrom[nodes[xHlp].graphIndex].iterator();
                curPos = nodes[xHlp].xPos;
                while (iterFromHlp.hasNext()) {
                    neigh = (Integer)iterFromHlp.next();
                    layerMin += Math.abs((double)((HierarchyFlowLayoutOrderNode)nodesBak2HFLON.get((Object)neigh)).xPos - curPos) / (double)this.context.nodeHorizontalSpacing;
                }
            }
            for (xHlp = x - 1; xHlp >= 0 && nodes[xHlp].layer == nodes[x].layer; --xHlp) {
                if (this.cancelled) {
                    return layerMin;
                }
                iterFromHlp = edgesFrom[nodes[xHlp].graphIndex].iterator();
                curPos = nodes[xHlp].xPos;
                while (iterFromHlp.hasNext()) {
                    neigh = (Integer)iterFromHlp.next();
                    layerMin += Math.abs((double)((HierarchyFlowLayoutOrderNode)nodesBak2HFLON.get((Object)neigh)).xPos - curPos) / (double)this.context.nodeHorizontalSpacing;
                }
            }
        }
        return layerMin;
    }

    private int horizontalNodePositioning(int startInd, int endInd, HierarchyFlowLayoutOrderNode[] nodes, Graph theGraph, int[] renumber, int[] cI, int[] dummyStarts, int[] minX2Return) {
        int maxX = Integer.MIN_VALUE;
        LinkedList<Integer>[] edgesFrom = theGraph.GetEdgesFrom();
        LinkedList<Integer>[] edgesTo = theGraph.GetEdgesTo();
        Object[] lon = new LayerOrderNode[endInd - startInd + 1];
        HashMap<Integer, Object> ind2Lon = new HashMap<Integer, Object>();
        for (int i = 0; i <= endInd - startInd; ++i) {
            boolean dum = false;
            if (renumber[nodes[startInd + i].graphIndex] >= dummyStarts[cI[nodes[startInd + i].graphIndex]]) {
                dum = true;
            }
            lon[i] = new LayerOrderNode(startInd + i, dum, edgesFrom[nodes[startInd + i].graphIndex].size() + edgesTo[nodes[startInd + i].graphIndex].size(), nodes[startInd + i].layer);
            ind2Lon.put(startInd + i, lon[i]);
        }
        Arrays.sort(lon);
        int cur = 0;
        int x = ((LayerOrderNode)lon[0]).GetIndex();
        int direct = 1;
        int noOfSteps = 10 * (endInd - startInd + 1) - 4;
        double layerMin = 2.147483647E9;
        boolean newLayer = true;
        boolean dirFirst = true;
        for (int dx = 0; dx < noOfSteps; ++dx) {
            Integer neigh;
            if (this.cancelled) {
                return maxX;
            }
            if (newLayer) {
                layerMin = this.edgeLength2Layers(nodes, edgesFrom, edgesTo, x, direct, startInd, endInd);
                newLayer = false;
            }
            int idealPosXUp = 0;
            int idealPosXDown = 0;
            int neighsCountUp = 0;
            int neighsCountDown = 0;
            Iterator iterFrom = edgesFrom[nodes[x].graphIndex].iterator();
            Iterator iterTo = edgesTo[nodes[x].graphIndex].iterator();
            while (iterFrom.hasNext() && (direct == 1 || edgesTo[nodes[x].graphIndex].isEmpty() && direct == -1)) {
                if (this.cancelled) {
                    return maxX;
                }
                neigh = (Integer)iterFrom.next();
                if (this.nodes2HFLON.get((Object)neigh).layer != nodes[x].layer - 1) continue;
                idealPosXUp += this.nodes2HFLON.get((Object)neigh).xPos;
                ++neighsCountUp;
                if (renumber[this.nodes2HFLON.get((Object)neigh).graphIndex] < dummyStarts[cI[this.nodes2HFLON.get((Object)neigh).graphIndex]] || !((LayerOrderNode)ind2Lon.get(x)).GetIsDummy()) continue;
                idealPosXUp += 4 * this.nodes2HFLON.get((Object)neigh).xPos;
                neighsCountUp += 4;
            }
            while (iterTo.hasNext() && (direct == -1 || edgesFrom[nodes[x].graphIndex].isEmpty() && direct == 1)) {
                if (this.cancelled) {
                    return maxX;
                }
                neigh = (Integer)iterTo.next();
                if (this.nodes2HFLON.get((Object)neigh).layer != nodes[x].layer + 1) continue;
                idealPosXDown += this.nodes2HFLON.get((Object)neigh).xPos;
                ++neighsCountDown;
                if (renumber[this.nodes2HFLON.get((Object)neigh).graphIndex] < dummyStarts[cI[this.nodes2HFLON.get((Object)neigh).graphIndex]] || !((LayerOrderNode)ind2Lon.get(x)).GetIsDummy()) continue;
                idealPosXDown += 4 * this.nodes2HFLON.get((Object)neigh).xPos;
                neighsCountDown += 4;
            }
            if (neighsCountUp > 0 || neighsCountDown > 0) {
                int i;
                double w;
                boolean q;
                int idealPosX = neighsCountUp == 0 ? idealPosXDown / neighsCountDown : (neighsCountDown == 0 ? idealPosXUp / neighsCountUp : (idealPosXUp / neighsCountUp + idealPosXDown / neighsCountDown) / 2);
                if (idealPosX % this.context.nodeHorizontalSpacing != 0) {
                    idealPosX = idealPosX - nodes[x].xPos < this.context.nodeHorizontalSpacing ? idealPosX / this.context.nodeHorizontalSpacing * this.context.nodeHorizontalSpacing : (nodes[x].xPos - idealPosX < this.context.nodeHorizontalSpacing ? (idealPosX / this.context.nodeHorizontalSpacing + 1) * this.context.nodeHorizontalSpacing : (int)((double)(idealPosX / this.context.nodeHorizontalSpacing) + 0.5) * this.context.nodeHorizontalSpacing);
                }
                int oldXPos = nodes[x].xPos;
                nodes[x].xPos = idealPosX;
                HierarchyFlowLayoutOrderNode[] nodesBak = new HierarchyFlowLayoutOrderNode[nodes.length];
                for (int i2 = 0; i2 < nodes.length; ++i2) {
                    nodesBak[i2] = new HierarchyFlowLayoutOrderNode(nodes[i2]);
                }
                if (idealPosX > oldXPos && x < endInd && nodes[x + 1].layer == nodes[x].layer) {
                    q = false;
                    for (int i3 = x + 1; i3 <= endInd && !q && nodesBak[i3].layer == nodesBak[x].layer && nodesBak[i3].xPos < nodesBak[i3 - 1].xPos + this.context.nodeHorizontalSpacing; ++i3) {
                        nodesBak[i3].xPos = nodesBak[i3 - 1].xPos + this.context.nodeHorizontalSpacing;
                    }
                    if (this.cancelled) {
                        return maxX;
                    }
                    w = this.edgeLength2Layers(nodesBak, edgesFrom, edgesTo, x, direct, startInd, endInd);
                    if (!q && w <= layerMin) {
                        layerMin = w;
                        for (i = x + 1; i <= endInd && nodes[i].layer == nodes[x].layer && nodes[i].xPos < nodes[i - 1].xPos + this.context.nodeHorizontalSpacing; ++i) {
                            nodes[i].xPos = nodes[i - 1].xPos + this.context.nodeHorizontalSpacing;
                        }
                    } else {
                        nodes[x].xPos = nodes[x + 1].layer == nodes[x].layer ? nodes[x + 1].xPos - this.context.nodeHorizontalSpacing : oldXPos;
                    }
                } else if (idealPosX < oldXPos && x > 0 && nodes[x - 1].layer == nodes[x].layer) {
                    q = false;
                    for (int i4 = x - 1; i4 >= 0 && !q && nodesBak[i4].layer == nodesBak[x].layer && nodesBak[i4].xPos > nodesBak[i4 + 1].xPos - this.context.nodeHorizontalSpacing; --i4) {
                        nodesBak[i4].xPos = nodesBak[i4 + 1].xPos - this.context.nodeHorizontalSpacing;
                    }
                    w = this.edgeLength2Layers(nodesBak, edgesFrom, edgesTo, x, direct, startInd, endInd);
                    if (!q && w <= layerMin) {
                        layerMin = w;
                        for (i = x - 1; i >= 0 && nodes[i].layer == nodes[x].layer && nodes[i].xPos > nodes[i + 1].xPos - this.context.nodeHorizontalSpacing; --i) {
                            nodes[i].xPos = nodes[i + 1].xPos - this.context.nodeHorizontalSpacing;
                        }
                    } else {
                        nodes[x].xPos = nodes[x - 1].layer == nodes[x].layer ? nodes[x - 1].xPos + this.context.nodeHorizontalSpacing : oldXPos;
                    }
                }
            }
            if (startInd - endInd != 0 && dx % (startInd - endInd) == 0 && dx != 0) {
                if (!dirFirst) {
                    direct *= -1;
                    dirFirst = true;
                } else {
                    dirFirst = false;
                }
            }
            cur = (cur + direct + lon.length) % lon.length;
            if (nodes[x].layer != nodes[((LayerOrderNode)lon[cur]).GetIndex()].layer) {
                newLayer = true;
            }
            x = ((LayerOrderNode)lon[cur]).GetIndex();
        }
        int minX = Integer.MAX_VALUE;
        for (int i = startInd; i <= endInd; ++i) {
            if (nodes[i].getXPos() > maxX) {
                maxX = nodes[i].getXPos();
            }
            if (nodes[i].getXPos() >= minX) continue;
            minX = nodes[i].getXPos();
        }
        minX2Return[0] = minX;
        return maxX;
    }

    public String toString() {
        return "Hierarchical Layout";
    }

    public String getTitle() {
        return new String("Hierarchical Layout");
    }

    private void setProgress(TaskMonitor tm, float pb, float v, float nb) {
        float n = pb + v * (nb - pb);
        n = (float)Math.round(n * 1000.0f) / 1000.0f;
        tm.setProgress((double)n);
    }
}

