/*
 * Decompiled with CFR 0.152.
 */
package csapps.layout.algorithms.graphPartition;

import csapps.layout.algorithms.graphPartition.AttributeGridLayoutContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.layout.AbstractPartitionLayoutTask;
import org.cytoscape.view.layout.LayoutNode;
import org.cytoscape.view.layout.LayoutPartition;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.undo.UndoSupport;

public class AttributeGridLayoutTask
extends AbstractPartitionLayoutTask {
    private final AttributeGridLayoutContext context;

    public AttributeGridLayoutTask(String displayName, CyNetworkView networkView, Set<View<CyNode>> nodesToLayOut, AttributeGridLayoutContext context, String attrName, UndoSupport undo) {
        super(displayName, context.singlePartition, networkView, nodesToLayOut, attrName, undo);
        this.context = context;
    }

    public void layoutPartition(LayoutPartition partition) {
        ArrayList<LayoutNode> nodes = new ArrayList<LayoutNode>();
        for (LayoutNode ln : partition.getNodeList()) {
            if (ln.isLocked()) continue;
            nodes.add(ln);
        }
        int nodeCount = nodes.size();
        if (this.layoutAttribute != null && nodeCount > 0) {
            Class klass;
            CyColumn column = ((LayoutNode)nodes.get(0)).getRow().getTable().getColumn(this.layoutAttribute);
            Class clazz = klass = column == null ? null : column.getType();
            if (klass != null && Comparable.class.isAssignableFrom(klass)) {
                Collections.sort(nodes, new AttributeComparator(klass));
            }
        }
        partition.resetNodes();
        double initialX = 0.0;
        double initialY = 0.0;
        double nodeVerticalSpacing = this.context.nodeVerticalSpacing;
        double nodeHorizontalSpacing = this.context.nodeHorizontalSpacing;
        int columns = this.context.nColumns;
        if (columns <= 0) {
            columns = (int)Math.sqrt(nodeCount);
        }
        for (LayoutNode node : nodes) {
            initialX += node.getX() / (double)nodeCount;
            initialY += node.getY() / (double)nodeCount;
        }
        double currX = initialX -= nodeHorizontalSpacing * (double)(columns - 1) / 2.0;
        double currY = initialY -= nodeVerticalSpacing * (double)(columns - 1) / 2.0;
        int count = 0;
        for (LayoutNode node : nodes) {
            node.setX(currX);
            node.setY(currY);
            partition.moveNodeToLocation(node);
            if (++count == columns) {
                count = 0;
                currX = initialX;
                currY += nodeVerticalSpacing;
                continue;
            }
            currX += nodeHorizontalSpacing;
        }
    }

    private class AttributeComparator<T extends Comparable<T>>
    implements Comparator<LayoutNode> {
        Class<T> klass;

        private AttributeComparator(Class<T> klass) {
            this.klass = klass;
        }

        @Override
        public int compare(LayoutNode o1, LayoutNode o2) {
            Comparable v1 = (Comparable)o1.getRow().get(AttributeGridLayoutTask.this.layoutAttribute, this.klass);
            Comparable v2 = (Comparable)o2.getRow().get(AttributeGridLayoutTask.this.layoutAttribute, this.klass);
            if (String.class.isAssignableFrom(this.klass)) {
                String s1 = (String)String.class.cast(v1);
                String s2 = (String)String.class.cast(v2);
                if (s1 != null && s2 != null) {
                    return s1.compareToIgnoreCase(s2);
                }
                if (s1 == null && s2 != null) {
                    return -1;
                }
                if (s1 == null && s2 == null) {
                    return 0;
                }
                if (s1 != null && s2 == null) {
                    return 1;
                }
            } else {
                return this.compareEvenIfNull(v1, v2);
            }
            return 0;
        }

        public int compareEvenIfNull(T v1, T v2) {
            if (v1 != null && v2 != null) {
                return v1.compareTo(v2);
            }
            if (v1 == null && v2 != null) {
                return -1;
            }
            if (v1 == null && v2 == null) {
                return 0;
            }
            return 1;
        }
    }
}

