/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.internal.mappings;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.events.VisualMappingFunctionChangeRecord;
import org.cytoscape.view.vizmap.events.VisualMappingFunctionChangedEvent;
import org.cytoscape.view.vizmap.mappings.AbstractVisualMappingFunction;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;

public class DiscreteMappingImpl<K, V>
extends AbstractVisualMappingFunction<K, V>
implements DiscreteMapping<K, V> {
    private final Map<K, V> attribute2visualMap;
    private final Object lock = new Object();

    public DiscreteMappingImpl(String attrName, Class<K> attrType, VisualProperty<V> vp, CyEventHelper eventHelper) {
        super(attrName, attrType, vp, eventHelper);
        this.attribute2visualMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getMappedValue(CyRow row) {
        V value = null;
        if (row != null && row.isSet(this.columnName)) {
            CyColumn column = row.getTable().getColumn(this.columnName);
            Class attrClass = column.getType();
            if (attrClass.isAssignableFrom(List.class)) {
                List list = row.getList(this.columnName, column.getListElementType());
                if (list != null) {
                    for (Object item : list) {
                        String key = item.toString();
                        Object object = this.lock;
                        synchronized (object) {
                            value = this.attribute2visualMap.get(key);
                        }
                        if (value == null) continue;
                        break;
                    }
                }
            } else {
                Object key = row.get(this.columnName, this.columnType);
                if (key != null) {
                    Object object = this.lock;
                    synchronized (object) {
                        value = this.attribute2visualMap.get(key);
                    }
                }
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getMapValue(K key) {
        Object object = this.lock;
        synchronized (object) {
            return this.attribute2visualMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends V> void putMapValue(K key, T value) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            boolean containsKey = this.attribute2visualMap.containsKey(key);
            V oldValue = this.attribute2visualMap.put(key, value);
            changed = !containsKey || value == null && oldValue != null || value != null && !value.equals(oldValue);
        }
        if (changed) {
            this.eventHelper.addEventPayload((Object)this, (Object)new VisualMappingFunctionChangeRecord(), VisualMappingFunctionChangedEvent.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends V> void putAll(Map<K, T> map) {
        if (map != null) {
            Object object;
            boolean changed;
            boolean bl = changed = map.size() > this.attribute2visualMap.size();
            if (!changed) {
                object = this.lock;
                synchronized (object) {
                    changed = map.entrySet().stream().anyMatch(me -> {
                        V v1 = this.attribute2visualMap.get(me.getKey());
                        Object v2 = me.getValue();
                        return !this.attribute2visualMap.containsKey(me.getKey()) || v1 == null && v2 != null || v1 != null && !v1.equals(v2);
                    });
                }
            }
            if (changed) {
                object = this.lock;
                synchronized (object) {
                    this.attribute2visualMap.putAll(map);
                }
                this.eventHelper.addEventPayload((Object)this, (Object)new VisualMappingFunctionChangeRecord(), VisualMappingFunctionChangedEvent.class);
            }
        }
    }

    public Map<K, V> getAll() {
        return Collections.unmodifiableMap(this.attribute2visualMap);
    }

    public String toString() {
        return "Discrete Mapping";
    }
}

