/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.internal;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualLexiconNode;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.internal.AbstractApplyHandler;
import org.cytoscape.view.vizmap.internal.VisualStyleImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyToNetworkHandler
extends AbstractApplyHandler<CyNetwork> {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    ApplyToNetworkHandler(VisualStyle style, CyServiceRegistrar serviceRegistrar) {
        super(style, serviceRegistrar, CyNetwork.class, BasicVisualLexicon.NETWORK);
    }

    @Override
    public void apply(CyRow row, View<CyNetwork> view) {
        CyNetworkView netView = (CyNetworkView)view;
        Collection nodeViews = netView.getNodeViews();
        Collection edgeViews = netView.getEdgeViews();
        HashSet<CyNetworkView> networkViewSet = new HashSet<CyNetworkView>();
        networkViewSet.add(netView);
        this.updateDependencyMaps();
        view.clearVisualProperties();
        for (View v : nodeViews) {
            v.clearVisualProperties();
        }
        for (View v : edgeViews) {
            v.clearVisualProperties();
        }
        CyApplicationManager appMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        VisualLexicon lexicon = appMgr.getCurrentNetworkViewRenderer().getRenderingEngineFactory("").getVisualLexicon();
        this.applyDefaultsInParallel(netView, lexicon.getVisualLexiconNode(BasicVisualLexicon.NODE));
        this.applyDefaultsInParallel(netView, lexicon.getVisualLexiconNode(BasicVisualLexicon.EDGE));
        this.applyDefaultsInParallel(netView, lexicon.getVisualLexiconNode(BasicVisualLexicon.NETWORK));
        this.applyDependencies(netView);
        ExecutorService exe = Executors.newCachedThreadPool();
        Future<?> nodeFuture = exe.submit(new ApplyMappingsTask(netView, nodeViews, BasicVisualLexicon.NODE, lexicon));
        Future<?> edgeFuture = exe.submit(new ApplyMappingsTask(netView, edgeViews, BasicVisualLexicon.EDGE, lexicon));
        Future<?> netwFuture = exe.submit(new ApplyMappingsTask(netView, networkViewSet, BasicVisualLexicon.NETWORK, lexicon));
        try {
            exe.shutdown();
            try {
                nodeFuture.get();
            }
            catch (ExecutionException e) {
                logger.error("Error applying node visual properties", (Throwable)e);
            }
            try {
                edgeFuture.get();
            }
            catch (ExecutionException e) {
                logger.error("Error applying edge visual properties", (Throwable)e);
            }
            try {
                netwFuture.get();
            }
            catch (ExecutionException e) {
                logger.error("Error applying network visual properties", (Throwable)e);
            }
            exe.awaitTermination(15L, TimeUnit.MINUTES);
        }
        catch (Exception ex) {
            logger.warn("Create apply operation failed.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyDefaultsInParallel(CyNetworkView netView, VisualLexiconNode rootNode) {
        ExecutorService exe = Executors.newCachedThreadPool();
        ArrayDeque deque = new ArrayDeque();
        deque.addAll(rootNode.getChildren());
        while (!deque.isEmpty()) {
            VisualLexiconNode node = (VisualLexiconNode)deque.pop();
            VisualProperty vp = node.getVisualProperty();
            if (vp.getTargetDataType() != rootNode.getVisualProperty().getTargetDataType()) continue;
            Collection children = node.getChildren();
            if (children.isEmpty()) {
                Object defaultValue = this.style.getDefaultValue(vp);
                if (defaultValue == null) {
                    ((VisualStyleImpl)this.style).getStyleDefaults().put(vp, vp.getDefault());
                    defaultValue = this.style.getDefaultValue(vp);
                }
                exe.submit(new ApplyDefaultTask(netView, vp, defaultValue));
            }
            deque.addAll(children);
        }
        try {
            exe.shutdown();
            exe.awaitTermination(10L, TimeUnit.MINUTES);
        }
        catch (Exception ex) {
            logger.warn("Create apply default failed", (Throwable)ex);
        }
    }

    private void applyDependencies(CyNetworkView netView) {
        Set dependencies = this.style.getAllVisualPropertyDependencies();
        for (VisualPropertyDependency dep : dependencies) {
            VisualProperty parentVP = dep.getParentVisualProperty();
            if (!dep.isDependencyEnabled()) continue;
            HashSet<VisualProperty> vpSet = new HashSet<VisualProperty>(dep.getVisualProperties());
            vpSet.add(parentVP);
            Object defaultValue = this.style.getDefaultValue(parentVP);
            if (defaultValue == null) {
                defaultValue = parentVP.getDefault();
            }
            for (VisualProperty vp : vpSet) {
                netView.setViewDefault(vp, defaultValue);
            }
        }
    }

    private final class ApplyMappingsTask
    implements Runnable {
        private final CyNetworkView netView;
        private final Collection<? extends View<? extends CyIdentifiable>> views;
        private final VisualProperty<?> rootVisualProperty;
        private final VisualLexicon lexicon;

        ApplyMappingsTask(CyNetworkView netView, Collection<? extends View<? extends CyIdentifiable>> views, VisualProperty<?> rootVisualProperty, VisualLexicon lexicon) {
            this.netView = netView;
            this.views = views;
            this.rootVisualProperty = rootVisualProperty;
            this.lexicon = lexicon;
        }

        @Override
        public void run() {
            Class targetDataType = this.rootVisualProperty.getTargetDataType();
            LinkedList descendants = new LinkedList();
            descendants.addAll(this.lexicon.getVisualLexiconNode(this.rootVisualProperty).getChildren());
            while (!descendants.isEmpty()) {
                VisualLexiconNode node = (VisualLexiconNode)descendants.pop();
                VisualProperty vp = node.getVisualProperty();
                if (vp.getTargetDataType() != targetDataType) continue;
                VisualMappingFunction mapping = ApplyToNetworkHandler.this.style.getVisualMappingFunction(vp);
                if (mapping != null) {
                    CyNetwork net = (CyNetwork)this.netView.getModel();
                    Set depSet = (Set)ApplyToNetworkHandler.this.dependencyParents.get(vp);
                    for (View<? extends CyIdentifiable> view : this.views) {
                        Object value = mapping.getMappedValue(net.getRow((CyIdentifiable)view.getModel()));
                        if (value == null) continue;
                        if (!ApplyToNetworkHandler.this.isParentOfDependency(vp) && !ApplyToNetworkHandler.this.isChildOfEnabledDependency(vp)) {
                            view.setVisualProperty(vp, value);
                            continue;
                        }
                        if (depSet == null) continue;
                        for (VisualPropertyDependency dep : depSet) {
                            if (!dep.isDependencyEnabled()) continue;
                            ApplyToNetworkHandler.this.propagateValue(view, vp, value, dep.getVisualProperties(), false);
                        }
                    }
                }
                descendants.addAll(node.getChildren());
            }
        }
    }

    private final class ApplyDefaultTask
    implements Runnable {
        private final CyNetworkView netView;
        private final VisualProperty<?> vp;
        private final Object defaultValue;

        ApplyDefaultTask(CyNetworkView netView, VisualProperty<?> vp, Object defaultValue) {
            this.vp = vp;
            this.netView = netView;
            this.defaultValue = defaultValue;
        }

        @Override
        public void run() {
            this.netView.setViewDefault(this.vp, this.defaultValue);
        }
    }
}

