/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.internal;

import java.util.Collection;
import java.util.LinkedList;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.TableViewRenderer;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualLexiconNode;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.table.CyColumnView;
import org.cytoscape.view.presentation.property.table.BasicTableVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.internal.AbstractApplyHandler;

public class ApplyToColumnHandler
extends AbstractApplyHandler<CyColumn> {
    private VisualLexicon lexicon;

    public ApplyToColumnHandler(VisualStyle style, CyServiceRegistrar serviceRegistrar) {
        super(style, serviceRegistrar, CyColumn.class, BasicTableVisualLexicon.CELL);
    }

    @Override
    protected VisualLexicon getVisualLexicon() {
        if (this.lexicon == null) {
            CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
            TableViewRenderer tableViewRenderer = applicationManager.getDefaultTableViewRenderer();
            this.lexicon = tableViewRenderer.getRenderingEngineFactory("").getVisualLexicon();
        }
        return this.lexicon;
    }

    private boolean isCellVP(VisualProperty<?> vp) {
        VisualLexicon lexicon = this.getVisualLexicon();
        Collection descendants = lexicon.getAllDescendants(BasicTableVisualLexicon.CELL);
        return descendants.contains(vp);
    }

    protected void applyMappedValue(View<CyColumn> view, VisualProperty<?> vp, VisualMappingFunction<?, ?> mapping) {
        if (this.isCellVP(vp)) {
            ((CyColumnView)view).setCellVisualProperty(vp, arg_0 -> mapping.getMappedValue(arg_0));
        }
    }

    @Override
    public void apply(CyRow row, View<CyColumn> view) {
        if (this.updateDependencyMaps) {
            this.updateDependencyMaps();
        }
        view.batch(v -> {
            view.clearVisualProperties();
            VisualLexicon lexicon = this.getVisualLexicon();
            LinkedList descendants = new LinkedList();
            descendants.addAll(lexicon.getVisualLexiconNode(this.rootVisualProperty).getChildren());
            while (!descendants.isEmpty()) {
                VisualLexiconNode node = (VisualLexiconNode)descendants.pop();
                VisualProperty vp = node.getVisualProperty();
                if (vp.getTargetDataType() != this.targetDataType) continue;
                VisualMappingFunction mapping = this.style.getVisualMappingFunction(vp);
                if (mapping != null) {
                    this.applyMappedValue(view, vp, mapping);
                } else {
                    this.applyDefaultValue(view, vp, lexicon);
                }
                descendants.addAll(node.getChildren());
            }
        });
    }
}

