/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVisualMappingManager<V> {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    public static final String DEFAULT_STYLE_NAME = "default";
    protected VisualStyle defaultStyle;
    private volatile VisualStyle currentStyle;
    private final Map<V, VisualStyle> view2VisualStyleMap;
    private final Set<VisualStyle> visualStyles;
    private final CyServiceRegistrar serviceRegistrar;
    private final Object lock = new Object();

    public AbstractVisualMappingManager(VisualStyleFactory factory, CyServiceRegistrar serviceRegistrar) {
        if (serviceRegistrar == null) {
            throw new NullPointerException("'serviceRegistrar' cannot be null");
        }
        this.serviceRegistrar = serviceRegistrar;
        this.visualStyles = new HashSet<VisualStyle>();
        this.view2VisualStyleMap = new WeakHashMap<V, VisualStyle>();
        this.defaultStyle = this.buildGlobalDefaultStyle(factory);
        if (this.defaultStyle != null) {
            this.visualStyles.add(this.defaultStyle);
            this.currentStyle = this.defaultStyle;
        }
    }

    protected abstract VisualStyle buildGlobalDefaultStyle(VisualStyleFactory var1);

    protected abstract V getCurrentView();

    protected abstract void fireChangeEvent(VisualStyle var1, V var2);

    protected abstract void fireAddEvent(VisualStyle var1);

    protected abstract void fireRemoveEvent(VisualStyle var1);

    protected abstract void fireSetCurrentEvent(VisualStyle var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisualStyle getVisualStyle(V nv) {
        if (nv == null) {
            logger.warn("Attempting to get the visual style for a null network view; returning the default visual style.");
            return this.getDefaultVisualStyle();
        }
        Object object = this.lock;
        synchronized (object) {
            VisualStyle style = this.view2VisualStyleMap.get(nv);
            if (style == null) {
                style = this.getDefaultVisualStyle();
                this.view2VisualStyleMap.put((VisualStyle)nv, style);
            }
            return style;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisualStyle(VisualStyle vs, V nv) {
        if (nv == null) {
            throw new NullPointerException("Network view is null.");
        }
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            if (vs == null) {
                changed = this.view2VisualStyleMap.remove(nv) != null;
            } else {
                VisualStyle previousStyle = this.view2VisualStyleMap.put((VisualStyle)nv, vs);
                boolean bl = changed = !vs.equals(previousStyle);
            }
            if (!this.visualStyles.contains(vs)) {
                this.visualStyles.add(vs);
            }
        }
        if (changed) {
            this.fireChangeEvent(vs, nv);
            if (nv.equals(this.getCurrentView())) {
                this.setCurrentVisualStyle(vs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVisualStyle(VisualStyle vs) {
        if (vs == null) {
            throw new NullPointerException("Visual Style is null.");
        }
        if (vs == this.defaultStyle) {
            throw new IllegalArgumentException("Cannot remove default visual style.");
        }
        logger.debug("Visual Style about to be removed from VMM: " + vs.getTitle());
        this.fireRemoveEvent(vs);
        Object object = this.lock;
        synchronized (object) {
            this.visualStyles.remove(vs);
        }
        if (this.currentStyle == vs) {
            this.setCurrentVisualStyle(this.getDefaultVisualStyle());
        }
        HashSet<V> viewsToUpdate = new HashSet<V>();
        Iterator iterator = this.lock;
        synchronized (iterator) {
            if (this.view2VisualStyleMap.values().contains(vs)) {
                for (V view : this.view2VisualStyleMap.keySet()) {
                    if (!this.view2VisualStyleMap.get(view).equals(vs)) continue;
                    viewsToUpdate.add(view);
                }
            }
        }
        for (Object view : viewsToUpdate) {
            this.setVisualStyle(this.defaultStyle, view);
        }
        logger.debug("Total Number of VS in VMM after remove = " + this.visualStyles.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVisualStyle(VisualStyle vs) {
        if (vs == null) {
            logger.warn("Tried to add null to VMM.");
            return;
        }
        if (this.hasDuplicatedTitle(vs)) {
            String newTitle = this.getSuggestedTitle(vs.getTitle());
            vs.setTitle(newTitle);
        }
        Object object = this.lock;
        synchronized (object) {
            this.visualStyles.add(vs);
        }
        logger.debug("New visual Style registered to VMM: " + vs.getTitle());
        logger.debug("Total Number of VS in VMM = " + this.visualStyles.size());
        if (vs.getTitle() != null && vs.getTitle().equals(DEFAULT_STYLE_NAME)) {
            this.defaultStyle = vs;
        }
        this.fireAddEvent(vs);
    }

    private String getSuggestedTitle(String title) {
        int i = 0;
        Object suggesteTitle = title;
        while (true) {
            suggesteTitle = title + "_" + Integer.toString(i);
            boolean duplicated = false;
            for (VisualStyle exist_vs : this.getAllVisualStyles()) {
                if (!exist_vs.getTitle().equalsIgnoreCase((String)suggesteTitle)) continue;
                duplicated = true;
                break;
            }
            if (!duplicated) break;
            ++i;
        }
        return suggesteTitle;
    }

    private boolean hasDuplicatedTitle(VisualStyle vs) {
        if (this.getAllVisualStyles().size() == 0) {
            return false;
        }
        for (VisualStyle exist_vs : this.getAllVisualStyles()) {
            if (exist_vs.getTitle() == null || vs.getTitle() == null || !exist_vs.getTitle().equalsIgnoreCase(vs.getTitle())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<VisualStyle> getAllVisualStyles() {
        Object object = this.lock;
        synchronized (object) {
            return new HashSet<VisualStyle>(this.visualStyles);
        }
    }

    public VisualStyle getDefaultVisualStyle() {
        if (this.defaultStyle == null) {
            throw new IllegalStateException("No rendering engine is available, and cannot create default style.");
        }
        return this.defaultStyle;
    }

    public VisualStyle getCurrentVisualStyle() {
        return this.currentStyle;
    }

    public void setCurrentVisualStyle(VisualStyle newStyle) {
        if (newStyle == null) {
            newStyle = this.defaultStyle;
        }
        boolean changed = !newStyle.equals(this.currentStyle);
        this.currentStyle = newStyle;
        if (changed) {
            this.fireSetCurrentEvent(this.currentStyle);
        }
    }
}

