/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import javax.xml.bind.JAXBException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.io.read.InputStreamTaskFactory;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.reader.AttributeMappingParameters;
import org.cytoscape.tableimport.internal.reader.NetworkTableMappingParameters;
import org.cytoscape.tableimport.internal.reader.SupportedFileType;
import org.cytoscape.tableimport.internal.reader.TextDelimiter;
import org.cytoscape.tableimport.internal.reader.TextTableReader;
import org.cytoscape.tableimport.internal.reader.ontology.GeneAssociationTag;
import org.cytoscape.tableimport.internal.task.TableImportContext;
import org.cytoscape.tableimport.internal.ui.DataEvents;
import org.cytoscape.tableimport.internal.ui.OntologyPanelBuilder;
import org.cytoscape.tableimport.internal.ui.PreviewTablePanel;
import org.cytoscape.tableimport.internal.ui.theme.ImportDialogIcons;
import org.cytoscape.tableimport.internal.util.AttributeDataType;
import org.cytoscape.tableimport.internal.util.FileType;
import org.cytoscape.tableimport.internal.util.ImportType;
import org.cytoscape.tableimport.internal.util.SourceColumnSemantic;
import org.cytoscape.tableimport.internal.util.TypeUtil;
import org.cytoscape.tableimport.internal.util.URLUtil;
import org.cytoscape.util.swing.ColumnResizer;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportTablePanel
extends JPanel
implements PropertyChangeListener,
DataEvents {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String ID = "name";
    private JDialog advancedDialog;
    protected ButtonGroup attrTypeButtonGroup;
    protected JLabel attributeFileLabel;
    protected JButton browseAnnotationButton;
    protected JButton browseOntologyButton;
    protected JRadioButton edgeRadioButton;
    protected JRadioButton networkRadioButton;
    protected JComboBox<String> mappingAttributeComboBox;
    protected JRadioButton nodeRadioButton;
    protected JComboBox<String> ontologyComboBox;
    protected JButton selectAttributeFileButton;
    protected JComboBox<String> annotationComboBox;
    protected JTextField targetDataSourceTextField;
    private JPanel basicPanel;
    private JPanel dataSourcesPanel;
    private JPanel simpleAttributeImportPanel;
    private JPanel textImportOptionPanel;
    private JPanel annotationTblMappingPanel;
    private PreviewTablePanel previewPanel;
    private JButton advancedButton;
    protected JTextField defaultInteractionTextField;
    protected JSpinner startRowSpinner;
    protected JTextField commentLineTextField;
    private JLabel delimiterLabel;
    protected JCheckBox tabCheckBox;
    protected JCheckBox commaCheckBox;
    protected JCheckBox semicolonCheckBox;
    protected JCheckBox spaceCheckBox;
    protected JCheckBox otherCheckBox;
    protected JTextField otherDelimiterTextField;
    private JLabel decimalSeparatorLabel;
    protected ButtonGroup decimalSeparatorButtonGroup;
    protected JRadioButton commaDecimalSeparatorRadioButton;
    protected JRadioButton dotDecimalSeparatorRadioButton;
    protected JRadioButton otherDecimalSeparatorRadioButton;
    protected JTextField otherDecimalSeparatorTextField;
    private JCheckBox transferNameCheckBox;
    protected JTable aliasTable;
    protected JCheckBox importAllCheckBox;
    private TextTableReader.ObjectType objType;
    private final ImportType importType;
    protected Map<String, String> annotationUrlMap;
    protected Map<String, String> annotationFormatMap;
    protected Map<String, Map<String, String>> annotationAttributesMap;
    protected Map<String, String> ontologyUrlMap;
    protected Map<String, String> ontologyTypeMap;
    protected Map<String, String> ontologyDescriptionMap;
    private CyTable selectedAttributes;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private CyNetwork network;
    private final String fileType;
    private Workbook workbook;
    private OntologyPanelBuilder panelBuilder;
    private final InputStreamTaskFactory factory;
    private final TableImportContext tableImportContext;
    private final CyServiceRegistrar serviceRegistrar;
    private File tempFile;
    private boolean updating;

    public ImportTablePanel(ImportType importType, InputStream is, String fileType, InputStreamTaskFactory factory, TableImportContext tableImportContext, CyServiceRegistrar serviceRegistrar) throws JAXBException, IOException {
        this.factory = factory;
        this.tableImportContext = tableImportContext;
        this.serviceRegistrar = serviceRegistrar;
        this.fileType = fileType;
        if (importType != ImportType.ONTOLOGY_IMPORT) {
            this.tempFile = File.createTempFile("temp", this.fileType);
            this.tempFile.deleteOnExit();
            FileOutputStream os = new FileOutputStream(this.tempFile);
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = is.read(bytes)) != -1) {
                os.write(bytes, 0, read);
            }
            os.flush();
            os.close();
        }
        this.selectedAttributes = null;
        this.network = ((CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
        if (this.network != null) {
            this.selectedAttributes = this.network.getDefaultNodeTable();
        }
        this.objType = TextTableReader.ObjectType.NODE;
        this.importType = importType;
        this.annotationUrlMap = new HashMap<String, String>();
        this.annotationFormatMap = new HashMap<String, String>();
        this.annotationAttributesMap = new HashMap<String, Map<String, String>>();
        this.ontologyUrlMap = new HashMap<String, String>();
        this.ontologyDescriptionMap = new HashMap<String, String>();
        this.ontologyTypeMap = new HashMap<String, String>();
        this.initComponents();
        this.updateComponents();
        this.getPreviewPanel().addPropertyChangeListener(this);
        this.attributeFileLabel.setVisible(false);
        this.selectAttributeFileButton.setVisible(false);
        this.targetDataSourceTextField.setVisible(false);
        if (this.importType == ImportType.NETWORK_IMPORT) {
            this.edgeRadioButton.setVisible(false);
            this.nodeRadioButton.setVisible(false);
        }
        if (this.importType == ImportType.TABLE_IMPORT) {
            this.networkRadioButton.setVisible(false);
            if (tableImportContext != null) {
                tableImportContext.addPropertyChangeListener("keyRequired", evt -> this.getPreviewPanel().updateKeyType());
            }
        }
        try {
            this.setPreviewPanel();
        }
        catch (Exception e) {
            logger.error("Failed to create preview.  (Invalid input file)", (Throwable)e);
            throw new IOException("Fialed to create preview.", e);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.changes != null) {
            this.changes.addPropertyChangeListener(l);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("attrTypeChanged")) {
            SourceColumnSemantic type = null;
            int index = -1;
            if (evt instanceof IndexedPropertyChangeEvent) {
                type = (SourceColumnSemantic)((Object)((IndexedPropertyChangeEvent)evt).getNewValue());
                index = ((IndexedPropertyChangeEvent)evt).getIndex();
            }
            if (type == SourceColumnSemantic.KEY && index >= 0 && this.importType != ImportType.NETWORK_IMPORT) {
                this.getPreviewPanel().repaint();
                JTable table = this.getPreviewPanel().getPreviewTable();
                ColumnResizer.adjustColumnPreferredWidths((JTable)table);
                table.repaint();
            }
        }
    }

    private void initComponents() {
        this.attrTypeButtonGroup = new ButtonGroup();
        this.nodeRadioButton = new JRadioButton("Node");
        this.edgeRadioButton = new JRadioButton("Edge");
        this.networkRadioButton = new JRadioButton("Network");
        this.ontologyComboBox = new JComboBox();
        this.browseOntologyButton = new JButton("Browse...");
        this.annotationComboBox = new JComboBox();
        this.browseAnnotationButton = new JButton("Browse...");
        this.targetDataSourceTextField = new JTextField();
        this.selectAttributeFileButton = new JButton();
        this.mappingAttributeComboBox = new JComboBox();
        this.delimiterLabel = new JLabel("Delimiter:");
        this.delimiterLabel.setHorizontalAlignment(4);
        this.commaCheckBox = new JCheckBox("<html><b><font size=+1 face=Monospaced>,<font></b> <font size=-2>(comma)</font><html>");
        this.semicolonCheckBox = new JCheckBox("<html><b><font size=+1 face=Monospaced>;<font></b> <font size=-2>(semicolon)</font><html>");
        this.spaceCheckBox = new JCheckBox("<html><b><font size=-1 face=Monospaced>SPACE<font></b><html>");
        this.tabCheckBox = new JCheckBox("<html><b><font size=-1 face=Monospaced>TAB<font></b><html>");
        this.otherCheckBox = new JCheckBox("Other:");
        this.otherDelimiterTextField = new JTextField();
        this.decimalSeparatorLabel = new JLabel("Decimal separator:");
        this.decimalSeparatorLabel.setHorizontalAlignment(4);
        this.commaDecimalSeparatorRadioButton = new JRadioButton("<html><b><font size=+1 face=Monospaced>,<font></b> <font size=-2>(comma)</font><html>");
        this.dotDecimalSeparatorRadioButton = new JRadioButton("<html><b><font size=+1 face=Monospaced>.<font></b> <font size=-2>(dot)</font><html>");
        this.otherDecimalSeparatorRadioButton = new JRadioButton("Other:");
        this.otherDecimalSeparatorTextField = new JTextField();
        this.decimalSeparatorButtonGroup = new ButtonGroup();
        this.decimalSeparatorButtonGroup.add(this.commaDecimalSeparatorRadioButton);
        this.decimalSeparatorButtonGroup.add(this.dotDecimalSeparatorRadioButton);
        this.decimalSeparatorButtonGroup.add(this.otherDecimalSeparatorRadioButton);
        this.defaultInteractionTextField = new JTextField();
        this.attributeFileLabel = new JLabel();
        this.attrTypeButtonGroup.add(this.nodeRadioButton);
        this.attrTypeButtonGroup.add(this.edgeRadioButton);
        this.attrTypeButtonGroup.add(this.networkRadioButton);
        ToolTipManager tp = ToolTipManager.sharedInstance();
        tp.setInitialDelay(40);
        tp.setDismissDelay(50000);
        if (this.importType == ImportType.ONTOLOGY_IMPORT) {
            this.nodeRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.nodeRadioButton.setMargin(new Insets(0, 0, 0, 0));
            this.nodeRadioButton.setSelected(true);
            this.nodeRadioButton.addActionListener(evt -> this.attributeRadioButtonActionPerformed(evt));
            this.edgeRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.edgeRadioButton.setMargin(new Insets(0, 0, 0, 0));
            this.edgeRadioButton.addActionListener(evt -> this.attributeRadioButtonActionPerformed(evt));
            this.networkRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.networkRadioButton.setMargin(new Insets(0, 0, 0, 0));
            this.networkRadioButton.addActionListener(evt -> this.attributeRadioButtonActionPerformed(evt));
        }
        if (this.importType == ImportType.ONTOLOGY_IMPORT) {
            this.panelBuilder = new OntologyPanelBuilder(this, this.factory, this.serviceRegistrar);
            this.panelBuilder.buildPanel();
        }
        if (this.importType == ImportType.TABLE_IMPORT || this.importType == ImportType.NETWORK_IMPORT) {
            this.attributeFileLabel.setText("Input File");
            this.selectAttributeFileButton.setText("Select File(s)");
            this.selectAttributeFileButton.addActionListener(evt -> {
                try {
                    this.setPreviewPanel();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(((CySwingApplication)this.serviceRegistrar.getService(CySwingApplication.class)).getJFrame(), "<html>Could not read selected file.<p>See <b>Help->Error Dialog</b> for further details.</html>", "Error", 0);
                    logger.warn("Could not read selected file.", (Throwable)e);
                }
            });
        }
        if (this.importType == ImportType.ONTOLOGY_IMPORT) {
            this.mappingAttributeComboBox.setEnabled(true);
            this.mappingAttributeComboBox.addActionListener(evt -> {
                this.updateTypes(this.getPreviewPanel().getFileType());
                this.setKeyList();
            });
        }
        ChangeListener delimitersChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ImportTablePanel.this.otherDelimiterTextField.setEnabled(ImportTablePanel.this.otherCheckBox.isSelected());
                try {
                    if (!ImportTablePanel.this.updating) {
                        ImportTablePanel.this.updatePreview();
                    }
                }
                catch (IOException e) {
                    logger.error("Error on ChangeEvent of checkbox " + ((JCheckBox)evt.getSource()).getText(), (Throwable)e);
                }
            }
        };
        this.commaCheckBox.addChangeListener(delimitersChangeListener);
        this.semicolonCheckBox.addChangeListener(delimitersChangeListener);
        this.spaceCheckBox.addChangeListener(delimitersChangeListener);
        this.tabCheckBox.addChangeListener(delimitersChangeListener);
        this.otherCheckBox.addChangeListener(delimitersChangeListener);
        this.otherDelimiterTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent evt) {
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                try {
                    if (ImportTablePanel.this.otherCheckBox.isSelected()) {
                        ImportTablePanel.this.updatePreview();
                    }
                }
                catch (IOException e) {
                    logger.error("Error on otherDelimiterTextField.keyReleased", (Throwable)e);
                }
            }

            @Override
            public void keyTyped(KeyEvent evt) {
            }
        });
        ChangeListener decimalSeparatorChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ImportTablePanel.this.otherDecimalSeparatorTextField.setEnabled(ImportTablePanel.this.otherDecimalSeparatorRadioButton.isSelected());
                try {
                    if (!ImportTablePanel.this.updating) {
                        ImportTablePanel.this.updatePreview();
                    }
                }
                catch (IOException e) {
                    logger.error("Error on ChangeEvent of radio button " + ((JRadioButton)evt.getSource()).getText(), (Throwable)e);
                }
            }
        };
        this.commaDecimalSeparatorRadioButton.addChangeListener(decimalSeparatorChangeListener);
        this.dotDecimalSeparatorRadioButton.addChangeListener(decimalSeparatorChangeListener);
        this.otherDecimalSeparatorRadioButton.addChangeListener(decimalSeparatorChangeListener);
        this.otherDecimalSeparatorTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (ImportTablePanel.this.otherDecimalSeparatorTextField.getText().length() >= 1) {
                    e.consume();
                }
            }

            @Override
            public void keyPressed(KeyEvent evt) {
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                try {
                    if (ImportTablePanel.this.otherDecimalSeparatorRadioButton.isSelected()) {
                        ImportTablePanel.this.updatePreview();
                    }
                }
                catch (IOException e) {
                    logger.error("Error on otherDecimalSeparatorTextField.keyReleased", (Throwable)e);
                }
            }
        });
        this.defaultInteractionTextField.setText("interacts with");
        this.defaultInteractionTextField.setToolTipText("<html>If <b>Default Interaction</b> is selected, this value will be used for <i>Interaction Type</i><br></html>");
        this.globalLayout();
        if (this.basicPanel != null) {
            this.basicPanel.repaint();
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ImportTablePanel.this.getPreviewPanel().disposeEditDialog();
            }
        });
    }

    private JPanel getBasicPanel() {
        if (this.basicPanel == null) {
            this.basicPanel = new JPanel();
            GroupLayout layout = new GroupLayout(this.basicPanel);
            this.basicPanel.setLayout(layout);
            layout.setAutoCreateGaps(true);
            GroupLayout.ParallelGroup hGroup = layout.createParallelGroup(GroupLayout.Alignment.CENTER);
            GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
            if (this.importType == ImportType.ONTOLOGY_IMPORT) {
                hGroup.addComponent(this.getDataSourcesPanel(), -1, -1, Short.MAX_VALUE);
                vGroup.addComponent(this.getDataSourcesPanel(), -2, -1, -2);
            } else if (this.importType == ImportType.TABLE_IMPORT || this.importType == ImportType.NETWORK_IMPORT) {
                hGroup.addComponent(this.getSimpleAttributeImportPanel(), -1, -1, Short.MAX_VALUE);
                vGroup.addComponent(this.getSimpleAttributeImportPanel(), -2, -1, -2);
            }
        }
        return this.basicPanel;
    }

    private JPanel getDataSourcesPanel() {
        if (this.dataSourcesPanel == null) {
            this.dataSourcesPanel = new JPanel();
            this.dataSourcesPanel.setBorder(LookAndFeelUtil.createTitledBorder((String)"Data Sources"));
            JLabel dataTypeLabel = new JLabel("Data Type:");
            JLabel sourceLabel = new JLabel("Annotation:");
            JLabel ontologyLabel = new JLabel("Ontology:");
            GroupLayout layout = new GroupLayout(this.dataSourcesPanel);
            this.dataSourcesPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(dataTypeLabel).addComponent(sourceLabel).addComponent(ontologyLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.nodeRadioButton).addComponent(this.edgeRadioButton).addComponent(this.networkRadioButton)).addComponent(this.annotationComboBox, 0, 100, Short.MAX_VALUE).addComponent(this.ontologyComboBox, 0, 100, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.browseAnnotationButton).addComponent(this.browseOntologyButton)));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(dataTypeLabel).addComponent(this.nodeRadioButton).addComponent(this.edgeRadioButton).addComponent(this.networkRadioButton)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(sourceLabel).addComponent(this.annotationComboBox, -2, -1, -2).addComponent(this.browseAnnotationButton)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(ontologyLabel).addComponent(this.ontologyComboBox, -2, -1, -2).addComponent(this.browseOntologyButton)));
        }
        return this.dataSourcesPanel;
    }

    private JPanel getSimpleAttributeImportPanel() {
        if (this.simpleAttributeImportPanel == null) {
            this.simpleAttributeImportPanel = new JPanel();
            GroupLayout layout = new GroupLayout(this.simpleAttributeImportPanel);
            this.simpleAttributeImportPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.attributeFileLabel).addComponent(this.targetDataSourceTextField, -1, 300, Short.MAX_VALUE).addComponent(this.selectAttributeFileButton)));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.selectAttributeFileButton).addComponent(this.targetDataSourceTextField, -2, -1, -2).addComponent(this.attributeFileLabel)));
        }
        return this.simpleAttributeImportPanel;
    }

    private JPanel getTextImportOptionPanel() {
        if (this.textImportOptionPanel == null) {
            JSeparator sep;
            this.textImportOptionPanel = new JPanel();
            this.textImportOptionPanel.setBorder(LookAndFeelUtil.createTitledBorder((String)"File Import Options"));
            JLabel startRowLabel = new JLabel("Start Import Row:");
            startRowLabel.setHorizontalAlignment(4);
            JLabel commentLineLabel = new JLabel("Ignore Lines Starting With:");
            commentLineLabel.setHorizontalAlignment(4);
            JLabel defaultInteractionLabel = new JLabel("Default Interaction:");
            defaultInteractionLabel.setHorizontalAlignment(4);
            GroupLayout layout = new GroupLayout(this.textImportOptionPanel);
            this.textImportOptionPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            int lw = commentLineLabel.getPreferredSize().width;
            int rw = Math.max(this.getTransferNameCheckBox().getPreferredSize().width, this.getImportAllCheckBox().getPreferredSize().width);
            GroupLayout.ParallelGroup hGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING, true);
            GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
            if (!this.isSpreadsheetFile()) {
                sep = new JSeparator();
                hGroup.addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, true).addComponent(this.delimiterLabel, -2, lw, -2).addGap(lw).addGap(lw).addGap(lw).addGap(lw)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.commaCheckBox, rw, rw, Short.MAX_VALUE).addComponent(this.semicolonCheckBox, rw, rw, Short.MAX_VALUE).addComponent(this.spaceCheckBox, rw, rw, Short.MAX_VALUE).addComponent(this.tabCheckBox, rw, rw, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.otherCheckBox).addComponent(this.otherDelimiterTextField, -2, 80, -2)))).addComponent(sep, -1, -1, Short.MAX_VALUE);
                vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.delimiterLabel).addComponent(this.commaCheckBox)).addComponent(this.semicolonCheckBox).addComponent(this.spaceCheckBox).addComponent(this.tabCheckBox).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.otherCheckBox, -2, -1, -2).addComponent(this.otherDelimiterTextField, -2, -1, -2)).addComponent(sep, -2, -1, -2);
            }
            if (this.fileType == null || !this.fileType.equalsIgnoreCase(SupportedFileType.EXCEL.getExtension()) && !this.fileType.equalsIgnoreCase(SupportedFileType.OOXML.getExtension())) {
                sep = new JSeparator();
                hGroup.addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, true).addComponent(this.decimalSeparatorLabel, -2, lw, -2).addGap(lw).addGap(lw).addGap(lw).addGap(lw)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.dotDecimalSeparatorRadioButton, rw, rw, Short.MAX_VALUE).addComponent(this.commaDecimalSeparatorRadioButton, rw, rw, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.otherDecimalSeparatorRadioButton).addComponent(this.otherDecimalSeparatorTextField, -2, 80, -2)))).addComponent(sep, -1, -1, Short.MAX_VALUE);
                vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.decimalSeparatorLabel).addComponent(this.dotDecimalSeparatorRadioButton)).addComponent(this.commaDecimalSeparatorRadioButton).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.otherDecimalSeparatorRadioButton, -2, -1, -2).addComponent(this.otherDecimalSeparatorTextField, -2, -1, -2)).addComponent(sep, -2, -1, -2);
            }
            if (this.importType == ImportType.NETWORK_IMPORT) {
                sep = new JSeparator();
                hGroup.addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, true).addComponent(defaultInteractionLabel, -2, lw, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.defaultInteractionTextField, rw, rw, Short.MAX_VALUE))).addComponent(sep, -1, -1, Short.MAX_VALUE);
                vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(defaultInteractionLabel).addComponent(this.defaultInteractionTextField)).addComponent(sep, -2, -1, -2);
            }
            layout.setHorizontalGroup(hGroup.addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, true).addGap(lw).addComponent(startRowLabel, -2, lw, -2).addComponent(commentLineLabel, -2, lw, -2).addGap(lw)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.getTransferNameCheckBox(), rw, rw, Short.MAX_VALUE).addComponent(this.getStartRowSpinner(), -2, 54, -2).addComponent(this.getCommentLineTextField(), -2, 54, -2).addComponent(this.getImportAllCheckBox(), rw, rw, Short.MAX_VALUE))));
            layout.setVerticalGroup(vGroup.addComponent(this.getTransferNameCheckBox()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(startRowLabel).addComponent(this.getStartRowSpinner())).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(commentLineLabel).addComponent(this.getCommentLineTextField())).addComponent(this.getImportAllCheckBox()));
            if (this.importType != ImportType.ONTOLOGY_IMPORT) {
                this.getImportAllCheckBox().setVisible(false);
            }
        }
        return this.textImportOptionPanel;
    }

    private JPanel getAnnotationTblMappingPanel() {
        if (this.annotationTblMappingPanel == null) {
            this.annotationTblMappingPanel = new JPanel();
            this.annotationTblMappingPanel.setBorder(LookAndFeelUtil.createTitledBorder((String)"Annotation File to Table Mapping"));
            JLabel netKeyLabel = new JLabel("Key Column for Network:");
            GroupLayout layout = new GroupLayout(this.annotationTblMappingPanel);
            this.annotationTblMappingPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(netKeyLabel).addComponent(this.mappingAttributeComboBox, 320, 320, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(netKeyLabel).addComponent(this.mappingAttributeComboBox, -2, -1, -2));
            this.annotationTblMappingPanel.setVisible(this.importType == ImportType.ONTOLOGY_IMPORT);
        }
        return this.annotationTblMappingPanel;
    }

    protected PreviewTablePanel getPreviewPanel() {
        if (this.previewPanel == null) {
            if (this.importType == ImportType.ONTOLOGY_IMPORT) {
                this.getCommentLineTextField().setText("!");
                this.getImportAllCheckBox().setEnabled(false);
            }
            this.previewPanel = new PreviewTablePanel(this.importType, this.tableImportContext, (IconManager)this.serviceRegistrar.getService(IconManager.class));
        }
        return this.previewPanel;
    }

    protected JButton getAdvancedButton() {
        if (this.advancedButton == null) {
            this.advancedButton = new JButton("Advanced Options...");
            this.advancedButton.addActionListener(e -> this.showAdvancedDialog());
        }
        return this.advancedButton;
    }

    protected void showAdvancedDialog() {
        if (this.advancedDialog == null) {
            this.advancedDialog = new JDialog(SwingUtilities.getWindowAncestor(this), Dialog.ModalityType.DOCUMENT_MODAL);
            this.advancedDialog.setDefaultCloseOperation(1);
            this.advancedDialog.setResizable(false);
            this.advancedDialog.setTitle("Import - Advanced Options");
            JButton okButton = new JButton(new AbstractAction("OK"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportTablePanel.this.advancedDialog.setVisible(false);
                }
            });
            JPanel contentPane = new JPanel();
            GroupLayout layout = new GroupLayout(contentPane);
            contentPane.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            GroupLayout.ParallelGroup hGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING, true);
            GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
            if (this.importType == ImportType.TABLE_IMPORT || this.importType == ImportType.ONTOLOGY_IMPORT) {
                hGroup.addComponent(this.getAnnotationTblMappingPanel(), -1, -1, Short.MAX_VALUE);
                vGroup.addComponent(this.getAnnotationTblMappingPanel(), -2, -1, -2);
            }
            hGroup.addComponent(this.getTextImportOptionPanel(), -1, -1, Short.MAX_VALUE);
            vGroup.addComponent(this.getTextImportOptionPanel(), -2, -1, -2);
            hGroup.addComponent(okButton, GroupLayout.Alignment.TRAILING, -2, -1, -2);
            vGroup.addComponent(okButton, -2, -1, -2);
            this.advancedDialog.setContentPane(contentPane);
            LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.advancedDialog.getRootPane(), (Action)okButton.getAction(), (Action)okButton.getAction());
            this.advancedDialog.getRootPane().setDefaultButton(okButton);
            if (this.importType == ImportType.ONTOLOGY_IMPORT) {
                this.getImportAllCheckBox().setSelected(true);
                this.getImportAllCheckBox().setEnabled(false);
            }
        }
        this.advancedDialog.pack();
        this.advancedDialog.setLocationRelativeTo(((CySwingApplication)this.serviceRegistrar.getService(CySwingApplication.class)).getJFrame());
        this.advancedDialog.setVisible(true);
    }

    private JCheckBox getImportAllCheckBox() {
        if (this.importAllCheckBox == null) {
            this.importAllCheckBox = new JCheckBox("Import everything (Key is always ID)");
            this.importAllCheckBox.addChangeListener(e -> {
                if (this.importAllCheckBox.isSelected()) {
                    this.mappingAttributeComboBox.setSelectedItem(ID);
                    this.mappingAttributeComboBox.setEnabled(false);
                } else {
                    this.mappingAttributeComboBox.setEnabled(true);
                }
            });
        }
        return this.importAllCheckBox;
    }

    private JCheckBox getTransferNameCheckBox() {
        if (this.transferNameCheckBox == null) {
            this.transferNameCheckBox = new JCheckBox("Use first line as column names");
            this.transferNameCheckBox.setSelected(this.isFirstRowNames());
            this.transferNameCheckBox.addChangeListener(e -> {
                this.useFirstRowAsNames(this.transferNameCheckBox.isSelected());
                this.repaint();
            });
        }
        return this.transferNameCheckBox;
    }

    private JSpinner getStartRowSpinner() {
        if (this.startRowSpinner == null) {
            this.startRowSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 10000000, 1));
            this.startRowSpinner.setToolTipText("Load entries from this line");
            this.startRowSpinner.addMouseWheelListener(evt -> this.startRowSpinnerMouseWheelMoved(evt));
            this.startRowSpinner.addChangeListener(e -> {
                try {
                    if (!this.updating) {
                        this.updatePreview();
                    }
                }
                catch (IOException ex) {
                    logger.error("Error on ChangeEvent of spinner Start Import Row", (Throwable)ex);
                }
            });
        }
        return this.startRowSpinner;
    }

    private JTextField getCommentLineTextField() {
        if (this.commentLineTextField == null) {
            this.commentLineTextField = new JTextField();
            this.commentLineTextField.setToolTipText("Lines that start with this string will be ignored");
            this.commentLineTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.maybeUpdatePreview();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.maybeUpdatePreview();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.maybeUpdatePreview();
                }

                private void maybeUpdatePreview() {
                    try {
                        if (!ImportTablePanel.this.updating) {
                            ImportTablePanel.this.updatePreview();
                        }
                    }
                    catch (IOException ex) {
                        logger.error("Error on ChangeEvent of text field Ignore Lines Starting With", (Throwable)ex);
                    }
                }
            });
        }
        return this.commentLineTextField;
    }

    private void attributeRadioButtonActionPerformed(ActionEvent evt) {
        CyNetwork network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
        if (this.nodeRadioButton.isSelected()) {
            if (network != null) {
                this.selectedAttributes = network.getDefaultNodeTable();
            }
            this.objType = TextTableReader.ObjectType.NODE;
        } else if (this.edgeRadioButton.isSelected()) {
            if (network != null) {
                this.selectedAttributes = network.getDefaultEdgeTable();
            }
            this.objType = TextTableReader.ObjectType.EDGE;
        } else {
            logger.info("\nNote: ImportTextTableFDialog.attributeRadioButtonActionPerformed():Import network table not implemented yet!\n");
            this.objType = TextTableReader.ObjectType.NETWORK;
        }
        this.updateMappingAttributeComboBox();
        this.setKeyList();
    }

    private void useFirstRowAsNames(boolean b) {
        JTable table = this.getPreviewPanel().getPreviewTable();
        if (table != null) {
            PreviewTablePanel.PreviewTableModel model = (PreviewTablePanel.PreviewTableModel)table.getModel();
            model.setFirstRowNames(b);
            ColumnResizer.adjustColumnPreferredWidths((JTable)table);
        }
    }

    public void importTable() throws Exception {
        SourceColumnSemantic[] types;
        if (!this.isInputTableValid()) {
            return;
        }
        String[] attrNames = this.getPreviewPanel().getAttributeNames();
        if (!this.isAttributeNamesValid(attrNames, types = this.getPreviewPanel().getTypes())) {
            return;
        }
        if (this.importType == ImportType.ONTOLOGY_IMPORT) {
            this.panelBuilder.importOntologyAndAnnotation();
        }
    }

    private final void setPreviewPanel() throws IOException {
        try {
            this.readAnnotationForPreview(this.checkDelimiter());
        }
        catch (Exception e) {
            throw new IOException("Could not read table file for preview.  The source file may contain invalid values.", e);
        }
        if (this.getPreviewPanel().getPreviewTable() != null) {
            ColumnResizer.adjustColumnPreferredWidths((JTable)this.getPreviewPanel().getPreviewTable());
            this.getPreviewPanel().getPreviewTable().repaint();
        }
    }

    private void startRowSpinnerMouseWheelMoved(MouseWheelEvent evt) {
        JSpinner source = (JSpinner)evt.getSource();
        SpinnerNumberModel model = (SpinnerNumberModel)source.getModel();
        Integer oldValue = (Integer)source.getValue();
        int intValue = oldValue - evt.getWheelRotation() * model.getStepSize().intValue();
        Integer newValue = intValue;
        if (Integer.valueOf(((Number)((Object)model.getMaximum())).intValue()).compareTo(newValue) >= 0 && Integer.valueOf(((Number)((Object)model.getMinimum())).intValue()).compareTo(newValue) <= 0) {
            source.setValue(newValue);
        }
    }

    private final void updatePreview() throws IOException {
        this.readAnnotationForPreview(this.checkDelimiter());
        this.useFirstRowAsNames(this.getTransferNameCheckBox().isSelected());
        this.getPreviewPanel().repaint();
    }

    private void updateComponents() throws JAXBException, IOException {
        this.updating = true;
        try {
            if (this.importType == ImportType.ONTOLOGY_IMPORT) {
                this.panelBuilder.setOntologyComboBox();
                this.panelBuilder.setAnnotationComboBox();
            }
            this.getStartRowSpinner().setEnabled(false);
            this.getPreviewPanel().getPreviewTable().getTableHeader().setReorderingAllowed(false);
            this.attrTypeButtonGroup.setSelected(this.nodeRadioButton.getModel(), true);
            if (this.fileType != null && this.fileType.equalsIgnoreCase(SupportedFileType.CSV.getExtension())) {
                this.commaCheckBox.setSelected(true);
            } else {
                this.tabCheckBox.setSelected(true);
            }
            this.otherDelimiterTextField.setEnabled(false);
            this.dotDecimalSeparatorRadioButton.setSelected(true);
            this.otherDecimalSeparatorTextField.setEnabled(false);
            if (this.importType != ImportType.NETWORK_IMPORT) {
                this.updateMappingAttributeComboBox();
            }
            if (this.importType == ImportType.ONTOLOGY_IMPORT) {
                this.disableComponentsForGA();
            }
        }
        finally {
            this.updating = false;
        }
        Window parent = SwingUtilities.getWindowAncestor(this);
        if (parent != null) {
            parent.pack();
        }
    }

    protected void readAnnotationForPreviewOntology(URL sourceURL, List<String> delimiters) throws IOException {
        String commentChar = this.getCommentLinePrefix();
        int startLine = this.getStartLineNumber();
        InputStream tempIs = URLUtil.getInputStream(sourceURL);
        this.getPreviewPanel().update(this.workbook, this.fileType, sourceURL.toString(), tempIs, delimiters, commentChar, startLine - 1, this.getDecimalSeparator());
        tempIs.close();
        if (this.getPreviewPanel().getPreviewTable() == null) {
            return;
        }
        JTable table = this.getPreviewPanel().getPreviewTable();
        if (this.getPreviewPanel().getFileType() == FileType.GENE_ASSOCIATION_FILE) {
            TableModel previewModel = table.getModel();
            String[] columnNames = new String[previewModel.getColumnCount()];
            for (int j = 0; j < columnNames.length; ++j) {
                columnNames[j] = previewModel.getColumnName(j);
            }
        }
        this.getPreviewPanel().setType(GeneAssociationTag.GO_ID.getPosition(), SourceColumnSemantic.ONTOLOGY);
        this.attributeRadioButtonActionPerformed(null);
        Window parent = SwingUtilities.getWindowAncestor(this);
        if (parent != null) {
            parent.pack();
        }
    }

    protected void readAnnotationForPreview(List<String> delimiters) throws IOException {
        String commentChar = this.getCommentLinePrefix();
        int startLine = this.getStartLineNumber();
        FileInputStream tempIs = null;
        if (this.tempFile != null) {
            tempIs = new FileInputStream(this.tempFile);
        }
        if (this.isSpreadsheetFile() && this.workbook == null) {
            try {
                this.workbook = WorkbookFactory.create((InputStream)tempIs);
            }
            catch (InvalidFormatException e) {
                ((InputStream)tempIs).close();
                throw new IllegalArgumentException("Could not read Excel file.  Maybe the file is broken?", e);
            }
        }
        if (tempIs != null) {
            ((InputStream)tempIs).close();
        }
        FileInputStream tempIs2 = null;
        if (this.tempFile != null) {
            tempIs2 = new FileInputStream(this.tempFile);
        }
        this.getPreviewPanel().update(this.workbook, this.fileType, "", tempIs2, delimiters, commentChar, startLine - 1, this.getDecimalSeparator());
        if (tempIs2 != null) {
            ((InputStream)tempIs2).close();
        }
        if (this.getPreviewPanel().getPreviewTable() == null) {
            return;
        }
        if (this.importType != ImportType.NETWORK_IMPORT) {
            if (this.getPreviewPanel().getFileType() == FileType.GENE_ASSOCIATION_FILE) {
                JTable table = this.getPreviewPanel().getPreviewTable();
                TableModel previewModel = table.getModel();
                String[] columnNames = new String[previewModel.getColumnCount()];
                for (int j = 0; j < columnNames.length; ++j) {
                    columnNames[j] = previewModel.getColumnName(j);
                }
                this.disableComponentsForGA();
            }
            if (this.fileType != null) {
                FileType type = this.checkFileType();
                if (type == FileType.GENE_ASSOCIATION_FILE) {
                    this.getPreviewPanel().setType(GeneAssociationTag.GO_ID.getPosition(), SourceColumnSemantic.ONTOLOGY);
                    this.disableComponentsForGA();
                } else if (!this.isSpreadsheetFile()) {
                    this.nodeRadioButton.setEnabled(true);
                    this.edgeRadioButton.setEnabled(true);
                    this.networkRadioButton.setEnabled(true);
                    this.getImportAllCheckBox().setEnabled(false);
                } else {
                    this.getImportAllCheckBox().setEnabled(false);
                }
            }
            this.attributeRadioButtonActionPerformed(null);
        }
        this.getStartRowSpinner().setEnabled(true);
        Window parent = SwingUtilities.getWindowAncestor(this);
        if (parent != null) {
            parent.pack();
        }
    }

    private void disableComponentsForGA() {
        this.nodeRadioButton.setSelected(true);
        this.nodeRadioButton.setEnabled(false);
        this.edgeRadioButton.setEnabled(false);
        this.networkRadioButton.setEnabled(false);
        this.delimiterLabel.setEnabled(false);
        this.tabCheckBox.setEnabled(false);
        this.tabCheckBox.setSelected(true);
        this.commaCheckBox.setEnabled(false);
        this.commaCheckBox.setSelected(false);
        this.spaceCheckBox.setEnabled(false);
        this.spaceCheckBox.setSelected(false);
        this.semicolonCheckBox.setEnabled(false);
        this.semicolonCheckBox.setSelected(false);
        this.otherCheckBox.setEnabled(false);
        this.otherCheckBox.setSelected(false);
        this.otherDelimiterTextField.setEnabled(false);
        this.decimalSeparatorLabel.setEnabled(false);
        this.commaDecimalSeparatorRadioButton.setEnabled(false);
        this.dotDecimalSeparatorRadioButton.setEnabled(false);
        this.otherDecimalSeparatorRadioButton.setEnabled(false);
        this.otherDecimalSeparatorTextField.setEnabled(false);
        this.getImportAllCheckBox().setEnabled(false);
    }

    private FileType checkFileType() {
        if (this.importType == ImportType.ONTOLOGY_IMPORT) {
            return FileType.CUSTOM_ANNOTATION_FILE;
        }
        if (this.importType == ImportType.NETWORK_IMPORT) {
            return FileType.NETWORK_FILE;
        }
        return FileType.ATTRIBUTE_FILE;
    }

    private void setKeyList() {
        if (this.mappingAttributeComboBox.getSelectedItem() == null) {
            return;
        }
        if (((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork() == null) {
            return;
        }
        String selectedKeyAttribute = this.mappingAttributeComboBox.getSelectedItem().toString();
        TreeSet<String> valueSet = new TreeSet<String>();
        if (selectedKeyAttribute.equals(ID)) {
            if (this.objType == TextTableReader.ObjectType.NODE) {
                for (CyNode node : this.network.getNodeList()) {
                    String name = (String)this.network.getRow((CyIdentifiable)node).get(ID, String.class);
                    if (name == null) continue;
                    valueSet.add(name);
                }
            } else if (this.objType == TextTableReader.ObjectType.EDGE) {
                for (CyEdge edge : this.network.getEdgeList()) {
                    String name = (String)this.network.getRow((CyIdentifiable)edge).get(ID, String.class);
                    if (name == null) continue;
                    valueSet.add(name);
                }
            }
        }
        this.getPreviewPanel().setKeyAttributeList(valueSet);
    }

    private void updateMappingAttributeComboBox() {
        this.mappingAttributeComboBox.removeAllItems();
        final ListCellRenderer<String> lcr = this.mappingAttributeComboBox.getRenderer();
        this.mappingAttributeComboBox.setRenderer(new ListCellRenderer<String>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel cmp = (JLabel)lcr.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value.equals(ImportTablePanel.ID)) {
                    cmp.setIcon(ImportDialogIcons.ID_ICON.getIcon());
                }
                return cmp;
            }
        });
        this.mappingAttributeComboBox.addItem(ID);
        if (((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork() == null) {
            return;
        }
        for (CyColumn column : this.selectedAttributes.getColumns()) {
            Class type;
            String columnName = column.getName();
            if (columnName.equalsIgnoreCase(ID) || (type = column.getType()) != String.class && type != Integer.class && type != Double.class && type != List.class) continue;
            this.mappingAttributeComboBox.addItem(columnName);
        }
    }

    private void updateTypes(FileType type) {
        SourceColumnSemantic[] types = this.getPreviewPanel().getTypes();
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                this.getPreviewPanel().setType(i, types[i] != SourceColumnSemantic.NONE ? SourceColumnSemantic.ATTR : SourceColumnSemantic.NONE);
            }
        }
        if (type == FileType.GENE_ASSOCIATION_FILE) {
            int keyInFile = this.getPreviewPanel().getColumnIndex(SourceColumnSemantic.KEY);
            this.getPreviewPanel().setAliasColumn(GeneAssociationTag.DB_OBJECT_SYNONYM.getPosition(), true);
            this.getPreviewPanel().setType(GeneAssociationTag.TAXON.getPosition(), SourceColumnSemantic.TAXON);
            this.getPreviewPanel().setType(keyInFile, SourceColumnSemantic.KEY);
        }
        this.getPreviewPanel().update();
    }

    public List<String> checkDelimiter() {
        ArrayList<String> delList = new ArrayList<String>();
        if (this.tabCheckBox.isSelected()) {
            delList.add(TextDelimiter.TAB.getDelimiter());
        }
        if (this.commaCheckBox.isSelected()) {
            delList.add(TextDelimiter.COMMA.getDelimiter());
        }
        if (this.spaceCheckBox.isSelected()) {
            delList.add(TextDelimiter.SPACE.getDelimiter());
        }
        if (this.semicolonCheckBox.isSelected()) {
            delList.add(TextDelimiter.SEMICOLON.getDelimiter());
        }
        if (this.otherCheckBox.isSelected() && this.otherDelimiterTextField.getText().trim().length() > 0) {
            delList.add(this.otherDelimiterTextField.getText());
        }
        return delList;
    }

    public Character getDecimalSeparator() {
        String txt;
        Character separator = null;
        if (this.commaDecimalSeparatorRadioButton.isSelected()) {
            separator = Character.valueOf(',');
        }
        if (this.dotDecimalSeparatorRadioButton.isSelected()) {
            separator = Character.valueOf('.');
        }
        if (this.otherDecimalSeparatorRadioButton.isSelected() && (txt = this.otherDecimalSeparatorTextField.getText().trim()) != null && !txt.isEmpty()) {
            separator = Character.valueOf(txt.charAt(0));
        }
        if (separator == null) {
            separator = AttributeMappingParameters.DEF_DECIMAL_SEPARATOR;
        }
        return separator;
    }

    private boolean isInputTableValid() {
        JTable table = this.getPreviewPanel().getPreviewTable();
        JFrame parent = ((CySwingApplication)this.serviceRegistrar.getService(CySwingApplication.class)).getJFrame();
        if (table == null || table.getModel() == null || table.getColumnCount() == 0) {
            JOptionPane.showMessageDialog(parent, "No table selected.", "Invalid Table", 2);
            return false;
        }
        if (table.getColumnCount() < 2 && this.importType != ImportType.NETWORK_IMPORT) {
            JOptionPane.showMessageDialog(parent, "Table should contain at least 2 columns.", "Invalid Table", 1);
            return false;
        }
        if (this.importType == ImportType.NETWORK_IMPORT) {
            int sIdx = this.getPreviewPanel().getColumnIndex(SourceColumnSemantic.SOURCE_ATTR);
            int tIdx = this.getPreviewPanel().getColumnIndex(SourceColumnSemantic.TARGET_ATTR);
            int iIdx = this.getPreviewPanel().getColumnIndex(SourceColumnSemantic.INTERACTION);
            if (sIdx == tIdx || (iIdx == sIdx || iIdx == tIdx) && iIdx != -1) {
                JOptionPane.showMessageDialog(parent, "Columns for source, target, and interaction type must be distinct.", "Same Column Index", 2);
                return false;
            }
        }
        return true;
    }

    private void globalLayout() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        if (this.importType == ImportType.TABLE_IMPORT) {
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getBasicPanel(), -1, -1, Short.MAX_VALUE).addComponent(this.getPreviewPanel(), -1, 680, Short.MAX_VALUE).addComponent(this.getAdvancedButton()));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getBasicPanel(), -2, -1, -2).addComponent(this.getPreviewPanel(), -1, -1, Short.MAX_VALUE).addComponent(this.getAdvancedButton()));
        } else if (this.importType == ImportType.ONTOLOGY_IMPORT) {
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getBasicPanel(), -1, -1, Short.MAX_VALUE).addComponent(this.getPreviewPanel(), -1, 680, Short.MAX_VALUE).addComponent(this.getAdvancedButton()));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getBasicPanel(), -2, -1, -2).addComponent(this.getPreviewPanel(), -1, -1, Short.MAX_VALUE).addComponent(this.getAdvancedButton()));
        } else if (this.importType == ImportType.NETWORK_IMPORT) {
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getBasicPanel(), -1, -1, Short.MAX_VALUE).addComponent(this.getPreviewPanel(), -1, 680, Short.MAX_VALUE).addComponent(this.getAdvancedButton()));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getBasicPanel(), -2, -1, -2).addComponent(this.getPreviewPanel(), -1, -1, Short.MAX_VALUE).addComponent(this.getAdvancedButton()));
        }
    }

    private boolean isFirstRowNames() {
        JTable table = this.getPreviewPanel().getPreviewTable();
        if (table != null && table.getModel() instanceof PreviewTablePanel.PreviewTableModel) {
            return ((PreviewTablePanel.PreviewTableModel)table.getModel()).isFirstRowNames();
        }
        return false;
    }

    private int getStartLineNumber() {
        if (this.isFirstRowNames()) {
            return Integer.parseInt(this.getStartRowSpinner().getValue().toString());
        }
        return Integer.parseInt(this.getStartRowSpinner().getValue().toString()) - 1;
    }

    private String getCommentLinePrefix() {
        return this.getCommentLineTextField().getText();
    }

    public AttributeMappingParameters getAttributeMappingParameters() throws Exception {
        SourceColumnSemantic[] types;
        String sourceName = this.getPreviewPanel().getSourceName();
        String[] attrNames = this.getPreviewPanel().getAttributeNames();
        if (!this.isAttributeNamesValid(attrNames, types = this.getPreviewPanel().getTypes())) {
            return null;
        }
        SourceColumnSemantic[] typesCopy = Arrays.copyOf(types, types.length);
        AttributeDataType[] dataTypes = this.getPreviewPanel().getDataTypes();
        AttributeDataType[] dataTypesCopy = Arrays.copyOf(dataTypes, dataTypes.length);
        String[] listDelimiters = this.getPreviewPanel().getListDelimiters();
        String[] listDelimitersCopy = Arrays.copyOf(listDelimiters, listDelimiters.length);
        String[] namespaces = this.getPreviewPanel().getNamespaces();
        String[] namespacesCopy = Arrays.copyOf(namespaces, namespaces.length);
        int startLineNumber = this.getStartLineNumber();
        String commentChar = null;
        if (!this.getCommentLinePrefix().isEmpty()) {
            commentChar = this.getCommentLinePrefix();
        }
        List<String> del = this.checkDelimiter();
        int keyInFile = this.getPreviewPanel().getColumnIndex(SourceColumnSemantic.KEY);
        AttributeMappingParameters mapping = new AttributeMappingParameters(sourceName, del, listDelimitersCopy, keyInFile, attrNames, dataTypesCopy, typesCopy, namespacesCopy, startLineNumber, commentChar, this.getDecimalSeparator());
        return mapping;
    }

    private boolean isAttributeNamesValid(String[] attrNames, SourceColumnSemantic[] types) {
        for (int i = 0; i < attrNames.length; ++i) {
            String name = attrNames[i];
            for (int j = 0; j < attrNames.length; ++j) {
                if (i == j || !name.equals(attrNames[j]) || TypeUtil.allowsDuplicateName(this.importType, types[i], types[j])) continue;
                JOptionPane.showMessageDialog(((CySwingApplication)this.serviceRegistrar.getService(CySwingApplication.class)).getJFrame(), "Duplicate Column Name Found: " + name, "Import Error", 0);
                return false;
            }
        }
        return true;
    }

    public NetworkTableMappingParameters getNetworkTableMappingParameters() throws Exception {
        SourceColumnSemantic[] types;
        String sourceName = this.getPreviewPanel().getSourceName();
        String[] attrNames = this.getPreviewPanel().getAttributeNames();
        if (!this.isAttributeNamesValid(attrNames, types = this.getPreviewPanel().getTypes())) {
            return null;
        }
        SourceColumnSemantic[] typesCopy = Arrays.copyOf(types, types.length);
        AttributeDataType[] dataTypes = this.getPreviewPanel().getDataTypes();
        AttributeDataType[] dataTypesCopy = Arrays.copyOf(dataTypes, dataTypes.length);
        String[] listDelimiters = this.getPreviewPanel().getListDelimiters();
        String[] listDelimitersCopy = Arrays.copyOf(listDelimiters, listDelimiters.length);
        String[] namespaces = this.getPreviewPanel().getNamespaces();
        String[] namespacesCopy = Arrays.copyOf(namespaces, namespaces.length);
        int startLineNumber = this.getStartLineNumber();
        String commentChar = null;
        if (!this.getCommentLinePrefix().isEmpty()) {
            commentChar = this.getCommentLinePrefix();
        }
        int sourceColumnIndex = this.getPreviewPanel().getColumnIndex(SourceColumnSemantic.SOURCE);
        int targetColumnIndex = this.getPreviewPanel().getColumnIndex(SourceColumnSemantic.TARGET);
        int interactionColumnIndex = this.getPreviewPanel().getColumnIndex(SourceColumnSemantic.INTERACTION);
        String defaultInteraction = this.defaultInteractionTextField.getText();
        List<String> del = this.checkDelimiter();
        NetworkTableMappingParameters mapping = new NetworkTableMappingParameters(sourceName, del, listDelimitersCopy, attrNames, dataTypesCopy, typesCopy, namespacesCopy, sourceColumnIndex, targetColumnIndex, interactionColumnIndex, defaultInteraction, startLineNumber, commentChar, this.getDecimalSeparator());
        return mapping;
    }

    private boolean isSpreadsheetFile() {
        return this.fileType != null && (this.fileType.equalsIgnoreCase(SupportedFileType.EXCEL.getExtension()) || this.fileType.equalsIgnoreCase(SupportedFileType.OOXML.getExtension()));
    }
}

