/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.task;

import org.cytoscape.io.read.CyNetworkReader;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterOntologyTask
extends AbstractTask {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final CyNetworkReader reader;
    private final CyServiceRegistrar serviceRegistrar;
    private final String name;

    RegisterOntologyTask(CyNetworkReader reader, CyServiceRegistrar serviceRegistrar, String name) {
        this.reader = reader;
        this.serviceRegistrar = serviceRegistrar;
        this.name = name;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Registering new Ontology DAG...");
        CyNetwork[] networks = this.reader.getNetworks();
        CyNetwork network = networks[0];
        if (network == null) {
            throw new NullPointerException("No Ontology DAG loaded");
        }
        network.getRow((CyIdentifiable)network).set("name", (Object)this.name);
        ((CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class)).addNetwork(network);
        logger.debug("New Ontology DAG Registered: model ID = " + network.getSUID());
    }
}

