/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.task;

import java.io.InputStream;
import org.cytoscape.io.read.CyNetworkReader;
import org.cytoscape.io.read.InputStreamTaskFactory;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.reader.ontology.GeneAssociationReader;
import org.cytoscape.tableimport.internal.task.MapGeneAssociationTask;
import org.cytoscape.tableimport.internal.task.RegisterOntologyTask;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;

public class ImportOntologyAndAnnotationTask
extends AbstractTask {
    private final InputStreamTaskFactory factory;
    private final String ontologyDagName;
    private final InputStream gaStream;
    private final String gaTableName;
    private final CyServiceRegistrar serviceRegistrar;
    private final InputStream is;

    ImportOntologyAndAnnotationTask(InputStreamTaskFactory factory, InputStream is, String ontologyDagName, InputStream gaStream, String tableName, CyServiceRegistrar serviceRegistrar) {
        this.factory = factory;
        this.ontologyDagName = ontologyDagName;
        this.gaStream = gaStream;
        this.gaTableName = tableName;
        this.serviceRegistrar = serviceRegistrar;
        this.is = is;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Importing ontology and annotations");
        tm.setStatusMessage("Loading Ontology...");
        tm.setProgress(-1.0);
        CyNetworkReader loadOBOTask = (CyNetworkReader)this.factory.createTaskIterator(this.is, this.ontologyDagName).next();
        RegisterOntologyTask registerOntologyTask = new RegisterOntologyTask(loadOBOTask, this.serviceRegistrar, this.ontologyDagName);
        GeneAssociationReader gaReader = new GeneAssociationReader(this.ontologyDagName, this.gaStream, this.gaTableName, this.serviceRegistrar);
        MapGeneAssociationTask mapAnnotationTask = new MapGeneAssociationTask(gaReader, this.serviceRegistrar);
        TaskIterator taskChain = new TaskIterator(new Task[]{loadOBOTask, registerOntologyTask, gaReader, mapAnnotationTask});
        this.insertTasksAfterCurrentTask(taskChain);
    }
}

