/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.read.CyNetworkReader;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CyNetworkNaming;
import org.cytoscape.tableimport.internal.task.LoadNetworkReaderTask;
import org.cytoscape.tableimport.internal.task.NetworkCollectionHelper;
import org.cytoscape.tableimport.internal.task.SelectFileTableTask;
import org.cytoscape.tableimport.internal.task.SelectURLTableTask;
import org.cytoscape.tableimport.internal.task.TableImportContext;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

public class ImportNoGuiNetworkReaderFactory
extends AbstractTaskFactory {
    public static final String JSON_EXAMPLE = "{ \"networks\":[101,102,103],\"views\":[200,201,204] }";
    private final boolean fromURL;
    private final TableImportContext tableImportContext;
    private final CyServiceRegistrar serviceRegistrar;

    public ImportNoGuiNetworkReaderFactory(boolean fromURL, TableImportContext tableImportContext, CyServiceRegistrar serviceRegistrar) {
        this.fromURL = fromURL;
        this.tableImportContext = tableImportContext;
        this.serviceRegistrar = serviceRegistrar;
    }

    public TaskIterator createTaskIterator() {
        LoadNetworkReaderTask readerTask = new LoadNetworkReaderTask(this.tableImportContext, this.serviceRegistrar, true);
        NetworkCollectionHelper networkCollectionHelperTask = new NetworkCollectionHelper(readerTask, this.serviceRegistrar);
        GenerateNetworkViewsTask generateViewTask = new GenerateNetworkViewsTask(readerTask);
        if (this.fromURL) {
            return new TaskIterator(new Task[]{new SelectURLTableTask((Task)readerTask, this.serviceRegistrar), networkCollectionHelperTask, readerTask, generateViewTask});
        }
        return new TaskIterator(new Task[]{new SelectFileTableTask((Task)readerTask, this.serviceRegistrar), networkCollectionHelperTask, readerTask, generateViewTask});
    }

    class GenerateNetworkViewsTask
    extends AbstractTask
    implements ObservableTask {
        private String name = null;
        private final CyNetworkReader netReader;
        private int viewThreshold;
        private List<CyNetworkView> results;
        private List<CyNetwork> largeNetworks;
        private final String VIEW_THRESHOLD = "viewThreshold";
        private static final int DEF_VIEW_THRESHOLD = 3000;

        public GenerateNetworkViewsTask(CyNetworkReader netReader) {
            this.netReader = netReader;
        }

        public void run(TaskMonitor taskMonitor) throws Exception {
            CySubNetwork subnet;
            CyRootNetwork rootNet;
            String rootNetName;
            taskMonitor.setProgress(0.0);
            VisualMappingManager vmManager = (VisualMappingManager)ImportNoGuiNetworkReaderFactory.this.serviceRegistrar.getService(VisualMappingManager.class);
            CyNetworkNaming netNaming = (CyNetworkNaming)ImportNoGuiNetworkReaderFactory.this.serviceRegistrar.getService(CyNetworkNaming.class);
            CyNetworkManager netManager = (CyNetworkManager)ImportNoGuiNetworkReaderFactory.this.serviceRegistrar.getService(CyNetworkManager.class);
            CyNetworkViewManager netViewManager = (CyNetworkViewManager)ImportNoGuiNetworkReaderFactory.this.serviceRegistrar.getService(CyNetworkViewManager.class);
            CyNetworkViewFactory nullNetViewFactory = (CyNetworkViewFactory)ImportNoGuiNetworkReaderFactory.this.serviceRegistrar.getService(CyNetworkViewFactory.class, "(id=NullCyNetworkViewFactory)");
            VisualStyle style = vmManager.getCurrentVisualStyle();
            CySubNetwork networks = this.netReader.getNetworks();
            double numNets = ((CyNetwork[])networks).length;
            int i = 0;
            if (this.netReader instanceof LoadNetworkReaderTask) {
                this.name = ((LoadNetworkReaderTask)this.netReader).getName();
            }
            this.viewThreshold = this.getViewThreshold();
            this.results = new ArrayList<CyNetworkView>();
            this.largeNetworks = new ArrayList<CyNetwork>();
            for (CyNetwork network : networks) {
                String networkName = (String)network.getRow((CyIdentifiable)network).get("name", String.class);
                if (networkName == null || networkName.trim().length() == 0) {
                    networkName = this.name;
                    if (networkName == null) {
                        networkName = "? (Name is missing)";
                    }
                    network.getRow((CyIdentifiable)network).set("name", (Object)netNaming.getSuggestedNetworkTitle(networkName));
                }
                netManager.addNetwork(network, false);
                int numGraphObjects = network.getNodeCount() + network.getEdgeCount();
                if (numGraphObjects < this.viewThreshold) {
                    CyNetworkView view = this.netReader.buildCyNetworkView(network);
                    netViewManager.addNetworkView(view, false);
                    vmManager.setVisualStyle(style, view);
                    style.apply(view);
                    if (!(view.isSet(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION) || view.isSet(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION) || view.isSet(BasicVisualLexicon.NETWORK_CENTER_Z_LOCATION))) {
                        view.fitContent();
                    }
                    this.results.add(view);
                } else {
                    this.largeNetworks.add(network);
                    this.results.add(nullNetViewFactory.createNetworkView(network));
                }
                taskMonitor.setProgress((double)(++i) / numNets);
            }
            if (((CyNetwork[])networks).length == 1 && networks[0] instanceof CySubNetwork && ((rootNetName = (String)(rootNet = (subnet = (CySubNetwork)networks[0]).getRootNetwork()).getRow((CyIdentifiable)rootNet).get("name", String.class)) == null || rootNetName.trim().length() == 0)) {
                rootNet.getRow((CyIdentifiable)rootNet).set("name", (Object)((String)networks[0].getRow((CyIdentifiable)networks[0]).get("name", String.class)));
            }
            for (CyNetwork network : networks) {
                CySubNetwork subNet;
                CyRootNetwork rootNet2;
                String networkName;
                if (!(network instanceof CySubNetwork) || (networkName = (String)(rootNet2 = (subNet = (CySubNetwork)network).getRootNetwork()).getRow((CyIdentifiable)rootNet2).get("name", String.class)) != null && networkName.trim().length() != 0) continue;
                networkName = this.name;
                if (networkName == null) {
                    networkName = "? (Name is missing)";
                }
                rootNet2.getRow((CyIdentifiable)rootNet2).set("name", (Object)netNaming.getSuggestedNetworkTitle(networkName));
            }
            CyApplicationManager applicationManager = (CyApplicationManager)ImportNoGuiNetworkReaderFactory.this.serviceRegistrar.getService(CyApplicationManager.class);
            if (!this.results.isEmpty()) {
                applicationManager.setCurrentNetworkView(this.results.iterator().next());
            } else {
                for (CySubNetwork net : networks) {
                    if (!(net instanceof CySubNetwork)) continue;
                    applicationManager.setCurrentNetwork((CyNetwork)net);
                    break;
                }
            }
        }

        private int getViewThreshold() {
            int threshold;
            CyProperty cyProperties = (CyProperty)ImportNoGuiNetworkReaderFactory.this.serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
            String vts = ((Properties)cyProperties.getProperties()).getProperty("viewThreshold");
            try {
                threshold = Integer.parseInt(vts);
            }
            catch (Exception e) {
                threshold = 3000;
            }
            return threshold;
        }

        private Object getStringResults() {
            Object strRes = "";
            for (CyNetworkView view : this.results) {
                strRes = "SUID:" + ((CyNetwork)view.getModel()).getSUID() + " " + ((CyNetwork)view.getModel()).toString() + "\n";
            }
            return ((String)strRes).isEmpty() ? null : ((String)strRes).substring(0, ((String)strRes).length() - 1);
        }

        public Object getResults(Class expectedType) {
            if (expectedType.equals(String.class)) {
                return this.getStringResults();
            }
            if (expectedType.equals(JSONResult.class)) {
                JSONResult res = () -> {
                    if (this.results == null && this.largeNetworks.isEmpty()) {
                        return "{}";
                    }
                    CyJSONUtil cyJSONUtil = (CyJSONUtil)ImportNoGuiNetworkReaderFactory.this.serviceRegistrar.getService(CyJSONUtil.class);
                    ArrayList<CyNetwork> networks = new ArrayList<CyNetwork>();
                    for (CyNetworkView view : this.results) {
                        networks.add((CyNetwork)view.getModel());
                    }
                    if (this.largeNetworks != null && this.largeNetworks.size() > 0) {
                        for (CyNetwork net : this.largeNetworks) {
                            if (networks.contains(net)) continue;
                            networks.add(net);
                        }
                    }
                    Object jsonRes = "{ \"networks\":";
                    jsonRes = (String)jsonRes + cyJSONUtil.cyIdentifiablesToJson(networks);
                    jsonRes = (String)jsonRes + ", \"views\":";
                    jsonRes = (String)jsonRes + cyJSONUtil.cyIdentifiablesToJson(this.results);
                    jsonRes = (String)jsonRes + "}";
                    return jsonRes;
                };
                return res;
            }
            return this.results;
        }

        public List<Class<?>> getResultClasses() {
            return Arrays.asList(List.class, String.class, JSONResult.class);
        }
    }
}

