/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.task;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.cytoscape.io.read.CyTableReader;
import org.cytoscape.io.read.CyTableReaderManager;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.task.AddImportedTableTask;
import org.cytoscape.tableimport.internal.task.CombineTableReaderAndMappingTask;
import org.cytoscape.tableimport.internal.task.ReaderTableTask;
import org.cytoscape.tableimport.internal.task.TableImportContext;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

abstract class AbstractLoadTableTask
extends AbstractTask {
    private final TableImportContext tableImportContext;
    private final CyServiceRegistrar serviceRegistrar;

    public AbstractLoadTableTask(TableImportContext tableImportContext, CyServiceRegistrar serviceRegistrar) {
        this.tableImportContext = tableImportContext;
        this.serviceRegistrar = serviceRegistrar;
    }

    void loadTable(String name, URI uri, boolean combine, TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setStatusMessage("Finding Table Data Reader...");
        CyTableReaderManager tableReaderMgr = (CyTableReaderManager)this.serviceRegistrar.getService(CyTableReaderManager.class);
        CyTableReader reader = tableReaderMgr.getReader(uri, uri.toString());
        if (reader == null) {
            throw new NullPointerException("Failed to find reader for specified file.");
        }
        if (combine) {
            taskMonitor.setStatusMessage("Importing Data Table...");
            this.insertTasksAfterCurrentTask(new Task[]{new CombineTableReaderAndMappingTask(reader, this.tableImportContext, this.serviceRegistrar)});
        } else {
            taskMonitor.setStatusMessage("Loading Data Table...");
            this.insertTasksAfterCurrentTask(new Task[]{new ReaderTableTask(reader, this.serviceRegistrar), new AddImportedTableTask(reader, this.serviceRegistrar)});
        }
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(CyTable.class, String.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(CyTable.class)) {
            return "";
        }
        if (requestedType.equals(String.class)) {
            return "";
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult jSONResult = () -> "{}";
        }
        return null;
    }
}

