/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.reader.ontology;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.io.read.CyTableReader;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.reader.TextDelimiter;
import org.cytoscape.tableimport.internal.reader.ontology.GeneAssociationTag;
import org.cytoscape.tableimport.internal.util.OntologyDAGManager;
import org.cytoscape.tableimport.internal.util.OntologyUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneAssociationReader
extends AbstractTask
implements CyTableReader {
    private static final Logger logger = LoggerFactory.getLogger(GeneAssociationReader.class);
    private static final String COMPATIBLE_VERSION = "gaf-version: 2.0";
    private static final String TAXON_RESOURCE_FILE = "tax_report.txt";
    private static final String LIST_DELIMITER = TextDelimiter.PIPE.getDelimiter();
    private static final List<Integer> LIST_INDEX = new ArrayList<Integer>();
    private static final Map<String, String> NAMESPACE_MAP = new HashMap<String, String>();
    public static final String SYNONYM_COL_NAME = "Synonym";
    private static final String EVIDENCE_SUFFIX = " Evidence Code";
    private static final String REFERENCE_SUFFIX = " DB Reference";
    private static final String GA_DELIMITER;
    private static final int EXPECTED_COL_COUNT = 15;
    private static final int DB_OBJ_ID = 1;
    private static final int ASPECT = 8;
    private InputStream is;
    private Map<String, String> speciesMap;
    private CyNetwork ontologyDAG;
    private final String tableName;
    private CyTable table;
    private CyTable[] tables;
    private final String ontologyDagName;
    private List<String> termIDList;
    private final CyServiceRegistrar serviceRegistrar;

    public GeneAssociationReader(String ontologyDagName, InputStream is, String tableName, CyServiceRegistrar serviceRegistrar) throws IOException {
        this.ontologyDagName = ontologyDagName;
        this.is = is;
        this.serviceRegistrar = serviceRegistrar;
        this.tableName = tableName;
        this.buildTaxonMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTaxonMap() throws IOException {
        URL taxUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource(TAXON_RESOURCE_FILE);
        if (taxUrl == null) {
            throw new IllegalStateException("Could not find taxonomy ID conversion table.");
        }
        try (BufferedReader taxonFileReader = null;){
            taxonFileReader = new BufferedReader(new InputStreamReader(taxUrl.openStream(), Charset.forName("UTF-8").newDecoder()));
            OntologyUtil ontologyUtil = new OntologyUtil();
            this.speciesMap = ontologyUtil.getTaxonMap(taxonFileReader);
        }
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setTitle("Loading Gene Association File");
        taskMonitor.setStatusMessage("Importing annotation file.  Please wait...");
        taskMonitor.setProgress(-1.0);
        this.ontologyDAG = OntologyDAGManager.getOntologyDAG(this.ontologyDagName);
        if (this.ontologyDAG == null) {
            logger.warn("Could not find associated Ontology DAG.");
        } else {
            this.termIDList = this.ontologyDAG.getDefaultNodeTable().getColumn("name").getValues(String.class);
        }
        BufferedReader bufRd = new BufferedReader(new InputStreamReader(this.is, Charset.forName("UTF-8").newDecoder()));
        String line = null;
        while ((line = bufRd.readLine()) != null && !line.contains(COMPATIBLE_VERSION)) {
        }
        this.table = ((CyTableFactory)this.serviceRegistrar.getService(CyTableFactory.class)).createTable(this.tableName, "name", String.class, true, true);
        this.createColumns();
        while ((line = bufRd.readLine()) != null) {
            String[] parts;
            if (line.startsWith("!") || (parts = line.split(GA_DELIMITER)).length < 15) continue;
            this.parseGA(parts);
        }
        bufRd.close();
        this.is.close();
        this.is = null;
        this.tables = new CyTable[1];
        this.tables[0] = this.table;
        ((CyTableManager)this.serviceRegistrar.getService(CyTableManager.class)).addTable(this.table);
    }

    private void createColumns() {
        GeneAssociationTag[] tags = GeneAssociationTag.values();
        int index = 0;
        for (GeneAssociationTag tag : tags) {
            String tagString;
            ++index;
            if (tag == GeneAssociationTag.GO_ID || tag == GeneAssociationTag.EVIDENCE || tag == GeneAssociationTag.DB_REFERENCE || tag == GeneAssociationTag.ASPECT || this.table.getColumn(tagString = tag.toString()) != null) continue;
            if (LIST_INDEX.contains(index)) {
                this.table.createListColumn(tagString, String.class, false);
                continue;
            }
            this.table.createColumn(tagString, String.class, false);
        }
        for (String name : NAMESPACE_MAP.keySet()) {
            this.table.createListColumn(NAMESPACE_MAP.get(name), String.class, false);
            this.table.createListColumn(NAMESPACE_MAP.get(name) + EVIDENCE_SUFFIX, String.class, false);
            this.table.createListColumn(NAMESPACE_MAP.get(name) + REFERENCE_SUFFIX, String.class, false);
        }
        this.table.createListColumn(SYNONYM_COL_NAME, String.class, true);
    }

    private void parseGA(String[] entries) {
        this.mapEntry(entries);
    }

    private void mapEntry(String[] entries) {
        String primaryKeyValue = entries[1];
        CyRow row = this.table.getRow((Object)primaryKeyValue);
        row.set("name", (Object)primaryKeyValue);
        String namespace = NAMESPACE_MAP.get(entries[8]);
        block7: for (int i = 0; i < 15; ++i) {
            GeneAssociationTag tag = GeneAssociationTag.values()[i];
            switch (tag) {
                case GO_ID: {
                    ArrayList<String> currentList;
                    String goidString = entries[i];
                    if (this.termIDList != null) {
                        goidString = this.convertToName(goidString);
                    }
                    if ((currentList = row.getList(namespace, String.class)) == null) {
                        currentList = new ArrayList<String>();
                    }
                    if (!currentList.contains(goidString)) {
                        currentList.add(goidString);
                    }
                    row.set(namespace, currentList);
                    continue block7;
                }
                case EVIDENCE: 
                case DB_REFERENCE: {
                    String value = entries[i];
                    Object columnName = namespace;
                    columnName = tag == GeneAssociationTag.EVIDENCE ? (String)columnName + EVIDENCE_SUFFIX : (String)columnName + REFERENCE_SUFFIX;
                    ArrayList<String> valueList = row.getList((String)columnName, String.class);
                    if (valueList == null) {
                        valueList = new ArrayList<String>();
                    }
                    if (!valueList.contains(value)) {
                        valueList.add(value);
                    }
                    row.set((String)columnName, valueList);
                    continue block7;
                }
                case TAXON: {
                    String taxID = entries[i].split(":")[1];
                    String taxName = this.speciesMap.get(taxID);
                    if (taxName != null) {
                        row.set(tag.toString(), (Object)taxName);
                        continue block7;
                    }
                    if (taxID == null) continue block7;
                    row.set(tag.toString(), (Object)taxID);
                    continue block7;
                }
                case ASPECT: {
                    continue block7;
                }
                case DB_OBJECT_ID: 
                case DB_OBJECT_SYMBOL: 
                case DB_OBJECT_SYNONYM: {
                    String[] vals;
                    ArrayList<String> synList = row.getList(SYNONYM_COL_NAME, String.class);
                    if (synList == null) {
                        synList = new ArrayList<String>();
                    }
                    if (tag == GeneAssociationTag.DB_OBJECT_SYNONYM) {
                        for (String val : vals = entries[i].split(LIST_DELIMITER)) {
                            if (synList.contains(val)) continue;
                            synList.add(val);
                        }
                    } else if (!synList.contains(entries[i])) {
                        synList.add(entries[i]);
                    }
                    row.set(SYNONYM_COL_NAME, synList);
                    continue block7;
                }
                default: {
                    String[] vals;
                    if (LIST_INDEX.contains(i + 1)) {
                        vals = entries[i].split(LIST_DELIMITER);
                        ArrayList<String> listVals = row.getList(tag.toString(), String.class);
                        if (listVals == null) {
                            listVals = new ArrayList<String>();
                        }
                        for (String val : vals) {
                            if (listVals.contains(val)) continue;
                            listVals.add(val);
                        }
                        row.set(tag.toString(), listVals);
                        continue block7;
                    }
                    row.set(tag.toString(), (Object)entries[i]);
                }
            }
        }
    }

    private String convertToName(String id) {
        Collection rows = this.ontologyDAG.getDefaultNodeTable().getMatchingRows("name", (Object)id);
        if (!rows.isEmpty()) {
            CyRow row = (CyRow)rows.iterator().next();
            String termName = (String)row.get("term name", String.class);
            if (termName != null) {
                return termName;
            }
            return id;
        }
        return id;
    }

    public CyTable[] getTables() {
        return this.tables;
    }

    static {
        LIST_INDEX.add(4);
        LIST_INDEX.add(8);
        LIST_INDEX.add(11);
        LIST_INDEX.add(16);
        NAMESPACE_MAP.put("P", "biological process");
        NAMESPACE_MAP.put("F", "molecular function");
        NAMESPACE_MAP.put("C", "cellular component");
        GA_DELIMITER = TextDelimiter.TAB.getDelimiter();
    }
}

