/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.reader;

public enum TextDelimiter {
    TAB("tab", "\\t"),
    COMMA(",", ","),
    SEMICOLON(";", ";"),
    SPACE("space", " "),
    PIPE("|", "\\|"),
    COLON(":", ":"),
    SLASH("/", "/"),
    BACKSLASH("\\", "\\");

    private final String label;
    private final String delimiter;

    private TextDelimiter(String label, String delimiter) {
        this.label = label;
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String toString() {
        return this.label;
    }

    public static TextDelimiter getByLabel(String label) {
        for (TextDelimiter del : TextDelimiter.values()) {
            if (!del.toString().equals(label)) continue;
            return del;
        }
        return null;
    }
}

