/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.reader;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.reader.AbstractLineParser;
import org.cytoscape.tableimport.internal.reader.AbstractMappingParameters;
import org.cytoscape.tableimport.internal.reader.NetworkTableMappingParameters;
import org.cytoscape.tableimport.internal.util.AttributeDataType;
import org.cytoscape.tableimport.internal.util.SourceColumnSemantic;

public class NetworkLineParser
extends AbstractLineParser {
    private final NetworkTableMappingParameters mapping;
    private final List<Long> nodeList;
    private final List<Long> edgeList;
    private CyNetwork network;
    private Map<Object, CyNode> nMap;
    private final CyRootNetwork rootNetwork;

    public NetworkLineParser(List<Long> nodeList, List<Long> edgeList, NetworkTableMappingParameters mapping, Map<Object, CyNode> nMap, CyRootNetwork rootNetwork, CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.mapping = mapping;
        this.nodeList = nodeList;
        this.edgeList = edgeList;
        this.nMap = nMap;
        this.rootNetwork = rootNetwork;
    }

    public void parseEntry(String[] parts) {
        CyNode source = this.createNode(parts, this.mapping.getSourceIndex());
        CyNode target = this.createNode(parts, this.mapping.getTargetIndex());
        SourceColumnSemantic[] types = this.mapping.getTypes();
        ArrayList<Integer> srcAttrIdxs = new ArrayList<Integer>();
        ArrayList<Integer> tgtAttrIdxs = new ArrayList<Integer>();
        ArrayList<Integer> edgeAttrIdxs = new ArrayList<Integer>();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == SourceColumnSemantic.SOURCE_ATTR) {
                srcAttrIdxs.add(i);
                continue;
            }
            if (types[i] == SourceColumnSemantic.TARGET_ATTR) {
                tgtAttrIdxs.add(i);
                continue;
            }
            if (types[i] != SourceColumnSemantic.EDGE_ATTR && types[i] != SourceColumnSemantic.ATTR) continue;
            edgeAttrIdxs.add(i);
        }
        if (source != null) {
            this.addAttributes(source, parts, srcAttrIdxs);
        }
        if (target != null) {
            this.addAttributes(target, parts, tgtAttrIdxs);
        }
        if (source == null || target == null) {
            return;
        }
        String interaction = this.mapping.getInteractionIndex() == -1 || this.mapping.getInteractionIndex() > parts.length - 1 || parts[this.mapping.getInteractionIndex()] == null ? this.mapping.getDefaultInteraction() : parts[this.mapping.getInteractionIndex()];
        CyEdge edge = this.network.addEdge(source, target, true);
        this.network.getRow((CyIdentifiable)edge).set("interaction", (Object)interaction);
        String edgeName = (String)this.network.getRow((CyIdentifiable)source).get("name", String.class) + " (" + interaction + ") " + (String)this.network.getRow((CyIdentifiable)target).get("name", String.class);
        this.network.getRow((CyIdentifiable)edge).set("name", (Object)edgeName);
        this.edgeList.add(edge.getSUID());
        if (edge != null) {
            this.addAttributes(edge, parts, edgeAttrIdxs);
        }
    }

    private CyNode createNode(String[] parts, Integer nodeIndex) {
        CyNode node = null;
        if (!nodeIndex.equals(-1) && nodeIndex <= parts.length - 1 && parts[nodeIndex] != null) {
            if (this.nMap.get(parts[nodeIndex]) == null) {
                node = this.network.addNode();
                this.network.getRow((CyIdentifiable)node).set("name", (Object)parts[nodeIndex]);
                this.nMap.put(parts[nodeIndex], this.rootNetwork.getNode(node.getSUID().longValue()));
                this.nodeList.add(node.getSUID());
            } else {
                CyNode parentNode = this.nMap.get(parts[nodeIndex]);
                CySubNetwork subnet = (CySubNetwork)this.network;
                subnet.addNode(parentNode);
                node = subnet.getNode(parentNode.getSUID().longValue());
            }
        }
        return node;
    }

    private <T extends CyIdentifiable> void addAttributes(T element, String[] parts, List<Integer> attrIdxs) {
        for (int i = 0; i < attrIdxs.size(); ++i) {
            int idx = attrIdxs.get(i);
            if (parts.length <= idx || parts[idx] == null) continue;
            this.mapAttribute(element, parts[idx].trim(), idx);
        }
    }

    private <T extends CyIdentifiable> void mapAttribute(T element, String entry, int index) {
        String namespace;
        if (entry == null || entry.length() == 0) {
            return;
        }
        AttributeDataType type = this.mapping.getDataTypes()[index];
        String string = namespace = this.mapping.getNamespaces() != null && this.mapping.getNamespaces().length > index ? this.mapping.getNamespaces()[index] : null;
        if (namespace == null) {
            namespace = "USER";
        }
        if (type.isList()) {
            ArrayList value;
            String[] delimiters;
            String delimiter;
            CyTable table = this.network.getRow(element, namespace).getTable();
            if (table.getColumn(this.mapping.getAttributeNames()[index]) == null) {
                table.createListColumn(this.mapping.getAttributeNames()[index], type.getListType(), false);
            }
            String string2 = delimiter = (delimiters = this.mapping.getListDelimiters()) != null && delimiters.length > index ? delimiters[index] : AbstractMappingParameters.DEF_LIST_DELIMITER;
            if (delimiter == null || delimiter.isEmpty()) {
                delimiter = AbstractMappingParameters.DEF_LIST_DELIMITER;
            }
            if ((value = this.parse(entry, type, delimiter, this.mapping.getDecimalSeparator())) instanceof List) {
                ArrayList curList = (ArrayList)this.network.getRow(element, namespace).get(this.mapping.getAttributeNames()[index], List.class);
                if (curList == null) {
                    curList = new ArrayList();
                }
                curList.addAll(value);
                value = curList;
            }
            this.network.getRow(element, namespace).set(this.mapping.getAttributeNames()[index], (Object)value);
        } else {
            this.createColumn(element, this.mapping.getAttributeNames()[index], type.getType(), namespace);
            Object value = this.parse(entry, type, null, this.mapping.getDecimalSeparator());
            this.network.getRow(element, namespace).set(this.mapping.getAttributeNames()[index], value);
        }
    }

    private <T extends CyIdentifiable> void createColumn(T element, String attributeName, Class<?> type, String namespace) {
        CyTable table = this.network.getRow(element, namespace).getTable();
        if (table.getColumn(attributeName) == null) {
            table.createColumn(attributeName, type, false);
        }
    }

    public void setNetwork(CyNetwork network) {
        this.network = network;
    }
}

