/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.reader;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.cytoscape.tableimport.internal.reader.AbstractMappingParameters;
import org.cytoscape.tableimport.internal.util.AttributeDataType;
import org.cytoscape.tableimport.internal.util.SourceColumnSemantic;
import org.cytoscape.tableimport.internal.util.TypeUtil;

public class AttributeMappingParameters
extends AbstractMappingParameters {
    private final int keyIndex;

    public AttributeMappingParameters(InputStream is, String fileType) {
        super(is, fileType);
        this.keyIndex = -1;
    }

    public AttributeMappingParameters(String name, List<String> delimiters, String[] listDelimiters, int keyIndex, String[] attrNames, AttributeDataType[] dataTypes, SourceColumnSemantic[] types, String[] namespaces, Character decimalSeparator) throws Exception {
        this(name, delimiters, listDelimiters, keyIndex, attrNames, dataTypes, types, namespaces, 0, null, decimalSeparator);
    }

    public AttributeMappingParameters(String name, List<String> delimiters, String[] listDelimiters, int keyIndex, String[] attrNames, AttributeDataType[] dataTypes, SourceColumnSemantic[] types, String[] namespaces, int startNumber, String commentChar, Character decimalSeparator) throws Exception {
        super(name, delimiters, listDelimiters, attrNames, dataTypes, types, namespaces, startNumber, commentChar, decimalSeparator);
        if (attrNames == null) {
            throw new Exception("attributeNames should not be null.");
        }
        if (attrNames.length < keyIndex) {
            throw new IOException("Key is out of range.");
        }
        this.keyIndex = keyIndex;
        if (dataTypes == null) {
            this.dataTypes = new AttributeDataType[attrNames.length];
            Arrays.fill((Object[])this.dataTypes, (Object)AttributeDataType.TYPE_STRING);
        } else {
            this.dataTypes = dataTypes;
        }
        if (types == null) {
            this.types = new SourceColumnSemantic[attrNames.length];
            Arrays.fill((Object[])this.types, (Object)SourceColumnSemantic.ATTR);
        } else {
            this.types = types;
        }
        this.namespaces = namespaces == null ? TypeUtil.getPreferredNamespaces(this.types) : namespaces;
    }

    public int getKeyIndex() {
        return this.keyIndex;
    }
}

