/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.reader;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.cytoscape.equations.Equation;
import org.cytoscape.equations.EquationCompiler;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.util.AttributeDataType;

public abstract class AbstractLineParser {
    protected CyServiceRegistrar serviceRegistrar;
    private EquationCompiler compiler;

    protected AbstractLineParser(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public Object parse(String s, AttributeDataType type, String delimiter, Character decimalSeparator) {
        Object value = null;
        if (s != null && !s.isEmpty() && !"null".equals(s)) {
            try {
                switch (type) {
                    case TYPE_BOOLEAN: {
                        return Boolean.valueOf(s.trim());
                    }
                    case TYPE_INTEGER: {
                        return Integer.valueOf(s.trim());
                    }
                    case TYPE_LONG: {
                        return Long.valueOf(s.trim());
                    }
                    case TYPE_FLOATING: {
                        Locale locale = Locale.US;
                        DecimalFormatSymbols dfs = new DecimalFormatSymbols(locale);
                        dfs.setDecimalSeparator(decimalSeparator.charValue());
                        dfs.setExponentSeparator("E");
                        DecimalFormat df = new DecimalFormat();
                        df.setDecimalFormatSymbols(dfs);
                        df.setGroupingUsed(false);
                        String s1 = s.replace('e', 'E');
                        try {
                            return df.parse(s1.trim()).doubleValue();
                        }
                        catch (ParseException pe) {
                            value = this.createInvalidNumberEquation(s1.trim(), type);
                        }
                    }
                    case TYPE_STRING: {
                        return s.trim();
                    }
                    case TYPE_BOOLEAN_LIST: 
                    case TYPE_INTEGER_LIST: 
                    case TYPE_LONG_LIST: 
                    case TYPE_FLOATING_LIST: 
                    case TYPE_STRING_LIST: {
                        value = this.parseList(s, type, delimiter);
                        if (!(value instanceof List)) break;
                        value = new ArrayList((List)value);
                    }
                }
            }
            catch (NumberFormatException e) {
                value = this.createInvalidNumberEquation(s.trim(), type);
            }
        }
        return value;
    }

    private Object parseList(String s, AttributeDataType type, String delimiter) {
        String[] parts;
        if (s == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (String listItem : parts = s.replace("\"", "").split(delimiter)) {
            try {
                if (type == AttributeDataType.TYPE_BOOLEAN_LIST) {
                    list.add(Boolean.valueOf(listItem.trim()));
                    continue;
                }
                if (type == AttributeDataType.TYPE_INTEGER_LIST) {
                    list.add(Integer.valueOf(listItem.trim()));
                    continue;
                }
                if (type == AttributeDataType.TYPE_LONG_LIST) {
                    list.add(Long.valueOf(listItem.trim()));
                    continue;
                }
                if (type == AttributeDataType.TYPE_FLOATING_LIST) {
                    list.add(Double.valueOf(listItem.trim()));
                    continue;
                }
                list.add(listItem.trim());
            }
            catch (NumberFormatException e) {
                return this.createInvalidListEquation(s, listItem.trim(), type);
            }
        }
        return list;
    }

    private Equation createInvalidNumberEquation(String value, AttributeDataType type) {
        String text = "=\"" + value + "\"";
        String msg = "Invalid value: " + value;
        return this.getEquationCompiler().getErrorEquation(text, type.getType(), msg);
    }

    private Equation createInvalidListEquation(String list, String listItem, AttributeDataType type) {
        String text = "=\"" + list + "\"";
        String msg = "Invalid list item: " + listItem;
        return this.getEquationCompiler().getErrorEquation(text, type.getType(), msg);
    }

    private EquationCompiler getEquationCompiler() {
        if (this.compiler == null) {
            this.compiler = (EquationCompiler)this.serviceRegistrar.getService(EquationCompiler.class);
        }
        return this.compiler;
    }
}

