/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model.internal.table;

import java.util.Collection;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.ColumnCreatedEvent;
import org.cytoscape.model.events.ColumnCreatedListener;
import org.cytoscape.model.events.ColumnDeletedEvent;
import org.cytoscape.model.events.ColumnDeletedListener;
import org.cytoscape.model.events.RowsCreatedEvent;
import org.cytoscape.model.events.RowsCreatedListener;
import org.cytoscape.model.events.RowsDeletedEvent;
import org.cytoscape.model.events.RowsDeletedListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.events.AboutToRemoveColumnViewEvent;
import org.cytoscape.view.model.events.AboutToRemoveRowViewsEvent;
import org.cytoscape.view.model.events.AddedColumnViewEvent;
import org.cytoscape.view.model.events.AddedRowViewsEvent;
import org.cytoscape.view.model.internal.table.CyColumnViewImpl;
import org.cytoscape.view.model.internal.table.CyTableViewImpl;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.model.table.CyTableViewManager;
import org.cytoscape.view.presentation.property.table.BasicTableVisualLexicon;

public class TableModelListener
implements ColumnCreatedListener,
ColumnDeletedListener,
RowsCreatedListener,
RowsDeletedListener {
    private final CyTableViewImpl tableView;
    private final CyServiceRegistrar registrar;
    private final CyEventHelper eventHelper;

    public TableModelListener(CyTableViewImpl tableView, CyServiceRegistrar registrar) {
        this.tableView = tableView;
        this.registrar = registrar;
        this.eventHelper = (CyEventHelper)registrar.getService(CyEventHelper.class);
    }

    public void handleEvent(ColumnCreatedEvent e) {
        if (this.tableView.getModel() != e.getSource()) {
            return;
        }
        CyTable table = (CyTable)e.getSource();
        CyColumn column = table.getColumn(e.getColumnName());
        if (column != null) {
            CyColumnViewImpl view = this.tableView.addColumn(column);
            CyTableViewManager tableViewManager = (CyTableViewManager)this.registrar.getService(CyTableViewManager.class);
            if (tableViewManager.getTableView((CyTable)this.tableView.getModel()) != null && this.tableView.getVisualLexicon() instanceof BasicTableVisualLexicon) {
                Double lastGrav;
                Collection colViews = this.tableView.getColumnViews();
                colViews.sort(VisualProperty.comparing((VisualProperty)BasicTableVisualLexicon.COLUMN_GRAVITY));
                if (!colViews.isEmpty() && (lastGrav = (Double)((View)colViews.get(colViews.size() - 1)).getVisualProperty(BasicTableVisualLexicon.COLUMN_GRAVITY)) != null) {
                    view.setLockedValue(BasicTableVisualLexicon.COLUMN_GRAVITY, lastGrav + 1.0);
                }
            }
            if (view != null) {
                this.eventHelper.fireEvent((CyEvent)new AddedColumnViewEvent((CyTableView)this.tableView, (View)view));
            }
        }
    }

    public void handleEvent(ColumnDeletedEvent e) {
        if (this.tableView.getModel() != e.getSource()) {
            return;
        }
        Long suid = e.getSUID();
        if (suid != null) {
            View<CyColumn> view = this.tableView.getColumnViewByDataSuid(suid);
            if (view != null) {
                this.eventHelper.fireEvent((CyEvent)new AboutToRemoveColumnViewEvent((CyTableView)this.tableView, view));
                this.tableView.removeColumn(suid);
            }
        } else {
            String name = e.getColumnName();
            View<CyColumn> view = this.tableView.getColumnViewByName(name);
            if (view != null) {
                this.eventHelper.fireEvent((CyEvent)new AboutToRemoveColumnViewEvent((CyTableView)this.tableView, view));
                this.tableView.removeColumn(((CyColumn)view.getModel()).getSUID());
            }
        }
    }

    public void handleEvent(RowsCreatedEvent e) {
        if (this.tableView.getModel() != e.getSource()) {
            return;
        }
        CyTable table = (CyTable)e.getSource();
        for (Object key : e.getPayloadCollection()) {
            CyRow row = table.getRow(key);
            if (row == null) continue;
            View<CyRow> rowView = this.tableView.addRow(row);
            this.eventHelper.addEventPayload((Object)this.tableView, rowView, AddedRowViewsEvent.class);
        }
    }

    public void handleEvent(RowsDeletedEvent e) {
        if (this.tableView.getModel() != e.getSource()) {
            return;
        }
        for (Object primaryKey : e.getKeys()) {
            View<CyRow> rowView = this.tableView.removeRow(primaryKey);
            if (rowView == null) continue;
            this.eventHelper.addEventPayload((Object)this.tableView, rowView, AboutToRemoveRowViewsEvent.class);
        }
    }
}

