/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model.internal.table;

import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.events.TableViewAddedEvent;
import org.cytoscape.view.model.events.TableViewAddedListener;
import org.cytoscape.view.model.events.TableViewChangedEvent;
import org.cytoscape.view.model.events.ViewChangeRecord;
import org.cytoscape.view.model.internal.base.CyViewBase;
import org.cytoscape.view.model.internal.base.VPStore;
import org.cytoscape.view.model.internal.base.ViewLock;
import org.cytoscape.view.model.internal.table.CyColumnViewImpl;
import org.cytoscape.view.model.internal.table.CyRowViewImpl;
import org.cytoscape.view.model.table.CyTableView;

public class CyTableViewImpl
extends CyViewBase<CyTable>
implements CyTableView,
TableViewAddedListener {
    private final CyServiceRegistrar registrar;
    private final CyEventHelper eventHelper;
    private final String rendererId;
    private final VisualLexicon visualLexicon;
    private Map<Long, CyColumnViewImpl> dataSuidToCol = HashMap.empty();
    private Map<Long, CyColumnViewImpl> viewSuidToCol = HashMap.empty();
    private Map<Long, CyRowViewImpl> dataSuidToRow = HashMap.empty();
    private Map<Long, CyRowViewImpl> viewSuidToRow = HashMap.empty();
    private Map<Object, CyRowViewImpl> pkToRow = HashMap.empty();
    protected final ViewLock tableLock;
    protected final ViewLock columnLock;
    protected final ViewLock rowLock;
    protected final VPStore tableVPs;
    protected final VPStore columnVPs;
    protected final VPStore rowVPs;
    private boolean fireEvents = false;
    private CopyOnWriteArrayList<Runnable> disposeListeners = new CopyOnWriteArrayList();

    public CyTableViewImpl(CyServiceRegistrar registrar, CyTable model, VisualLexicon visualLexicon, String rendererId) {
        super(model);
        this.registrar = registrar;
        this.eventHelper = (CyEventHelper)registrar.getService(CyEventHelper.class);
        this.rendererId = rendererId;
        this.visualLexicon = visualLexicon;
        this.tableLock = new ViewLock();
        this.columnLock = new ViewLock(this.tableLock);
        this.rowLock = new ViewLock(this.tableLock);
        this.tableVPs = new VPStore(CyTable.class, visualLexicon, null);
        this.columnVPs = new VPStore(CyColumn.class, visualLexicon, null);
        this.rowVPs = new VPStore(CyRow.class, visualLexicon, null);
        registrar.registerService((Object)this, TableViewAddedListener.class);
    }

    public void handleEvent(TableViewAddedEvent e) {
        if (e.getTableView() == this) {
            this.fireEvents = true;
        }
    }

    protected void addEventPayload(ViewChangeRecord<?> record) {
        if (this.fireEvents) {
            this.eventHelper.addEventPayload((Object)this, record, TableViewChangedEvent.class);
        }
    }

    public void dispose() {
        this.registrar.unregisterService((Object)this, TableViewAddedListener.class);
        for (Runnable runnable : this.disposeListeners) {
            runnable.run();
        }
    }

    public String getRendererId() {
        return this.rendererId;
    }

    @Override
    public VisualLexicon getVisualLexicon() {
        return this.visualLexicon;
    }

    @Override
    public VPStore getVPStore() {
        return this.tableVPs;
    }

    @Override
    public ViewLock getLock() {
        return this.tableLock;
    }

    public void addDisposeListener(Runnable runnable) {
        this.disposeListeners.add(runnable);
    }

    public int getColumnCount() {
        return this.viewSuidToCol.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyColumnViewImpl addColumn(CyColumn model) {
        if (this.dataSuidToCol.containsKey((Object)model.getSUID())) {
            return null;
        }
        CyColumnViewImpl view = new CyColumnViewImpl(this, model);
        ViewLock viewLock = this.columnLock;
        synchronized (viewLock) {
            this.dataSuidToCol = this.dataSuidToCol.put((Object)model.getSUID(), (Object)view);
            this.viewSuidToCol = this.viewSuidToCol.put((Object)view.getSUID(), (Object)view);
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View<CyColumn> removeColumn(Long dataSuid) {
        ViewLock viewLock = this.columnLock;
        synchronized (viewLock) {
            View colView = (View)this.dataSuidToCol.getOrElse((Object)dataSuid, null);
            if (colView != null) {
                this.dataSuidToCol = this.dataSuidToCol.remove((Object)dataSuid);
                this.viewSuidToCol = this.viewSuidToCol.remove((Object)colView.getSUID());
                this.columnVPs.remove(colView.getSUID());
            }
            return colView;
        }
    }

    public View<CyColumn> getColumnView(CyColumn column) {
        return (View)this.dataSuidToCol.getOrElse((Object)column.getSUID(), null);
    }

    public View<CyColumn> getColumnViewByDataSuid(Long suid) {
        return (View)this.dataSuidToCol.getOrElse((Object)suid, null);
    }

    public View<CyColumn> getColumnView(long viewSuid) {
        return (View)this.viewSuidToCol.getOrElse((Object)viewSuid, null);
    }

    public View<CyColumn> getColumnViewByName(String name) {
        for (Tuple2 entry : this.dataSuidToCol) {
            CyColumnViewImpl col = (CyColumnViewImpl)entry._2();
            String colName = ((CyColumn)col.getModel()).getName();
            if (colName == null || !colName.equals(name)) continue;
            return col;
        }
        return null;
    }

    public List<View<CyColumn>> getColumnViews() {
        ArrayList<View<CyColumn>> colList = new ArrayList<View<CyColumn>>();
        for (CyColumnViewImpl col : this.dataSuidToCol.values()) {
            colList.add(col);
        }
        Collection modelCols = ((CyTable)this.getModel()).getColumns();
        java.util.HashMap<Long, Integer> indexMap = new java.util.HashMap<Long, Integer>();
        int i = 0;
        for (CyColumn col : modelCols) {
            indexMap.put(col.getSUID(), i++);
        }
        colList.sort((cv1, cv2) -> {
            Integer index1 = (Integer)indexMap.get(((CyColumn)cv1.getModel()).getSUID());
            Integer index2 = (Integer)indexMap.get(((CyColumn)cv2.getModel()).getSUID());
            if (index1 == null) {
                return -1;
            }
            if (index2 == null) {
                return 1;
            }
            return Integer.compare(index1, index2);
        });
        return colList;
    }

    public Collection<View<CyRow>> getRowViews() {
        ArrayList<View<CyRow>> rowList = new ArrayList<View<CyRow>>();
        for (CyRowViewImpl row : this.dataSuidToRow.values()) {
            rowList.add(row);
        }
        return rowList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View<CyRow> addRow(CyRow model) {
        if (this.dataSuidToRow.containsKey((Object)model.getSUID())) {
            return null;
        }
        CyColumn pkCol = ((CyTable)this.getModel()).getPrimaryKey();
        Object pkValue = model.get(pkCol.getName(), pkCol.getType());
        if (pkValue == null) {
            return null;
        }
        CyRowViewImpl rowView = new CyRowViewImpl(this, model);
        ViewLock viewLock = this.rowLock;
        synchronized (viewLock) {
            this.dataSuidToRow = this.dataSuidToRow.put((Object)model.getSUID(), (Object)rowView);
            this.viewSuidToRow = this.viewSuidToRow.put((Object)rowView.getSUID(), (Object)rowView);
            this.pkToRow = this.pkToRow.put(pkValue, (Object)rowView);
        }
        return rowView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View<CyRow> removeRow(Object pkValue) {
        ViewLock viewLock = this.rowLock;
        synchronized (viewLock) {
            View rowView = (View)this.pkToRow.getOrElse(pkValue, null);
            if (rowView != null) {
                this.dataSuidToRow = this.dataSuidToRow.remove((Object)((CyRow)rowView.getModel()).getSUID());
                this.viewSuidToRow = this.viewSuidToRow.remove((Object)rowView.getSUID());
                this.pkToRow = this.pkToRow.remove(pkValue);
                this.columnVPs.remove(rowView.getSUID());
            }
            return rowView;
        }
    }

    public View<CyRow> getRowView(CyRow row) {
        return (View)this.dataSuidToRow.getOrElse((Object)row.getSUID(), null);
    }

    public View<CyRow> getRowViewByPk(Object pkValue) {
        return (View)this.pkToRow.getOrElse(pkValue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, V extends T> void setViewDefault(VisualProperty<? extends T> vp, V defaultValue) {
        if (vp.shouldIgnoreDefault()) {
            return;
        }
        Class type = vp.getTargetDataType();
        if (type.equals(CyColumn.class)) {
            ViewLock viewLock = this.columnLock;
            synchronized (viewLock) {
                this.columnVPs.setViewDefault(vp, defaultValue);
            }
        }
        if (vp.getTargetDataType().equals(CyRow.class)) {
            ViewLock viewLock = this.rowLock;
            synchronized (viewLock) {
                this.rowVPs.setViewDefault(vp, defaultValue);
            }
        }
        if (vp.getTargetDataType().equals(CyTable.class)) {
            ViewLock viewLock = this.tableLock;
            synchronized (viewLock) {
                this.tableVPs.setViewDefault(vp, defaultValue);
            }
        }
    }

    @Override
    protected void fireViewChangedEvent(VisualProperty<?> vp, Object value, boolean lockedValue) {
        this.addEventPayload(new ViewChangeRecord((View)this, vp, value, lockedValue));
    }
}

