/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model.internal.network.snapshot;

import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.SnapshotNodeInfo;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.internal.base.VPStore;
import org.cytoscape.view.model.internal.network.CyNodeViewImpl;
import org.cytoscape.view.model.internal.network.snapshot.CyNetworkViewSnapshotImpl;
import org.cytoscape.view.model.internal.network.snapshot.CyViewSnapshotBase;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class CyNodeViewSnapshotImpl
extends CyViewSnapshotBase<CyNode>
implements SnapshotNodeInfo {
    private final CyNetworkViewSnapshotImpl parent;
    private final CyNodeViewImpl view;
    public final double x;
    public final double y;
    public final double w;
    public final double h;

    public CyNodeViewSnapshotImpl(CyNetworkViewSnapshotImpl parent, CyNodeViewImpl view) {
        super(view.getSUID());
        this.parent = parent;
        this.view = view;
        if (parent.isBVL()) {
            this.x = CyNodeViewSnapshotImpl.getDoubleVP(view, (VisualProperty<Double>)BasicVisualLexicon.NODE_X_LOCATION);
            this.y = CyNodeViewSnapshotImpl.getDoubleVP(view, (VisualProperty<Double>)BasicVisualLexicon.NODE_Y_LOCATION);
            this.w = CyNodeViewSnapshotImpl.getDoubleVP(view, (VisualProperty<Double>)BasicVisualLexicon.NODE_WIDTH);
            this.h = CyNodeViewSnapshotImpl.getDoubleVP(view, (VisualProperty<Double>)BasicVisualLexicon.NODE_HEIGHT);
        } else {
            this.h = 0.0;
            this.w = 0.0;
            this.y = 0.0;
            this.x = 0.0;
        }
    }

    private static double getDoubleVP(CyNodeViewImpl view, VisualProperty<Double> vp) {
        Double val = view.getVisualProperty(vp);
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        return (Double)vp.getDefault();
    }

    @Override
    public CyNetworkViewSnapshotImpl getNetworkSnapshot() {
        return this.parent;
    }

    public Long getModelSUID() {
        return ((CyNode)this.view.getModel()).getSUID();
    }

    @Override
    public VPStore getVPStore() {
        return this.getNetworkSnapshot().nodeVPs;
    }
}

