/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model.internal.base;

import io.vavr.collection.Set;
import java.util.Objects;
import java.util.function.Consumer;
import org.cytoscape.model.SUIDFactory;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualLexiconNode;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.internal.base.VPStore;
import org.cytoscape.view.model.internal.base.ViewLock;

public abstract class CyViewBase<M>
implements View<M> {
    private final Long suid;
    private final M model;

    public CyViewBase(M model) {
        this.model = Objects.requireNonNull(model);
        this.suid = SUIDFactory.getNextSUID();
    }

    public abstract VPStore getVPStore();

    public abstract ViewLock getLock();

    public abstract VisualLexicon getVisualLexicon();

    protected abstract void fireViewChangedEvent(VisualProperty<?> var1, Object var2, boolean var3);

    public void setDirty() {
    }

    public Long getSUID() {
        return this.suid;
    }

    public M getModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, V extends T> void setVisualProperty(VisualProperty<? extends T> vp, V value) {
        ViewLock lock;
        ViewLock viewLock = lock = this.getLock();
        synchronized (viewLock) {
            boolean changed = this.getVPStore().setVisualProperty(this.suid, vp, value);
            if (changed) {
                boolean locked;
                if (lock.isUpdateDirty()) {
                    this.setDirty();
                }
                if (!(locked = this.getVPStore().isValueLocked(this.suid, vp))) {
                    this.fireViewChangedEvent(vp, value, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batch(Consumer<View<M>> viewConsumer, boolean setDirty) {
        ViewLock lock;
        ViewLock viewLock = lock = this.getLock();
        synchronized (viewLock) {
            lock.enterBatch(() -> viewConsumer.accept(this));
            if (setDirty && lock.isUpdateDirty()) {
                this.setDirty();
            }
        }
    }

    public <T> T getVisualProperty(VisualProperty<T> vp) {
        return this.getVPStore().getVisualProperty(this.suid, vp);
    }

    public boolean isSet(VisualProperty<?> vp) {
        return this.getVPStore().isSet(this.suid, vp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, V extends T> void setLockedValue(VisualProperty<? extends T> vp, V value) {
        ViewLock lock;
        ViewLock viewLock = lock = this.getLock();
        synchronized (viewLock) {
            boolean changed = this.getVPStore().setLockedValue(this.suid, vp, value);
            if (changed) {
                VisualLexiconNode visualLexiconNode;
                if (lock.isUpdateDirty()) {
                    this.setDirty();
                }
                if ((visualLexiconNode = this.getVisualLexicon().getVisualLexiconNode(vp)).getChildren().isEmpty()) {
                    this.fireViewChangedEvent(vp, value, true);
                } else {
                    visualLexiconNode.visitDescendants(node -> {
                        VisualProperty nodeVP = node.getVisualProperty();
                        Object nodeValue = this.getVPStore().getVisualProperty(this.suid, vp);
                        this.fireViewChangedEvent(nodeVP, nodeValue, true);
                    });
                }
            }
        }
    }

    public boolean isValueLocked(VisualProperty<?> vp) {
        return this.getVPStore().isValueLocked(this.suid, vp);
    }

    public void clearValueLock(VisualProperty<?> vp) {
        this.setLockedValue(vp, null);
    }

    public boolean isDirectlyLocked(VisualProperty<?> vp) {
        return this.getVPStore().isDirectlyLocked(this.suid, vp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearVisualProperties() {
        Set<VisualProperty<?>> clearableVPs = this.getVPStore().getClearableVisualProperties(this.suid);
        ViewLock viewLock = this.getLock();
        synchronized (viewLock) {
            for (VisualProperty vp : clearableVPs) {
                this.setVisualProperty(vp, null);
            }
        }
    }
}

