/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.webservice.psicquic.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.DefaultRowSorter;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.create.CreateNetworkViewTaskFactory;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.webservice.psicquic.PSICQUICRestClient;
import org.cytoscape.webservice.psicquic.PSIMI25VisualStyleBuilder;
import org.cytoscape.webservice.psicquic.RegistryManager;
import org.cytoscape.webservice.psicquic.task.ImportNetworkFromPSICQUICTask;
import org.cytoscape.webservice.psicquic.ui.PSIMITagManager;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.swing.DialogTaskManager;

public class SourceStatusPanel
extends JPanel
implements TaskObserver {
    private static final String ACTIVE = "Active";
    private static final String INACTIVE = "Inactive";
    private static final Color SELECTED_ROW = UIManager.getColor("Table.selectionBackground");
    private static final int IMPORT_COLUMN_INDEX = 0;
    private static final int STATUS_COLUMN_INDEX = 1;
    private static final int DB_NAME_COLUMN_INDEX = 2;
    private static final int RECORD_COUNT_COLUMN_INDEX = 3;
    private static final int TAG_COLUMN_INDEX = 4;
    private boolean cancelFlag = false;
    private final RegistryManager manager;
    private final PSICQUICRestClient client;
    private String query;
    private final PSICQUICRestClient.SearchMode mode;
    private final PSIMI25VisualStyleBuilder vsBuilder;
    private final PSIMITagManager tagManager;
    private final CyServiceRegistrar serviceRegistrar;
    private int interactionsFound;
    private JPanel buttonPanel;
    private JButton selectNoneButton;
    private JButton selectAllButton;
    private JCheckBox clusterResultCheckBox;
    private JScrollPane resultScrollPane;
    private JTable resultTable;
    private Set<CyNetwork> results;

    public SourceStatusPanel(String query, PSICQUICRestClient client, RegistryManager manager, Map<String, Long> result, PSICQUICRestClient.SearchMode mode, PSIMI25VisualStyleBuilder vsBuilder, PSIMITagManager tagManager, CyServiceRegistrar serviceRegistrar) {
        this.manager = manager;
        this.client = client;
        this.query = query;
        this.tagManager = tagManager;
        this.serviceRegistrar = serviceRegistrar;
        this.mode = mode == PSICQUICRestClient.SearchMode.SPECIES ? PSICQUICRestClient.SearchMode.MIQL : mode;
        this.vsBuilder = vsBuilder;
        this.setTableModel(result);
        this.refreshGUI();
        if (LookAndFeelUtil.isAquaLAF()) {
            this.setOpaque(false);
        }
        this.resultTable.setEnabled(false);
        this.serviceRegistrar.registerService((Object)this, TaskObserver.class, new Properties());
    }

    private void refreshGUI() {
        this.initComponents();
        this.setCoumnWidth();
    }

    public void enableComponents(boolean enable) {
        this.resultTable.setEnabled(enable);
        this.resultScrollPane.setEnabled(enable);
        this.selectAllButton.setEnabled(enable);
        this.selectNoneButton.setEnabled(enable);
        this.clusterResultCheckBox.setEnabled(enable);
        this.setEnabled(enable);
    }

    public Set<String> getSelected() {
        if (this.cancelFlag) {
            return null;
        }
        HashSet<String> selectedService = new HashSet<String>();
        StringBuilder builder = new StringBuilder();
        TableModel model = this.resultTable.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            Boolean selected = (Boolean)model.getValueAt(i, 0);
            if (selected == null) {
                selected = false;
            }
            if (!selected.booleanValue()) continue;
            String selectedSource = model.getValueAt(i, 2).toString();
            builder.append(selectedSource + ",");
            selectedService.add(selectedSource);
        }
        String selectedSourceString = builder.toString();
        if (!selectedSourceString.equals("")) {
            selectedSourceString = selectedSourceString.substring(0, selectedSourceString.length() - 1);
            CyProperty props = (CyProperty)this.serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
            ((Properties)props.getProperties()).setProperty("psiqcuic.datasource.selection", selectedSourceString);
        }
        return selectedService;
    }

    private void setCoumnWidth() {
        this.resultTable.getTableHeader().setReorderingAllowed(false);
        this.resultTable.setAutoResizeMode(0);
        this.resultTable.getColumnModel().getColumn(0).setPreferredWidth(60);
        this.resultTable.getColumnModel().getColumn(1).setPreferredWidth(60);
        this.resultTable.getColumnModel().getColumn(2).setPreferredWidth(120);
        this.resultTable.getColumnModel().getColumn(3).setPreferredWidth(120);
        this.resultTable.getColumnModel().getColumn(4).setPreferredWidth(280);
        this.resultTable.setSelectionBackground(SELECTED_ROW);
        this.resultTable.setDefaultRenderer(Boolean.class, new BooleanCellRenderer(this.resultTable.getDefaultRenderer(Boolean.class)));
        this.resultTable.setDefaultRenderer(String.class, new StringCellRenderer());
        this.resultTable.setDefaultRenderer(Number.class, new NumberCellRenderer());
    }

    private void setTableModel(Map<String, Long> result) {
        StatusTableModel model = new StatusTableModel();
        model.addColumn("Import");
        model.addColumn("Status");
        model.addColumn("Database Name");
        model.addColumn("Records Found");
        model.addColumn("Database Type (Tags)");
        this.interactionsFound = 0;
        for (String serviceName : this.manager.getAllServiceNames()) {
            Integer errorID = null;
            Object[] rowValues = new Object[5];
            rowValues[2] = serviceName;
            rowValues[4] = this.convertTags(serviceName);
            if (result != null) {
                String targetURL = this.manager.getActiveServices().get(serviceName);
                if (targetURL != null) {
                    Long targetResult = result.get(targetURL);
                    if (targetResult == null) {
                        rowValues[3] = 0;
                    } else {
                        Integer count = targetResult.intValue();
                        if (count > 0) {
                            this.interactionsFound += count.intValue();
                        } else if (count < 0) {
                            errorID = count;
                        }
                        rowValues[3] = count < 0 ? Integer.valueOf(0) : count;
                    }
                } else {
                    rowValues[3] = 0;
                }
            } else {
                rowValues[3] = this.manager.getCountMap().get(serviceName).intValue();
            }
            if (errorID != null) {
                rowValues[1] = errorID.intValue() == PSICQUICRestClient.ERROR_CANCEL.intValue() ? "Operation canceled" : (errorID.intValue() == PSICQUICRestClient.ERROR_TIMEOUT.intValue() ? "Timeout.  Try again later." : (errorID.intValue() == PSICQUICRestClient.ERROR_SEARCH_FAILED.intValue() ? "Server returns error.  Try again later." : "Unknown error.  Try again later."));
            } else if (this.manager.isActive(serviceName)) {
                rowValues[1] = ACTIVE;
                rowValues[0] = (Integer)rowValues[3] != 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            } else {
                rowValues[0] = false;
                rowValues[1] = INACTIVE;
            }
            model.addRow(rowValues);
        }
        this.resultTable = new JTable(model){

            @Override
            public String getToolTipText(MouseEvent e) {
                int row = this.convertRowIndexToModel(this.rowAtPoint(e.getPoint()));
                TableModel m = this.getModel();
                return "<html><strong>" + m.getValueAt(row, 2) + "</strong><br>" + m.getValueAt(row, 4) + "</html>";
            }
        };
        this.resultTable.setAutoCreateRowSorter(true);
        model.fireTableDataChanged();
        this.repaint();
    }

    private final String convertTags(String serviceName) {
        StringBuilder builder = new StringBuilder();
        List<String> tags = this.manager.getTagMap().get(serviceName);
        for (String tag : tags) {
            String psimiName = this.tagManager.toName(tag);
            if (psimiName != null) {
                builder.append(psimiName);
            } else {
                builder.append(tag);
            }
            builder.append(", ");
        }
        String nameString = builder.toString();
        return nameString.substring(0, nameString.length() - 2);
    }

    private void initComponents() {
        this.resultScrollPane = new JScrollPane();
        this.buttonPanel = new JPanel();
        this.selectAllButton = new JButton("Select All");
        this.selectNoneButton = new JButton("Select None");
        if (LookAndFeelUtil.isAquaLAF()) {
            this.selectAllButton.putClientProperty("JButton.buttonType", "gradient");
            this.selectAllButton.putClientProperty("JComponent.sizeVariant", "small");
            this.selectNoneButton.putClientProperty("JButton.buttonType", "gradient");
            this.selectNoneButton.putClientProperty("JComponent.sizeVariant", "small");
        }
        LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{this.selectAllButton, this.selectNoneButton});
        this.clusterResultCheckBox = new JCheckBox("Automatic Network Merge");
        this.clusterResultCheckBox.setSelected(false);
        this.resultScrollPane.setViewportView(this.resultTable);
        if (LookAndFeelUtil.isAquaLAF()) {
            this.buttonPanel.setOpaque(false);
        }
        this.selectNoneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceStatusPanel.this.clearButtonActionPerformed(evt);
            }
        });
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceStatusPanel.this.selectAllButtonActionPerformed(evt);
            }
        });
        this.clusterResultCheckBox.setToolTipText("Cluster all networks into single network");
        GroupLayout buttonPanelLayout = new GroupLayout(this.buttonPanel);
        this.buttonPanel.setLayout(buttonPanelLayout);
        buttonPanelLayout.setAutoCreateContainerGaps(false);
        buttonPanelLayout.setAutoCreateGaps(true);
        buttonPanelLayout.setHorizontalGroup(buttonPanelLayout.createSequentialGroup().addComponent(this.selectAllButton).addComponent(this.selectNoneButton).addContainerGap(20, Short.MAX_VALUE).addComponent(this.clusterResultCheckBox));
        buttonPanelLayout.setVerticalGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.selectAllButton, -2, -1, -2).addComponent(this.selectNoneButton, -2, -1, -2).addComponent(this.clusterResultCheckBox, -2, -1, -2));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resultScrollPane, -1, 300, Short.MAX_VALUE).addComponent(this.buttonPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.resultScrollPane, -1, 300, Short.MAX_VALUE).addComponent(this.buttonPanel, -2, -1, -2));
    }

    public void doImport() {
        boolean mergeNetwork = this.clusterResultCheckBox.isSelected();
        Set<String> targetSources = this.getSelected();
        HashSet<String> sourceURLs = new HashSet<String>();
        for (int i = 0; i < this.resultTable.getRowCount(); ++i) {
            String source = this.resultTable.getValueAt(i, 2).toString();
            if (((Number)this.resultTable.getValueAt(i, 3)).intValue() == 0 || !targetSources.contains(source)) continue;
            sourceURLs.add(this.manager.getActiveServices().get(source));
        }
        ImportNetworkFromPSICQUICTask networkTask = new ImportNetworkFromPSICQUICTask(this.query, this.client, sourceURLs, this.mode, this.vsBuilder, mergeNetwork, this.serviceRegistrar);
        DialogTaskManager taskManager = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
        taskManager.execute(new TaskIterator(new Task[]{networkTask}), (TaskObserver)this);
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.resultTable.getRowCount(); ++i) {
            this.resultTable.setValueAt(Boolean.FALSE, i, 0);
        }
    }

    private void selectAllButtonActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.resultTable.getRowCount(); ++i) {
            if (((Number)this.resultTable.getValueAt(i, 3)).intValue() == 0) {
                this.resultTable.setValueAt(Boolean.FALSE, i, 0);
                continue;
            }
            this.resultTable.setValueAt(Boolean.TRUE, i, 0);
        }
    }

    public void setSelected(Set<String> sources) {
        for (int i = 0; i < this.resultTable.getRowCount(); ++i) {
            String dbName = this.resultTable.getValueAt(i, 2).toString();
            if (sources.contains(dbName)) {
                this.resultTable.setValueAt(Boolean.TRUE, i, 0);
                continue;
            }
            this.resultTable.setValueAt(Boolean.FALSE, i, 0);
        }
    }

    public void sort() {
        RowSorter<? extends TableModel> sorter = this.resultTable.getRowSorter();
        if (sorter instanceof DefaultRowSorter) {
            ArrayList<RowSorter.SortKey> list = new ArrayList<RowSorter.SortKey>();
            list.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
            list.add(new RowSorter.SortKey(3, SortOrder.DESCENDING));
            sorter.setSortKeys(list);
            ((DefaultRowSorter)sorter).sort();
        }
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void taskFinished(ObservableTask task) {
        if (task.getResults(Object.class) instanceof Set) {
            this.results = (Set)task.getResults(Set.class);
        }
    }

    private final void showMergeUI(FinishStatus finishStatus) {
        if (finishStatus.getType() == FinishStatus.Type.SUCCEEDED) {
            StringBuilder builder = new StringBuilder();
            builder.append("<html><h3>Networks created from the following databases:</h3><ul>");
            CyNetworkViewManager netViewManager = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
            ArrayList<CyNetwork> networksWithoutView = new ArrayList<CyNetwork>();
            for (CyNetwork network : this.results) {
                String networkName = (String)network.getRow((CyIdentifiable)network).get("name", String.class);
                Integer edgeCount = network.getEdgeCount();
                builder.append("<li>" + networkName + ", " + edgeCount + " edges</li>");
                if (netViewManager.viewExists(network)) continue;
                networksWithoutView.add(network);
            }
            builder.append("</ul>");
            if (!networksWithoutView.isEmpty()) {
                boolean s = networksWithoutView.size() == 1;
                builder.append("<p><b>Note:</b> " + networksWithoutView.size() + (s ? " network" : " networks") + (s ? " was" : " were") + " imported whithout a view because " + (s ? " it is" : " they are") + " very large.</p>");
            }
            builder.append("<br><h3>What do you want to do now?</h3></html>");
            int selection = -1;
            Object[] options = networksWithoutView.isEmpty() ? new String[]{"Close", "Merge networks manually..."} : new String[]{"Close", "Create a view for large networks", "Merge networks manually..."};
            selection = JOptionPane.showOptionDialog(this, builder.toString(), "Import Finished", -1, -1, null, options, options[0]);
            if (selection == options.length - 1) {
                this.doNetworkMerge();
            } else if (selection == 1) {
                this.createMissingNetworkViews(networksWithoutView);
            }
        } else if (finishStatus.getType() == FinishStatus.Type.CANCELLED) {
            HashSet<String> sources = new HashSet<String>();
            StringBuilder builder = new StringBuilder();
            builder.append("<html><h2 style=\"color:red\">Import Canceled</h2><h3>Networks imported from the following databases (without view):</h3><ul>");
            for (CyNetwork network : this.results) {
                String networkName = (String)network.getRow((CyIdentifiable)network).get("name", String.class);
                Integer edgeCount = network.getEdgeCount();
                sources.add((String)network.getRow((CyIdentifiable)network).get("source", String.class));
                builder.append("<li>" + networkName + ", " + edgeCount + " edges</li>");
            }
            builder.append("<h3 style=\"color:red\">Import canceled for the following databases:</h3><ul style=\"color:red\">");
            for (int i = 0; i < this.resultTable.getRowCount(); ++i) {
                String dbName = this.resultTable.getValueAt(i, 2).toString();
                Integer count = ((Number)this.resultTable.getValueAt(i, 3)).intValue();
                Boolean isImport = (Boolean)this.resultTable.getValueAt(i, 0);
                if (sources.contains(dbName) || count == 0 || !isImport.booleanValue()) continue;
                builder.append("<li>" + dbName + "</li>");
            }
            int selection = JOptionPane.showConfirmDialog(this, builder.toString() + "</ul><br><h3>Do you want to merge these networks?</h3></html>", "Import Canceled", 0, 0, null);
            if (selection == 0) {
                this.doNetworkMerge();
            }
        } else {
            JOptionPane.showMessageDialog(this, "<html>Error: Please try again later.<br><br>" + finishStatus.getException().getLocalizedMessage() + "</html>", "Import Error", 0, null);
        }
        this.results = null;
    }

    private void createMissingNetworkViews(List<CyNetwork> networks) {
        DialogTaskManager taskManager = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
        CreateNetworkViewTaskFactory createViewTaskFactory = (CreateNetworkViewTaskFactory)this.serviceRegistrar.getService(CreateNetworkViewTaskFactory.class);
        taskManager.execute(createViewTaskFactory.createTaskIterator(networks));
    }

    private void doNetworkMerge() {
        try {
            CyAction mergeAction = (CyAction)this.serviceRegistrar.getService(CyAction.class, "(id=networkMergeAction)");
            mergeAction.actionPerformed(null);
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this, "<html>Network merge is currently unavailable.<br>Make sure Cytoscape has finished starting up and try again.</html>", "Network Merge Unavailable", 0);
        }
    }

    public void allFinished(final FinishStatus finishStatus) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SourceStatusPanel.this.showMergeUI(finishStatus);
            }
        });
    }

    private final class NumberCellRenderer
    extends DefaultTableCellRenderer {
        private NumberCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setForeground(UIManager.getColor(isSelected ? "Table.selectionForeground" : "Table.foreground"));
            this.setBackground(UIManager.getColor(isSelected ? "Table.selectionBackground" : "Table.background"));
            if (value == null || !(value instanceof Number)) {
                this.setEnabled(false);
            } else {
                Integer count;
                try {
                    count = Integer.valueOf(value.toString());
                }
                catch (Exception e) {
                    count = 0;
                }
                String serviceName = (String)table.getValueAt(row, 2);
                String statusString = (String)table.getValueAt(row, 1);
                this.setText(count.toString());
                this.setEnabled(table.isEnabled() && count > 0 && SourceStatusPanel.this.manager.isActive(serviceName) && statusString.equals(SourceStatusPanel.ACTIVE));
            }
            if (!this.isEnabled() && !isSelected) {
                this.setForeground(UIManager.getColor("Label.disabledForeground"));
            }
            return this;
        }
    }

    private final class StringCellRenderer
    extends DefaultTableCellRenderer {
        private StringCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setForeground(UIManager.getColor(isSelected ? "Table.selectionForeground" : "Table.foreground"));
            this.setBackground(UIManager.getColor(isSelected ? "Table.selectionBackground" : "Table.background"));
            if (value == null) {
                this.setEnabled(false);
                return this;
            }
            this.setText(value.toString());
            String serviceName = (String)table.getValueAt(row, 2);
            String statusString = (String)table.getValueAt(row, 1);
            int count = 0;
            try {
                count = ((Number)table.getValueAt(row, 3)).intValue();
            }
            catch (Exception e) {
                count = 0;
            }
            if (!SourceStatusPanel.this.manager.isActive(serviceName) || !statusString.equals(SourceStatusPanel.ACTIVE) || count == 0) {
                if (!isSelected) {
                    this.setForeground(UIManager.getColor("Label.disabledForeground"));
                }
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            if (column == 1 || column == 4) {
                this.setHorizontalAlignment(2);
            } else {
                this.setHorizontalAlignment(0);
            }
            if (!table.isEnabled()) {
                this.setEnabled(false);
            }
            return this;
        }
    }

    private final class BooleanCellRenderer
    implements TableCellRenderer {
        private final TableCellRenderer renderer;

        BooleanCellRenderer(TableCellRenderer renderer) {
            this.renderer = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                jc.setEnabled(true);
                jc.setForeground(UIManager.getColor(isSelected ? "Table.selectionForeground" : "Table.foreground"));
                jc.setBackground(UIManager.getColor(isSelected ? "Table.selectionBackground" : "Table.background"));
                String serviceName = (String)table.getValueAt(row, 2);
                int count = 0;
                try {
                    count = ((Number)table.getValueAt(row, 3)).intValue();
                }
                catch (Exception e) {
                    count = 0;
                }
                if (!table.isEnabled() || !SourceStatusPanel.this.manager.isActive(serviceName) || SourceStatusPanel.INACTIVE.equals(table.getValueAt(row, 1)) || count == 0) {
                    jc.setEnabled(false);
                }
            }
            return c;
        }
    }

    private final class StatusTableModel
    extends DefaultTableModel {
        private StatusTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            int count = (Integer)this.getValueAt(row, 3);
            String sourceName = this.getValueAt(row, 2).toString();
            return column == 0 && SourceStatusPanel.this.manager.isActive(sourceName) && count != 0;
        }

        @Override
        public Class<?> getColumnClass(int colIdx) {
            if (colIdx == 0) {
                return Boolean.class;
            }
            if (colIdx == 3) {
                return Integer.class;
            }
            return String.class;
        }
    }
}

