/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.webservice.psicquic.mapper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyRow;
import org.cytoscape.webservice.psicquic.mapper.CyNetworkBuilder;
import org.cytoscape.webservice.psicquic.miriam.Miriam;
import org.cytoscape.webservice.psicquic.miriam.Synonyms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psidev.psi.mi.tab.model.Confidence;
import psidev.psi.mi.tab.model.CrossReference;
import uk.ac.ebi.enfin.mi.cluster.EncoreInteraction;

public class InteractionClusterMapper {
    private static final Logger logger = LoggerFactory.getLogger(InteractionClusterMapper.class);
    private static final Pattern SPLITTER = Pattern.compile("\\|");
    private static final Pattern SPLITTER_NAME_SPACE = Pattern.compile("\\:");
    private static final Pattern SPLITTER_TYPE = Pattern.compile("\\(");
    private static final String SCHEMA_NAMESPACE = "org.cytoscape.webservice.psicquic.miriam";
    public static final String PREDICTED_GENE_NAME = "Human Readable Label";
    public static final String INTERACTOR_TYPE = "Interactor Type";
    static final String PUB_ID = "Publication ID";
    static final String PUB_DB = "Publication DB";
    static final String AUTHOR = "Author";
    public static final String INTERACTION_TYPE = "Interaction Type";
    public static final String PRIMARY_INTERACTION_TYPE = "Primary Interaction Type";
    static final String SOURCE_DB = "Source Database";
    static final String DETECTION_METHOD_ID = "Detection Method ID";
    public static final String DETECTION_METHOD_NAME = "Detection Method";
    private static final Pattern exact1Pattern = Pattern.compile("^[A-Z][A-Z][A-Z]\\d");
    private static final Pattern ncbiPattern = Pattern.compile("^[A-Za-z].+");
    private static final Pattern uniprotPattern = Pattern.compile("^[a-zA-Z]\\d.+");
    private static final String ENTREZ_GENE_ATTR_NAME = "entrez gene/locuslink";
    private static final String UNIPROT_ATTR_NAME = "uniprot";
    private static final String STRING_ATTR_NAME = "string";
    private final Set<String> namespaceSet = new HashSet<String>();
    private final Map<String, String> name2ns = new HashMap<String, String>();
    private final Map<String, String> synonym2ns = new HashMap<String, String>();
    public static final String TAXNOMY = "Taxonomy ID";
    static final String TAXNOMY_NAME = "Taxonomy Name";
    boolean isInitialized = false;
    private String currentGeneName = null;
    private boolean isSelfEdge = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureInitialized() {
        InteractionClusterMapper interactionClusterMapper = this;
        synchronized (interactionClusterMapper) {
            if (this.isInitialized) {
                return;
            }
            try {
                this.parseXml();
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not read resource file", ex);
            }
            this.isInitialized = true;
        }
    }

    public final String[] parseValues(String entry) {
        String[] values = new String[3];
        String[] parts = SPLITTER_NAME_SPACE.split(entry);
        values[0] = parts[0];
        if (parts.length >= 2) {
            String newVal;
            String others = entry.substring(values[0].length() + 1, entry.length());
            String[] valParts = SPLITTER_TYPE.split(others);
            values[1] = newVal = valParts[0].replaceAll("\"", "");
            if (valParts.length >= 2) {
                values[2] = valParts[1].substring(0, valParts[1].length() - 1).replaceAll("\"", "");
            }
        } else {
            return values;
        }
        return values;
    }

    private final Map<String, String> createNames(String nameText) {
        String[] names;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String name : names = SPLITTER.split(nameText)) {
            if (name.equals("-")) {
                this.isSelfEdge = true;
                continue;
            }
            String[] parts = this.parseValues(name);
            map.put(parts[0], parts[1]);
        }
        return map;
    }

    private Map<String, List<String>> createOtherNames(String nameText, String aliases) {
        this.currentGeneName = null;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        String[] names = SPLITTER.split(nameText);
        String[] others = SPLITTER.split(aliases);
        ArrayList<String[]> entries = new ArrayList<String[]>();
        entries.add(names);
        entries.add(others);
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            String[] entry;
            for (String name : entry = (String[])iterator.next()) {
                String[] parsed = this.parseValues(name);
                ArrayList<String> list = (ArrayList<String>)map.get(parsed[0]);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                if (parsed[1] == null) continue;
                list.add(parsed[1]);
                if (parsed[2] != null && parsed[2].equals("gene name")) {
                    this.currentGeneName = parsed[1];
                }
                map.put(parsed[0], list);
            }
        }
        return map;
    }

    public void mapNodeColumn(String[] entries, CyRow sourceRow, CyRow targetRow) {
        this.isSelfEdge = false;
        Map<String, String> accsSource = this.createNames(entries[0]);
        this.processNames(sourceRow, accsSource);
        Map<String, List<String>> otherSource = this.createOtherNames(entries[2], entries[4]);
        this.processOtherNames(sourceRow, otherSource);
        if (this.currentGeneName != null) {
            sourceRow.set(PREDICTED_GENE_NAME, (Object)this.currentGeneName);
        } else {
            this.guessHumanReadableName(sourceRow);
        }
        this.setSpecies(entries[9], sourceRow);
        if (!this.isSelfEdge) {
            Map<String, String> accsTarget = this.createNames(entries[1]);
            this.processNames(targetRow, accsTarget);
            Map<String, List<String>> otherTarget = this.createOtherNames(entries[3], entries[5]);
            this.processOtherNames(targetRow, otherTarget);
            if (this.currentGeneName != null) {
                targetRow.set(PREDICTED_GENE_NAME, (Object)this.currentGeneName);
            } else {
                this.guessHumanReadableName(targetRow);
            }
            this.setSpecies(entries[10], targetRow);
        }
        if (entries.length > 15) {
            this.addListColumn(sourceRow, entries[20], INTERACTOR_TYPE, String.class);
            this.addListColumn(targetRow, entries[21], INTERACTOR_TYPE, String.class);
            this.addListColumn(sourceRow, entries[22], "Xref", String.class);
            this.addListColumn(targetRow, entries[23], "Xref", String.class);
            this.addSimpleListColumn(sourceRow, entries[25], "Annotations");
            this.addSimpleListColumn(targetRow, entries[26], "Annotations");
            this.addSimpleListColumn(sourceRow, entries[36], "Features");
            this.addSimpleListColumn(targetRow, entries[38], "Features");
        }
    }

    private final void setSpecies(String speciesText, CyRow row) {
        String[] entries = SPLITTER.split(speciesText);
        String[] values = this.parseValues(entries[0]);
        if (values[1] != null) {
            row.set(TAXNOMY, (Object)values[1]);
        }
        if (values[2] != null) {
            row.set(TAXNOMY_NAME, (Object)values[2]);
        }
    }

    public void mapNodeColumn(EncoreInteraction interaction, CyRow sourceRow, CyRow targetRow) {
        Map accsSource = interaction.getInteractorAccsA();
        this.processNames(sourceRow, accsSource);
        Map otherSource = interaction.getOtherInteractorAccsA();
        this.processOtherNames(sourceRow, otherSource);
        Collection speciesSource = interaction.getOrganismsA();
        if (speciesSource.size() != 0) {
            CrossReference speciesSourceFirst = (CrossReference)speciesSource.iterator().next();
            this.processSpecies(sourceRow, speciesSourceFirst);
        }
        this.guessHumanReadableName(sourceRow);
        if (targetRow == null) {
            return;
        }
        Map accsTarget = interaction.getInteractorAccsB();
        this.processNames(targetRow, accsTarget);
        Map otherTarget = interaction.getOtherInteractorAccsB();
        this.processOtherNames(targetRow, otherTarget);
        Collection speciesTarget = interaction.getOrganismsB();
        if (speciesTarget.size() != 0) {
            CrossReference speciesTargetFirst = (CrossReference)speciesTarget.iterator().next();
            this.processSpecies(targetRow, speciesTargetFirst);
        }
        this.guessHumanReadableName(targetRow);
    }

    public void mapEdgeColumn(EncoreInteraction interaction, CyRow row) {
        Set exp = interaction.getExperimentToPubmed().keySet();
        row.set(DETECTION_METHOD_ID, new ArrayList(exp));
        List pubIDs = interaction.getPublicationIds();
        ArrayList<String> pubIdList = new ArrayList<String>();
        ArrayList<String> pubDBList = new ArrayList<String>();
        for (CrossReference pub : pubIDs) {
            pubIdList.add(pub.getIdentifier());
            pubDBList.add(pub.getDatabase());
        }
        if (!pubIdList.isEmpty()) {
            row.set(PUB_ID, pubIdList);
        }
        if (!pubDBList.isEmpty()) {
            row.set(PUB_DB, pubDBList);
        }
        row.set("interaction", (Object)interaction.getMappingIdDbNames());
        List scores = interaction.getConfidenceValues();
        for (Confidence c : scores) {
            String type = c.getType();
            String value = c.getValue();
            if (row.getTable().getColumn(type) == null) {
                row.getTable().createColumn(type, Double.class, true);
            }
            try {
                double doubleVal = Double.parseDouble(value);
                row.set(type, (Object)doubleVal);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private void processNames(CyRow row, Map<String, String> accs) {
        for (String originalDBName : accs.keySet()) {
            ArrayList currentList;
            String dbName = this.validateNamespace(originalDBName);
            if (row.getTable().getColumn(dbName) == null) {
                row.getTable().createListColumn(dbName, String.class, true);
            }
            if ((currentList = row.getList(dbName, String.class)) == null) {
                currentList = new ArrayList();
            }
            HashSet<String> nameSet = new HashSet<String>(currentList);
            String entry = accs.get(originalDBName);
            nameSet.add(entry);
            row.set(dbName, new ArrayList(nameSet));
        }
    }

    private void processOtherNames(CyRow row, Map<String, List<String>> accs) {
        for (String originalDBName : accs.keySet()) {
            ArrayList currentList;
            String dbName = this.validateNamespace(originalDBName);
            if (row.getTable().getColumn(dbName) == null) {
                row.getTable().createListColumn(dbName, String.class, false);
            }
            if ((currentList = row.getList(dbName, String.class)) == null) {
                currentList = new ArrayList();
            }
            HashSet<String> nameSet = new HashSet<String>(currentList);
            List<String> names = accs.get(originalDBName);
            nameSet.addAll(names);
            row.set(dbName, new ArrayList(nameSet));
        }
    }

    private void processSpecies(CyRow row, CrossReference ref) {
        if (ref != null) {
            String name = ref.getText();
            String speciesID = ref.getIdentifier();
            row.set(TAXNOMY, (Object)speciesID);
            row.set(TAXNOMY_NAME, (Object)name);
        }
    }

    private Miriam parseXml() throws IOException {
        URL xml = CyNetworkBuilder.class.getClassLoader().getResource("MiriamResources_all.xml");
        BufferedReader reader = new BufferedReader(new InputStreamReader(xml.openStream(), Charset.forName("UTF-8").newDecoder()));
        JAXBContext jc = null;
        try {
            jc = JAXBContext.newInstance((String)SCHEMA_NAMESPACE, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (JAXBException e) {
            logger.error("Could not create JAXBContext", (Throwable)e);
        }
        Unmarshaller u = null;
        try {
            u = jc.createUnmarshaller();
        }
        catch (JAXBException e) {
            logger.error("Could not create Unmarshaller", (Throwable)e);
        }
        Miriam result = null;
        try {
            result = (Miriam)u.unmarshal((Reader)reader);
        }
        catch (JAXBException e) {
            logger.error("unmarshal operation failed", (Throwable)e);
        }
        List<Miriam.Datatype> dataTypes = result.getDatatype();
        for (Miriam.Datatype type : dataTypes) {
            String ns = type.getNamespace().toLowerCase();
            this.namespaceSet.add(ns);
            this.name2ns.put(type.getName().toLowerCase(), ns);
            Synonyms sym = type.getSynonyms();
            if (sym == null) continue;
            for (String s : sym.getSynonym()) {
                this.synonym2ns.put(s.toLowerCase(), ns);
            }
        }
        return result;
    }

    private String validateNamespace(String columnName) {
        if (columnName.equals("entrezgene/locuslink")) {
            return ENTREZ_GENE_ATTR_NAME;
        }
        if (this.namespaceSet.contains(columnName.toLowerCase())) {
            return columnName;
        }
        String newName = this.name2ns.get(columnName.toLowerCase());
        if (newName != null) {
            return newName;
        }
        newName = this.synonym2ns.get(columnName.toLowerCase());
        if (newName != null) {
            return newName;
        }
        return columnName;
    }

    private void guessHumanReadableName(CyRow row) {
        List unknownList;
        List ncbiList;
        List stringList;
        boolean found = false;
        if (row.getTable().getColumn(STRING_ATTR_NAME) != null && (stringList = row.getList(STRING_ATTR_NAME, String.class)) != null) {
            found = this.findHumanReadableName(row, stringList, ncbiPattern, true);
        }
        if (found) {
            return;
        }
        if (row.getTable().getColumn(ENTREZ_GENE_ATTR_NAME) != null && (ncbiList = row.getList(ENTREZ_GENE_ATTR_NAME, String.class)) != null) {
            found = this.findHumanReadableName(row, ncbiList, ncbiPattern, true);
        }
        if (found) {
            return;
        }
        List uniprotList = null;
        if (row.getTable().getColumn(UNIPROT_ATTR_NAME) != null && (uniprotList = row.getList(UNIPROT_ATTR_NAME, String.class)) != null) {
            found = this.findHumanReadableName(row, uniprotList, exact1Pattern, true);
        }
        if (found) {
            return;
        }
        if (uniprotList != null) {
            found = this.findHumanReadableName(row, uniprotList, uniprotPattern, false);
        }
        if (found) {
            return;
        }
        if (row.getTable().getColumn("unknown") != null && (unknownList = row.getList("unknown", String.class)) != null) {
            found = this.findHumanReadableName(row, unknownList, uniprotPattern, false);
        }
        if (found) {
            return;
        }
        if (!found) {
            row.set(PREDICTED_GENE_NAME, (Object)((String)row.get("name", String.class)));
        }
    }

    private boolean findHumanReadableName(CyRow row, List<String> attrList, Pattern pattern, boolean exist) {
        String candidateString = null;
        for (String geneID : attrList) {
            if (pattern.matcher(geneID).find() != exist) continue;
            candidateString = geneID;
            break;
        }
        if (candidateString != null) {
            if (candidateString.contains("_")) {
                String firstPart = candidateString.split("_")[0];
                for (String candidate : attrList) {
                    if (!candidate.equalsIgnoreCase(firstPart)) continue;
                    candidateString = firstPart;
                    break;
                }
            }
            row.set(PREDICTED_GENE_NAME, (Object)candidateString);
            return true;
        }
        return false;
    }

    public void mapEdgeColumn(String[] entries, CyRow row, CyEdge edge, String sourceName, String targetName) {
        String[] scores;
        String[] pubID;
        String[] detectionMethods = SPLITTER.split(entries[6]);
        ArrayList<String> methods = new ArrayList<String>();
        ArrayList<String> methodID = new ArrayList<String>();
        for (String entry : detectionMethods) {
            String[] methodContents = this.parseValues(entry);
            if (methodContents[1] != null) {
                methodID.add(methodContents[1]);
            }
            if (methodContents[2] == null) continue;
            methods.add(methodContents[2]);
        }
        if (!methods.isEmpty()) {
            row.set(DETECTION_METHOD_NAME, methods);
        }
        if (!methodID.isEmpty()) {
            row.set(DETECTION_METHOD_ID, methodID);
        }
        String[] authorsParts = SPLITTER.split(entries[7]);
        ArrayList<String> authors = new ArrayList<String>();
        for (String string : authorsParts) {
            String updatedAuthor = string.replaceAll("\"", "");
            authors.add(updatedAuthor);
        }
        if (!authors.isEmpty()) {
            row.set(AUTHOR, authors);
        }
        ArrayList<String> pubIdList = new ArrayList<String>();
        ArrayList<String> pubDBList = new ArrayList<String>();
        for (String string : pubID = SPLITTER.split(entries[8])) {
            String id = this.parseValues(string)[1];
            String db = this.parseValues(string)[0];
            if (id == null || db == null) continue;
            pubDBList.add(db);
            pubIdList.add(id);
        }
        if (!pubIdList.isEmpty()) {
            row.set(PUB_ID, pubIdList);
        }
        if (!pubDBList.isEmpty()) {
            row.set(PUB_DB, pubDBList);
        }
        String[] stringArray = SPLITTER.split(entries[12]);
        row.set(SOURCE_DB, (Object)this.parseValues(stringArray[0])[0]);
        String[] typeParts = SPLITTER.split(entries[11]);
        ArrayList<String> types = new ArrayList<String>();
        for (String entry : typeParts) {
            String type = this.parseValues(entry)[2];
            if (type == null) continue;
            types.add(type);
        }
        if (!types.isEmpty()) {
            row.set(INTERACTION_TYPE, types);
            row.set(PRIMARY_INTERACTION_TYPE, (Object)((String)types.get(0)));
        }
        String[] stringArray2 = SPLITTER.split(entries[13]);
        String interaction = this.parseValues(stringArray2[0])[1];
        row.set("interaction", (Object)interaction);
        row.set("name", (Object)(sourceName + " (" + interaction + ") " + targetName));
        for (String score : scores = SPLITTER.split(entries[14])) {
            String[] scoreArray = this.parseValues(score);
            String scoreType = "Confidence-Score-" + scoreArray[0];
            String value = scoreArray[1];
            if (value == null) continue;
            if (row.getTable().getColumn(scoreType) == null) {
                row.getTable().createColumn(scoreType, Double.class, true);
            }
            try {
                double doubleVal = Double.parseDouble(value);
                row.set(scoreType, (Object)doubleVal);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (entries.length > 15) {
            this.addListColumn(row, entries[16], "Source Biological Role", String.class);
            this.addListColumn(row, entries[17], "Target Biological Role", String.class);
            this.addListColumn(row, entries[18], "Source Experimental Role", String.class);
            this.addListColumn(row, entries[19], "Target Experimental Role", String.class);
            this.addListColumn(row, entries[40], "Source Participant Detection Method", String.class);
            this.addListColumn(row, entries[41], "Target Participant Detection Method", String.class);
            this.addListColumn(row, entries[15], "Complex Expansion", String.class);
            this.addListColumn(row, entries[24], "Xref", String.class);
            this.addSimpleListColumn(row, entries[27], "Annotation");
            this.addListColumn(row, entries[28], "Host Organism Taxonomy", String.class);
            this.addSimpleListColumn(row, entries[29], "Parameters");
            this.addSingleColumn(row, entries[30], "Creation Date", String.class);
            this.addSingleColumn(row, entries[31], "Update Date", String.class);
            this.addSingleColumn(row, entries[35], "Negative", Boolean.class);
        }
    }

    private final void addListColumn(CyRow row, String val, String columnName, Class<?> listType) {
        if (val == null || val.equals("-")) {
            return;
        }
        String newColName = null;
        if (columnName != null) {
            if (row.getTable().getColumn(columnName) == null) {
                row.getTable().createListColumn(columnName, listType, false);
                row.getTable().createListColumn(columnName + " ID", String.class, false);
            }
            newColName = columnName;
        }
        String[] entries = SPLITTER.split(val);
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> descriptions = new ArrayList<String>();
        for (String entry : entries) {
            String[] contents = this.parseValues(entry);
            if (newColName == null) {
                if (row.getTable().getColumn(contents[0]) == null) {
                    row.getTable().createListColumn(contents[0], listType, false);
                    row.getTable().createListColumn(contents[0] + " ID", String.class, false);
                }
                newColName = contents[0];
            }
            if (contents[1] != null) {
                ids.add(contents[1]);
            }
            if (contents[2] == null) continue;
            descriptions.add(contents[2]);
        }
        if (!ids.isEmpty()) {
            row.set(newColName + " ID", ids);
        }
        if (!descriptions.isEmpty()) {
            row.set(newColName, descriptions);
        }
    }

    private final void addSimpleListColumn(CyRow row, String val, String columnName) {
        if (val == null || val.equals("-")) {
            return;
        }
        if (row.getTable().getColumn(columnName) == null) {
            row.getTable().createListColumn(columnName, String.class, false);
        }
        String[] entries = SPLITTER.split(val);
        ArrayList<String> ids = new ArrayList<String>();
        for (String entry : entries) {
            if (entry == null) continue;
            String newEntry = entry.replaceAll("\"", "");
            ids.add(newEntry);
        }
        if (!ids.isEmpty()) {
            row.set(columnName, ids);
        }
    }

    private final void addSingleColumn(CyRow row, String val, String columnName, Class<?> dataType) {
        if (val == null || val.equals("-")) {
            return;
        }
        if (row.getTable().getColumn(columnName) == null) {
            row.getTable().createColumn(columnName, dataType, false);
        }
        Object newValue = val;
        if (dataType == Boolean.class) {
            newValue = Boolean.parseBoolean(val);
        }
        row.set(columnName, newValue);
    }
}

