/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.webservice.psicquic;

import java.awt.Color;
import java.awt.Font;
import java.util.Set;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.LineTypeVisualProperty;
import org.cytoscape.view.presentation.property.NodeShapeVisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;

public class PSIMI25VisualStyleBuilder {
    public static final String DEF_VS_NAME = "PSIMI 25 Style";
    private static final Color NODE_COLOR = Color.WHITE;
    private static final Color NODE_BORDER_COLOR = new Color(180, 180, 180);
    private static final Color NODE_LABEL_COLOR = new Color(50, 50, 50);
    private static final Color EDGE_COLOR = new Color(180, 180, 180);
    private static final Color EDGE_LABEL_COLOR = new Color(50, 50, 50);
    private static final Color EDGE_CROSS_COLOR = new Color(28, 134, 238);
    private static Font NODE_LABEL_FONT = new Font("HelveticaNeue-UltraLight", 0, 10);
    private static final Color COLOR_HUMAN;
    private static final Color COLOR_MOUSE;
    private static final Color COLOR_RAT;
    private static final Color COLOR_FLY;
    private static final Color COLOR_WORM;
    private static final Color COLOR_YEAST;
    private static final Color COLOR_ECOLI;
    private static final Color COLOR_ARABIDOPSIS;
    private static final Color COLOR_DNA;
    private static final Color COLOR_MOLECULE;
    private final CyServiceRegistrar serviceRegistrar;

    public PSIMI25VisualStyleBuilder(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public VisualStyle getVisualStyle() {
        VisualStyleFactory vsFactory = (VisualStyleFactory)this.serviceRegistrar.getService(VisualStyleFactory.class);
        VisualMappingFunctionFactory pmFactory = (VisualMappingFunctionFactory)this.serviceRegistrar.getService(VisualMappingFunctionFactory.class, "(mapping.type=passthrough)");
        VisualMappingFunctionFactory dmFactory = (VisualMappingFunctionFactory)this.serviceRegistrar.getService(VisualMappingFunctionFactory.class, "(mapping.type=discrete)");
        VisualStyle defStyle = vsFactory.createVisualStyle(DEF_VS_NAME);
        Set deps = defStyle.getAllVisualPropertyDependencies();
        for (VisualPropertyDependency dep : deps) {
            dep.setDependency(false);
        }
        Color backGroundColor = Color.white;
        defStyle.setDefaultValue(BasicVisualLexicon.NETWORK_BACKGROUND_PAINT, (Object)backGroundColor);
        PassthroughMapping labelPassthrough = (PassthroughMapping)pmFactory.createVisualMappingFunction("Human Readable Label", String.class, BasicVisualLexicon.NODE_LABEL);
        defStyle.addVisualMappingFunction((VisualMappingFunction)labelPassthrough);
        PassthroughMapping edgeLabelPassthrough = (PassthroughMapping)pmFactory.createVisualMappingFunction("Detection Method", String.class, BasicVisualLexicon.EDGE_LABEL);
        defStyle.addVisualMappingFunction((VisualMappingFunction)edgeLabelPassthrough);
        PassthroughMapping nodeTooltipPassthrough = (PassthroughMapping)pmFactory.createVisualMappingFunction("Interactor Type", String.class, BasicVisualLexicon.NODE_TOOLTIP);
        defStyle.addVisualMappingFunction((VisualMappingFunction)nodeTooltipPassthrough);
        PassthroughMapping edgeTooltipPassthrough = (PassthroughMapping)pmFactory.createVisualMappingFunction("Primary Interaction Type", String.class, BasicVisualLexicon.EDGE_TOOLTIP);
        defStyle.addVisualMappingFunction((VisualMappingFunction)edgeTooltipPassthrough);
        defStyle.setDefaultValue(BasicVisualLexicon.NODE_SHAPE, (Object)NodeShapeVisualProperty.ROUND_RECTANGLE);
        defStyle.setDefaultValue(BasicVisualLexicon.NODE_BORDER_PAINT, (Object)NODE_BORDER_COLOR);
        defStyle.setDefaultValue(BasicVisualLexicon.NODE_FILL_COLOR, (Object)NODE_COLOR);
        defStyle.setDefaultValue(BasicVisualLexicon.NODE_LABEL_COLOR, (Object)NODE_LABEL_COLOR);
        defStyle.setDefaultValue(BasicVisualLexicon.NODE_LABEL_FONT_FACE, (Object)NODE_LABEL_FONT);
        defStyle.setDefaultValue(BasicVisualLexicon.NODE_LABEL_TRANSPARENCY, (Object)230);
        defStyle.setDefaultValue(BasicVisualLexicon.NODE_BORDER_WIDTH, (Object)2.0);
        defStyle.setDefaultValue(BasicVisualLexicon.NODE_BORDER_TRANSPARENCY, (Object)240);
        defStyle.setDefaultValue(BasicVisualLexicon.NODE_WIDTH, (Object)65.0);
        defStyle.setDefaultValue(BasicVisualLexicon.NODE_HEIGHT, (Object)24.0);
        defStyle.setDefaultValue(BasicVisualLexicon.NODE_TRANSPARENCY, (Object)220);
        defStyle.setDefaultValue(BasicVisualLexicon.EDGE_TRANSPARENCY, (Object)180);
        defStyle.setDefaultValue(BasicVisualLexicon.EDGE_WIDTH, (Object)2.0);
        defStyle.setDefaultValue(BasicVisualLexicon.EDGE_PAINT, (Object)EDGE_COLOR);
        defStyle.setDefaultValue(BasicVisualLexicon.EDGE_LABEL_TRANSPARENCY, (Object)80);
        defStyle.setDefaultValue(BasicVisualLexicon.EDGE_LABEL_FONT_SIZE, (Object)8);
        defStyle.setDefaultValue(BasicVisualLexicon.EDGE_LABEL_COLOR, (Object)EDGE_LABEL_COLOR);
        DiscreteMapping nodeColorMapping = (DiscreteMapping)dmFactory.createVisualMappingFunction("Taxonomy ID", String.class, BasicVisualLexicon.NODE_FILL_COLOR);
        nodeColorMapping.putMapValue((Object)"9606", (Object)COLOR_HUMAN);
        nodeColorMapping.putMapValue((Object)"10090", (Object)COLOR_MOUSE);
        nodeColorMapping.putMapValue((Object)"10116", (Object)COLOR_RAT);
        nodeColorMapping.putMapValue((Object)"7227", (Object)COLOR_FLY);
        nodeColorMapping.putMapValue((Object)"10116", (Object)COLOR_WORM);
        nodeColorMapping.putMapValue((Object)"4932", (Object)COLOR_YEAST);
        nodeColorMapping.putMapValue((Object)"83333", (Object)COLOR_ECOLI);
        nodeColorMapping.putMapValue((Object)"3702", (Object)COLOR_ARABIDOPSIS);
        defStyle.addVisualMappingFunction((VisualMappingFunction)nodeColorMapping);
        DiscreteMapping nodeWidthMapping = (DiscreteMapping)dmFactory.createVisualMappingFunction("Interactor Type", String.class, BasicVisualLexicon.NODE_WIDTH);
        nodeWidthMapping.putMapValue((Object)"protein", (Object)65.0);
        nodeWidthMapping.putMapValue((Object)"gene", (Object)30.0);
        nodeWidthMapping.putMapValue((Object)"small molecule", (Object)20.0);
        nodeWidthMapping.putMapValue((Object)"nucleic acid", (Object)10.0);
        nodeWidthMapping.putMapValue((Object)"deoxyribonucleic acid", (Object)10.0);
        nodeWidthMapping.putMapValue((Object)"double stranded deoxyribonucleic acid", (Object)10.0);
        nodeWidthMapping.putMapValue((Object)"single stranded deoxyribonucleic acid", (Object)10.0);
        nodeWidthMapping.putMapValue((Object)"ribonucleic acid", (Object)10.0);
        nodeWidthMapping.putMapValue((Object)"complex", (Object)150.0);
        nodeWidthMapping.putMapValue((Object)"protein complex", (Object)150.0);
        nodeWidthMapping.putMapValue((Object)"complex composition", (Object)150.0);
        nodeWidthMapping.putMapValue((Object)"protein dna complex", (Object)150.0);
        nodeWidthMapping.putMapValue((Object)"ribonucleoprotein complex", (Object)150.0);
        defStyle.addVisualMappingFunction((VisualMappingFunction)nodeWidthMapping);
        DiscreteMapping nodeHeightMapping = (DiscreteMapping)dmFactory.createVisualMappingFunction("Interactor Type", String.class, BasicVisualLexicon.NODE_HEIGHT);
        nodeHeightMapping.putMapValue((Object)"protein", (Object)24.0);
        nodeHeightMapping.putMapValue((Object)"gene", (Object)30.0);
        nodeHeightMapping.putMapValue((Object)"small molecule", (Object)20.0);
        nodeHeightMapping.putMapValue((Object)"nucleic acid", (Object)60.0);
        nodeHeightMapping.putMapValue((Object)"deoxyribonucleic acid", (Object)60.0);
        nodeHeightMapping.putMapValue((Object)"double stranded deoxyribonucleic acid", (Object)60.0);
        nodeHeightMapping.putMapValue((Object)"single stranded deoxyribonucleic acid", (Object)60.0);
        nodeHeightMapping.putMapValue((Object)"ribonucleic acid", (Object)60.0);
        nodeHeightMapping.putMapValue((Object)"complex", (Object)150.0);
        nodeHeightMapping.putMapValue((Object)"protein complex", (Object)150.0);
        nodeHeightMapping.putMapValue((Object)"complex composition", (Object)150.0);
        nodeHeightMapping.putMapValue((Object)"protein dna complex", (Object)150.0);
        nodeHeightMapping.putMapValue((Object)"ribonucleoprotein complex", (Object)150.0);
        defStyle.addVisualMappingFunction((VisualMappingFunction)nodeHeightMapping);
        DiscreteMapping nodeShapeMapping = (DiscreteMapping)dmFactory.createVisualMappingFunction("Interactor Type", String.class, BasicVisualLexicon.NODE_SHAPE);
        nodeShapeMapping.putMapValue((Object)"protein", (Object)NodeShapeVisualProperty.ROUND_RECTANGLE);
        nodeShapeMapping.putMapValue((Object)"gene", (Object)NodeShapeVisualProperty.DIAMOND);
        nodeShapeMapping.putMapValue((Object)"small molecule", (Object)NodeShapeVisualProperty.ELLIPSE);
        nodeShapeMapping.putMapValue((Object)"nucleic acid", (Object)NodeShapeVisualProperty.PARALLELOGRAM);
        nodeShapeMapping.putMapValue((Object)"deoxyribonucleic acid", (Object)NodeShapeVisualProperty.PARALLELOGRAM);
        nodeShapeMapping.putMapValue((Object)"double stranded deoxyribonucleic acid", (Object)NodeShapeVisualProperty.PARALLELOGRAM);
        nodeShapeMapping.putMapValue((Object)"single stranded deoxyribonucleic acid", (Object)NodeShapeVisualProperty.PARALLELOGRAM);
        nodeShapeMapping.putMapValue((Object)"ribonucleic acid", (Object)NodeShapeVisualProperty.PARALLELOGRAM);
        nodeShapeMapping.putMapValue((Object)"complex", (Object)NodeShapeVisualProperty.OCTAGON);
        nodeShapeMapping.putMapValue((Object)"protein complex", (Object)NodeShapeVisualProperty.OCTAGON);
        nodeShapeMapping.putMapValue((Object)"complex composition", (Object)NodeShapeVisualProperty.OCTAGON);
        nodeShapeMapping.putMapValue((Object)"protein dna complex", (Object)NodeShapeVisualProperty.OCTAGON);
        nodeShapeMapping.putMapValue((Object)"ribonucleoprotein complex", (Object)NodeShapeVisualProperty.OCTAGON);
        defStyle.addVisualMappingFunction((VisualMappingFunction)nodeShapeMapping);
        DiscreteMapping nodeBorderColorMapping = (DiscreteMapping)dmFactory.createVisualMappingFunction("Interactor Type", String.class, BasicVisualLexicon.NODE_BORDER_PAINT);
        nodeBorderColorMapping.putMapValue((Object)"small molecule", (Object)COLOR_MOLECULE);
        nodeBorderColorMapping.putMapValue((Object)"gene", (Object)Color.DARK_GRAY);
        defStyle.addVisualMappingFunction((VisualMappingFunction)nodeBorderColorMapping);
        DiscreteMapping nodeBorderWidthMapping = (DiscreteMapping)dmFactory.createVisualMappingFunction("Interactor Type", String.class, BasicVisualLexicon.NODE_BORDER_WIDTH);
        nodeBorderWidthMapping.putMapValue((Object)"small molecule", (Object)10.0);
        nodeBorderWidthMapping.putMapValue((Object)"gene", (Object)4.0);
        defStyle.addVisualMappingFunction((VisualMappingFunction)nodeBorderWidthMapping);
        DiscreteMapping edgeWidthMapping = (DiscreteMapping)dmFactory.createVisualMappingFunction("Primary Interaction Type", String.class, BasicVisualLexicon.EDGE_WIDTH);
        edgeWidthMapping.putMapValue((Object)"colocalization", (Object)3.0);
        edgeWidthMapping.putMapValue((Object)"predicted interaction", (Object)1.0);
        defStyle.addVisualMappingFunction((VisualMappingFunction)edgeWidthMapping);
        DiscreteMapping edgeLineTypeMapping = (DiscreteMapping)dmFactory.createVisualMappingFunction("Primary Interaction Type", String.class, BasicVisualLexicon.EDGE_LINE_TYPE);
        edgeLineTypeMapping.putMapValue((Object)"colocalization", (Object)LineTypeVisualProperty.LONG_DASH);
        edgeLineTypeMapping.putMapValue((Object)"asynthetic", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"enhancement", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"epistasis", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"genetic interaction", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"maximal epistasis", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"minimal epistasis", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"mutual enhancement", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"mutual over-suppression", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"mutual suppression", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"mutual suppression (complete)", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"mutual suppression (partial)", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"negative genetic interaction", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"neutral epistasis", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"neutral genetic interaction", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"noninteractive", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"opposing epistasis", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"opposing epistasis", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"over-suppression", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"over-suppression-enhancement", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"phenotype bias", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"positive epistasis", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"positive genetic interaction", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"qualitative epistasis", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"quantitative epistasis", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"suppression", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"suppression (complete)", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"suppression (partial)", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"suppression-enhancement", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"synthetic", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"unilateral enhancement", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"unilateral over-suppression", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"unilateral suppression", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"unilateral suppression (complete)", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"unilateral suppression (partial)", (Object)LineTypeVisualProperty.DOT);
        edgeLineTypeMapping.putMapValue((Object)"predicted interaction", (Object)LineTypeVisualProperty.LONG_DASH);
        defStyle.addVisualMappingFunction((VisualMappingFunction)edgeLineTypeMapping);
        return defStyle;
    }

    static {
        if (NODE_LABEL_FONT == null) {
            NODE_LABEL_FONT = new Font("SansSerif", 0, 10);
        }
        COLOR_HUMAN = new Color(67, 110, 238);
        COLOR_MOUSE = new Color(238, 118, 33);
        COLOR_RAT = new Color(255, 165, 0);
        COLOR_FLY = new Color(147, 112, 219);
        COLOR_WORM = new Color(107, 142, 35);
        COLOR_YEAST = new Color(156, 156, 156);
        COLOR_ECOLI = new Color(176, 226, 255);
        COLOR_ARABIDOPSIS = new Color(255, 245, 238);
        COLOR_DNA = Color.DARK_GRAY;
        COLOR_MOLECULE = Color.DARK_GRAY;
    }
}

