/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.webservice.psicquic;

import java.util.Properties;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.NodeViewTaskFactory;
import org.cytoscape.webservice.psicquic.PSICQUICWebServiceClient;
import org.cytoscape.webservice.psicquic.PSIMI25VisualStyleBuilder;
import org.cytoscape.webservice.psicquic.mapper.CyNetworkBuilder;
import org.cytoscape.webservice.psicquic.task.ExpandNodeContextMenuFactory;
import org.cytoscape.webservice.psicquic.task.PSICQUICSearchFactory;
import org.cytoscape.webservice.psicquic.ui.PSIMITagManager;
import org.osgi.framework.BundleContext;

public class CyActivator
extends AbstractCyActivator {
    private static final String WEB_SERVICE_URL = "http://www.ebi.ac.uk/Tools/webservices/psicquic/registry/registry";
    private static final String MIQL_URL = "http://psicquic.github.io/MiqlDefinition.html";
    private static final String REGISTRY_URL = "http://www.ebi.ac.uk/Tools/webservices/psicquic/registry/registry?action=STATUS";
    private static final String CLIENT_DISCRIPTION = "<p>This is a web service client for <a href=\"" + PSICQUICSearchFactory.WEBSITE_URL + "\">PSICQUIC</a>-compliant databases.</p><ul><li><a href=\"http://psicquic.github.io/MiqlDefinition.html\">Query language (MIQL) Syntax</a></li><li><a href=\"http://www.ebi.ac.uk/Tools/webservices/psicquic/registry/registry?action=STATUS\">List of Supported Databases</a></li></ul>";

    public void start(BundleContext bc) {
        CyServiceRegistrar serviceRegistrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        PSIMITagManager tagManager = new PSIMITagManager();
        PSIMI25VisualStyleBuilder vsBuilder = new PSIMI25VisualStyleBuilder(serviceRegistrar);
        CyNetworkBuilder builder = new CyNetworkBuilder(serviceRegistrar);
        PSICQUICWebServiceClient psicquicClient = new PSICQUICWebServiceClient(WEB_SERVICE_URL, "Universal Interaction Database Client", CLIENT_DISCRIPTION, builder, vsBuilder, tagManager, serviceRegistrar);
        Properties props = new Properties();
        props.put("id", "PSICQUICWebServiceClient");
        this.registerAllServices(bc, (Object)psicquicClient, props);
        Object factory = new ExpandNodeContextMenuFactory(psicquicClient.getRestClient(), psicquicClient.getRegistryManager(), builder, serviceRegistrar);
        Properties props2 = new Properties();
        props2.setProperty("preferredTaskManager", "menu");
        props2.setProperty("preferredMenu", "Apps[1]");
        props2.setProperty("menuGravity", "10.0");
        props2.setProperty("title", "Extend Network by public interaction database...");
        this.registerService(bc, factory, NodeViewTaskFactory.class, props2);
        factory = new PSICQUICSearchFactory(psicquicClient, vsBuilder, tagManager, serviceRegistrar);
        this.registerAllServices(bc, factory);
    }
}

