/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.work;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cytoscape.application.events.SetCurrentNetworkEvent;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.filter.internal.work.ValidationViewListener;
import org.cytoscape.filter.model.TransformerListener;
import org.cytoscape.filter.model.ValidatableTransformer;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;

public class ValidationManager
implements SetCurrentNetworkListener {
    private CyNetwork network;
    private Map<ValidatableTransformer<CyNetwork, CyIdentifiable>, ValidationViewListener> listeners = new HashMap<ValidatableTransformer<CyNetwork, CyIdentifiable>, ValidationViewListener>();

    public void handleEvent(SetCurrentNetworkEvent e) {
        this.network = e.getNetwork();
        this.runValidation();
    }

    public void register(ValidatableTransformer<CyNetwork, CyIdentifiable> transformer, ValidationViewListener listener) {
        ValidationViewListener prev = this.listeners.put(transformer, listener);
        if (prev == null) {
            transformer.addListener((TransformerListener)new TransformerValidationListener(transformer));
        }
    }

    public void unregister(ValidatableTransformer<CyNetwork, CyIdentifiable> transformer) {
        ValidationViewListener prev = this.listeners.remove(transformer);
        if (prev != null) {
            transformer.removeListener((TransformerListener)new TransformerValidationListener(transformer));
        }
    }

    public void runValidation() {
        this.listeners.keySet().forEach(this::runValidation);
    }

    private void runValidation(ValidatableTransformer<CyNetwork, CyIdentifiable> transformer) {
        ValidationViewListener listener = this.listeners.get(transformer);
        List warnings = transformer.validate((Object)this.network);
        if (listener != null) {
            listener.handleValidated(new ValidationViewListener.ValidationEvent(warnings));
        }
    }

    public String toString() {
        String prefix = "ValidationManager (" + this.listeners.size() + ") {";
        return this.listeners.keySet().stream().map(t -> t.getClass().getSimpleName()).collect(Collectors.joining(",", prefix, "}"));
    }

    private class TransformerValidationListener
    implements TransformerListener {
        private ValidatableTransformer<CyNetwork, CyIdentifiable> transformer;

        public TransformerValidationListener(ValidatableTransformer<CyNetwork, CyIdentifiable> transformer) {
            this.transformer = transformer;
        }

        public void handleSettingsChanged() {
            ValidationManager.this.runValidation(this.transformer);
        }

        public int hashCode() {
            return this.transformer.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof TransformerValidationListener) {
                return ((TransformerValidationListener)obj).transformer.equals(this.transformer);
            }
            return false;
        }
    }
}

