/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.work;

import org.cytoscape.filter.internal.work.ProgressMonitor;

public class DiscreteProgressMonitor
implements ProgressMonitor {
    private final ProgressMonitor wrapped;
    private double low;
    private double high;
    private int totalWork = 100;
    private int currentWork = 0;

    public DiscreteProgressMonitor(ProgressMonitor wrapped, double low, double high) {
        this.wrapped = wrapped;
        this.low = low;
        this.high = high;
    }

    public DiscreteProgressMonitor(ProgressMonitor wrapped) {
        this(wrapped, 0.0, 1.0);
    }

    private double map(double in, double inStart, double inEnd, double outStart, double outEnd) {
        double slope = (outEnd - outStart) / (inEnd - inStart);
        return outStart + slope * (in - inStart);
    }

    @Override
    public void setProgress(double progress) {
        double mappedProgress = this.map(progress, 0.0, 1.0, this.low, this.high);
        this.wrapped.setProgress(mappedProgress);
    }

    public void setTotalWork(int totalWork) {
        this.totalWork = totalWork;
    }

    public void setWork(int currentWork) {
        this.currentWork = currentWork;
        double mappedProgress = this.map(currentWork, 0.0, this.totalWork, 0.0, 1.0);
        this.setProgress(mappedProgress);
    }

    public void addWork(int workToAdd) {
        this.setWork(this.currentWork + workToAdd);
    }

    @Override
    public void cancel() {
        this.wrapped.cancel();
    }

    @Override
    public boolean isCancelled() {
        return this.wrapped.isCancelled();
    }

    @Override
    public void setStatusMessage(String message) {
        this.wrapped.setStatusMessage(message);
    }

    public String toString() {
        return "DiscreteProgressMonitor: (" + this.currentWork + "/" + this.totalWork + ")";
    }
}

