/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.work;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.cytoscape.filter.internal.work.TransformerBuffer;

public class DefaultBuffer<C, E>
implements TransformerBuffer<C, E> {
    private Set<E> elements;
    private Class<C> contextType;
    private Class<E> elementType;

    public DefaultBuffer(Class<C> contextType, Class<E> elementType, int initialCapacity, int concurrencyLevel) {
        this.contextType = contextType;
        this.elementType = elementType;
        this.elements = concurrencyLevel > 1 ? Collections.newSetFromMap(new ConcurrentHashMap(initialCapacity, 0.75f, concurrencyLevel)) : Collections.newSetFromMap(new IdentityHashMap(initialCapacity));
    }

    public List<E> getElementList(C context) {
        return new ArrayList<E>(this.elements);
    }

    public Class<C> getContextType() {
        return this.contextType;
    }

    public Class<E> getElementType() {
        return this.elementType;
    }

    public int getElementCount(C context) {
        return this.elements.size();
    }

    public void collect(E element) {
        this.elements.add(element);
    }

    @Override
    public void clear() {
        this.elements.clear();
    }
}

