/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.view;

import java.awt.Component;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cytoscape.filter.internal.filters.composite.CompositeTransformerPanel;
import org.cytoscape.filter.internal.view.AbstractPanel;
import org.cytoscape.filter.internal.view.DynamicComboBoxModel;
import org.cytoscape.filter.internal.view.FilterElement;
import org.cytoscape.filter.internal.view.TransformerElement;
import org.cytoscape.filter.internal.view.TransformerElementViewModel;
import org.cytoscape.filter.internal.view.TransformerPanelController;
import org.cytoscape.filter.internal.view.ViewUtil;
import org.cytoscape.filter.internal.work.TransformerWorker;
import org.cytoscape.filter.model.Transformer;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class TransformerPanel
extends AbstractPanel<TransformerElement, TransformerPanelController> {
    private CompositeTransformerPanel root;
    private JComboBox<FilterElement> startWithComboBox;

    public TransformerPanel(TransformerPanelController controller, TransformerWorker worker, CyServiceRegistrar serviceRegistrar) {
        super(controller, serviceRegistrar);
        this.setOpaque(!LookAndFeelUtil.isAquaLAF());
        worker.setView(this);
        JPanel applyPanel = this.createApplyPanel(false);
        Component editPanel = this.createEditPanel();
        JLabel startWithLabel = new JLabel("Start with:");
        this.startWithComboBox = new JComboBox(controller.getStartWithComboBoxModel());
        this.startWithComboBox.setRenderer(ViewUtil.createElipsisRenderer(50));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.namedElementComboBox, -1, -1, Short.MAX_VALUE).addComponent(this.optionsButton, -2, 64, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(startWithLabel, -2, -1, -2).addComponent(this.startWithComboBox, -2, -1, -2).addContainerGap()).addComponent(editPanel, -1, -1, Short.MAX_VALUE).addComponent(applyPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.namedElementComboBox, -2, -1, -2).addComponent(this.optionsButton, -1, -1, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(startWithLabel, -2, -1, -2).addComponent(this.startWithComboBox, -2, -1, -2)).addComponent(editPanel, -1, -1, Short.MAX_VALUE).addComponent(applyPanel, -2, -1, -2));
        DynamicComboBoxModel model = controller.getElementComboBoxModel();
        TransformerElement element = (TransformerElement)model.getSelectedItem();
        this.createView(element.getChain());
        controller.synchronize(this);
    }

    private void createView(List<Transformer<CyNetwork, CyIdentifiable>> chain) {
        if (chain == null) {
            this.setRootPanel(null);
            return;
        }
        CompositeTransformerPanel panel = new CompositeTransformerPanel(this, (TransformerPanelController)this.controller, chain, this.serviceRegistrar);
        new TransformerElementViewModel<TransformerPanel>(panel, this.controller, this);
        this.setRootPanel(panel);
    }

    void setRootPanel(CompositeTransformerPanel panel) {
        this.root = panel;
        this.scrollPane.setViewportView(this.root);
        if (this.root == null) {
            return;
        }
        this.root.updateLayout();
    }

    @Override
    public CompositeTransformerPanel getRootPanel() {
        return this.root;
    }

    @Override
    public void reset() {
        this.setRootPanel(null);
    }
}

