/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.view;

import java.awt.Dimension;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ToolTipManager;
import org.cytoscape.filter.internal.filters.composite.CompositeSeparator;
import org.cytoscape.filter.internal.view.AbstractPanelController;
import org.cytoscape.filter.internal.view.DragHandler;
import org.cytoscape.filter.internal.view.Handle;
import org.cytoscape.filter.internal.view.SelectPanelComponent;
import org.cytoscape.filter.internal.work.ValidationViewListener;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class TransformerElementViewModel<V extends SelectPanelComponent>
implements ValidationViewListener {
    private static final int WARN_ICON_WIDTH = 18;
    private static final int WARN_ICON_HEIGHT = 15;
    public final V parent;
    public final JComponent view;
    public final JComponent handle;
    public final JComponent deleteButton;
    public final JComponent separator;
    public final JComponent warnIcon;

    public TransformerElementViewModel(JComponent view, AbstractPanelController<?, V> controller, V parent) {
        this.view = view;
        this.parent = parent;
        this.handle = new Handle<V>(controller.getIconManager(), parent, controller, view);
        this.separator = new CompositeSeparator();
        this.deleteButton = this.createDeleteButton(controller.getIconManager(), controller);
        this.warnIcon = this.createWarningIcon(controller.getIconManager());
        new DropTarget(view, new DragHandler<V>(view, controller, parent, this.handle));
        new DropTarget(this.separator, new DragHandler<V>(this.separator, controller, parent, null));
        new DropTarget(this.handle, new DragHandler<V>(this.handle, controller, parent, null));
        new DropTarget(this.warnIcon, new DragHandler<V>(this.warnIcon, controller, parent, null));
    }

    private JComponent createDeleteButton(IconManager iconManager, AbstractPanelController<?, V> controller) {
        JButton button = new JButton("\uf00d");
        button.setFont(iconManager.getIconFont(15.0f));
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setOpaque(false);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setFocusPainted(false);
        button.addActionListener(e -> controller.handleDelete(this.parent, this.view));
        return button;
    }

    private JLabel createWarningIcon(IconManager iconManager) {
        JLabel warnIcon = new JLabel();
        warnIcon.setHorizontalTextPosition(0);
        warnIcon.setPreferredSize(new Dimension(18, 15));
        warnIcon.setFont(iconManager.getIconFont(16.0f));
        warnIcon.setText("\uf071");
        warnIcon.setForeground(LookAndFeelUtil.getWarnColor());
        warnIcon.setVisible(false);
        warnIcon.addMouseListener(new MouseAdapter(){
            final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
            final int dismissDelayMinutes = (int)TimeUnit.MINUTES.toMillis(1L);

            @Override
            public void mouseEntered(MouseEvent e) {
                ToolTipManager.sharedInstance().setDismissDelay(this.dismissDelayMinutes);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ToolTipManager.sharedInstance().setDismissDelay(this.defaultDismissTimeout);
            }
        });
        return warnIcon;
    }

    @Override
    public void handleValidated(ValidationViewListener.ValidationEvent event) {
        this.warnIcon.setVisible(!event.isValid());
        this.warnIcon.setToolTipText(event.getFormattedTooltip());
    }
}

