/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.transformers.interaction;

import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cytoscape.filter.internal.transformers.interaction.InteractionTransformer;
import org.cytoscape.filter.internal.view.ComboItem;
import org.cytoscape.filter.internal.view.CompositeFilterLayoutUpdator;
import org.cytoscape.filter.internal.view.ViewUtil;
import org.cytoscape.filter.internal.view.look.FilterPanelStyle;
import org.cytoscape.filter.model.Transformer;
import org.cytoscape.filter.view.TransformerViewFactory;

public class InteractionTransformerViewFactory
implements TransformerViewFactory {
    private final FilterPanelStyle style;

    public InteractionTransformerViewFactory(FilterPanelStyle style) {
        this.style = style;
    }

    public String getId() {
        return "org.cytoscape.InteractionTransformer";
    }

    public JComponent createView(Transformer<?, ?> transformer) {
        InteractionTransformer model = (InteractionTransformer)transformer;
        View view = new View(model);
        model.addListener(new CompositeFilterLayoutUpdator(view, model.getCompositeFilter()));
        return view;
    }

    class View
    extends JPanel
    implements CompositeFilterLayoutUpdator.LayoutUpdatable {
        private final InteractionTransformer model;
        private GroupLayout layout;
        private JLabel label1;
        private JLabel label2;
        private JComboBox<ComboItem<InteractionTransformer.Action>> actionCombo;
        private JComboBox<ComboItem<Runnable>> selectCombo;

        public View(InteractionTransformer model) {
            this.model = model;
            ViewUtil.configureFilterView(this);
            this.label1 = InteractionTransformerViewFactory.this.style.createLabel("Take edges and");
            this.actionCombo = InteractionTransformerViewFactory.this.style.createCombo();
            this.actionCombo.addItem(new ComboItem<InteractionTransformer.Action>(InteractionTransformer.Action.ADD, "add"));
            this.actionCombo.addItem(new ComboItem<InteractionTransformer.Action>(InteractionTransformer.Action.REPLACE, "replace with"));
            this.selectCombo = InteractionTransformerViewFactory.this.style.createCombo();
            this.selectCombo.addItem(new ComboItem<Runnable>(this::selectSourceAndTarget, "source and target nodes"));
            this.selectCombo.addItem(new ComboItem<Runnable>(this::selectSource, "source nodes"));
            this.selectCombo.addItem(new ComboItem<Runnable>(this::selectTarget, "target nodes"));
            this.label2 = InteractionTransformerViewFactory.this.style.createLabel("where the nodes match the filter:");
            if (model.selectSource && model.selectTarget) {
                this.selectCombo.setSelectedIndex(0);
            } else if (model.selectSource) {
                this.selectCombo.setSelectedIndex(1);
            } else if (model.selectTarget) {
                this.selectCombo.setSelectedIndex(2);
            } else {
                this.selectCombo.addItem(new ComboItem<Runnable>(this::selectNone, "---"));
                this.selectCombo.setSelectedIndex(3);
            }
            this.actionCombo.addActionListener(e -> model.setAction(this.actionCombo.getItemAt(this.actionCombo.getSelectedIndex()).getValue()));
            this.selectCombo.addActionListener(e -> this.selectCombo.getItemAt(this.selectCombo.getSelectedIndex()).getValue().run());
            this.layout = new GroupLayout(this);
            this.setLayout(this.layout);
            this.updateLayout();
        }

        private void selectSource() {
            this.model.selectSource = true;
            this.model.selectTarget = false;
        }

        private void selectTarget() {
            this.model.selectSource = false;
            this.model.selectTarget = true;
        }

        private void selectSourceAndTarget() {
            this.model.selectSource = true;
            this.model.selectTarget = true;
        }

        private void selectNone() {
            this.model.selectSource = false;
            this.model.selectTarget = false;
        }

        @Override
        public void updateLayout() {
            GroupLayout.ParallelGroup horizontalGroup = this.layout.createParallelGroup().addGroup(this.layout.createSequentialGroup().addComponent(this.label1).addComponent(this.actionCombo).addComponent(this.selectCombo));
            GroupLayout.SequentialGroup verticalGroup = this.layout.createSequentialGroup().addGroup(this.layout.createBaselineGroup(false, false).addComponent(this.label1).addComponent(this.actionCombo).addComponent(this.selectCombo));
            if (this.model.hasSubfilters()) {
                ((GroupLayout.Group)horizontalGroup).addGroup(this.layout.createSequentialGroup().addComponent(this.label2));
                ((GroupLayout.Group)verticalGroup).addGroup(this.layout.createBaselineGroup(false, false).addComponent(this.label2));
            }
            this.layout.setHorizontalGroup(horizontalGroup);
            this.layout.setVerticalGroup(verticalGroup);
        }
    }
}

