/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.transformers.adjacency;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cytoscape.filter.internal.transformers.adjacency.AdjacencyTransformer;
import org.cytoscape.filter.internal.view.ComboItem;
import org.cytoscape.filter.internal.view.CompositeFilterLayoutUpdator;
import org.cytoscape.filter.internal.view.ViewUtil;
import org.cytoscape.filter.internal.view.look.FilterPanelStyle;
import org.cytoscape.filter.model.Transformer;
import org.cytoscape.filter.view.TransformerViewFactory;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class AdjacencyTransformerViewFactory
implements TransformerViewFactory {
    private final FilterPanelStyle style;
    private final CyServiceRegistrar serviceRegistrar;

    public AdjacencyTransformerViewFactory(FilterPanelStyle style, CyServiceRegistrar serviceRegistrar) {
        this.style = style;
        this.serviceRegistrar = serviceRegistrar;
    }

    public static Properties getServiceProperties() {
        Properties props = new Properties();
        props.setProperty("addButtonTooltip", "Add condition on adjacent nodes/edges...");
        return props;
    }

    public String getId() {
        return "org.cytoscape.AdjacencyTransformer";
    }

    public JComponent createView(Transformer<?, ?> transformer) {
        AdjacencyTransformer model = (AdjacencyTransformer)transformer;
        View view = new View(model);
        model.addListener(new CompositeFilterLayoutUpdator(view, model.getCompositeFilter()));
        return view;
    }

    class View
    extends JPanel
    implements CompositeFilterLayoutUpdator.LayoutUpdatable {
        private final AdjacencyTransformer model;
        private GroupLayout layout;
        private JLabel label1;
        private JLabel label2;
        private JLabel label3a;
        private JLabel label3b;
        private JLabel label4;
        private JLabel arrowLabel;
        private JComboBox<ComboItem<AdjacencyTransformer.Action>> actionCombo;
        private JComboBox<ComboItem<AdjacencyTransformer.What>> outputCombo;
        private JComboBox<ComboItem<AdjacencyTransformer.EdgesAre>> edgesAreCombo;
        private JComboBox<ComboItem<AdjacencyTransformer.What>> filterTargetCombo;
        private boolean extraExpanded = false;

        public View(final AdjacencyTransformer model) {
            this.model = model;
            ViewUtil.configureFilterView(this);
            IconManager iconManager = (IconManager)AdjacencyTransformerViewFactory.this.serviceRegistrar.getService(IconManager.class);
            this.label1 = AdjacencyTransformerViewFactory.this.style.createLabel("Take nodes and");
            this.actionCombo = AdjacencyTransformerViewFactory.this.style.createCombo();
            this.actionCombo.addItem(new ComboItem<AdjacencyTransformer.Action>(AdjacencyTransformer.Action.ADD, "add"));
            this.actionCombo.addItem(new ComboItem<AdjacencyTransformer.Action>(AdjacencyTransformer.Action.REPLACE, "replace with"));
            this.outputCombo = AdjacencyTransformerViewFactory.this.style.createCombo();
            this.outputCombo.addItem(new ComboItem<AdjacencyTransformer.What>(AdjacencyTransformer.What.NODES_AND_EDGES, "adjacent nodes and edges"));
            this.outputCombo.addItem(new ComboItem<AdjacencyTransformer.What>(AdjacencyTransformer.What.NODES, "adjacent nodes"));
            this.outputCombo.addItem(new ComboItem<AdjacencyTransformer.What>(AdjacencyTransformer.What.EDGES, "adjacent edges"));
            this.arrowLabel = AdjacencyTransformerViewFactory.this.style.createLabel("\uf0d9");
            this.arrowLabel.setFont(iconManager.getIconFont(16.0f));
            this.label2 = AdjacencyTransformerViewFactory.this.style.createLabel("where the adjacent edges are");
            this.edgesAreCombo = AdjacencyTransformerViewFactory.this.style.createCombo();
            this.edgesAreCombo.addItem(new ComboItem<AdjacencyTransformer.EdgesAre>(AdjacencyTransformer.EdgesAre.INCOMING_AND_OUTGOING, "incoming and outgoing"));
            this.edgesAreCombo.addItem(new ComboItem<AdjacencyTransformer.EdgesAre>(AdjacencyTransformer.EdgesAre.INCOMING, "incoming"));
            this.edgesAreCombo.addItem(new ComboItem<AdjacencyTransformer.EdgesAre>(AdjacencyTransformer.EdgesAre.OUTGOING, "outgoing"));
            this.label3a = AdjacencyTransformerViewFactory.this.style.createLabel("and the");
            this.label3b = AdjacencyTransformerViewFactory.this.style.createLabel("where the");
            this.filterTargetCombo = AdjacencyTransformerViewFactory.this.style.createCombo();
            this.filterTargetCombo.addItem(new ComboItem<AdjacencyTransformer.What>(AdjacencyTransformer.What.NODES_AND_EDGES, "adjacent nodes and edges"));
            this.filterTargetCombo.addItem(new ComboItem<AdjacencyTransformer.What>(AdjacencyTransformer.What.NODES, "adjacent nodes"));
            this.filterTargetCombo.addItem(new ComboItem<AdjacencyTransformer.What>(AdjacencyTransformer.What.EDGES, "adjacent edges"));
            this.label4 = AdjacencyTransformerViewFactory.this.style.createLabel("match the filter:");
            this.actionCombo.setSelectedItem(ComboItem.of(model.getAction()));
            this.outputCombo.setSelectedItem(ComboItem.of(model.getOutput()));
            this.edgesAreCombo.setSelectedItem(ComboItem.of(model.getEdgesAre()));
            this.filterTargetCombo.setSelectedItem(ComboItem.of(model.getFilterTarget()));
            this.actionCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ComboItem<AdjacencyTransformer.Action> item = View.this.actionCombo.getItemAt(View.this.actionCombo.getSelectedIndex());
                    model.setAction(item.getValue());
                }
            });
            this.outputCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ComboItem<AdjacencyTransformer.What> item = View.this.outputCombo.getItemAt(View.this.outputCombo.getSelectedIndex());
                    model.setOutput(item.getValue());
                }
            });
            this.edgesAreCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ComboItem<AdjacencyTransformer.EdgesAre> item = View.this.edgesAreCombo.getItemAt(View.this.edgesAreCombo.getSelectedIndex());
                    model.setEdgesAre(item.getValue());
                }
            });
            this.filterTargetCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ComboItem<AdjacencyTransformer.What> item = View.this.filterTargetCombo.getItemAt(View.this.filterTargetCombo.getSelectedIndex());
                    model.setFilterTarget(item.getValue());
                }
            });
            this.arrowLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    View.this.handleArrowClicked();
                }
            });
            this.layout = new GroupLayout(this);
            this.layout.setAutoCreateContainerGaps(false);
            this.layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
            this.setLayout(this.layout);
            this.updateLayout();
        }

        private void handleArrowClicked() {
            boolean bl = this.extraExpanded = !this.extraExpanded;
            if (this.extraExpanded) {
                this.arrowLabel.setText("\uf0d7");
            } else {
                this.arrowLabel.setText("\uf0d9");
            }
            this.updateLayout();
        }

        @Override
        public void updateLayout() {
            this.removeAll();
            GroupLayout.ParallelGroup horizontalGroup = this.layout.createParallelGroup().addGroup(this.layout.createSequentialGroup().addComponent(this.label1).addComponent(this.actionCombo).addComponent(this.outputCombo).addComponent(this.arrowLabel));
            GroupLayout.SequentialGroup verticalGroup = this.layout.createSequentialGroup().addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.label1).addComponent(this.actionCombo).addComponent(this.outputCombo).addComponent(this.arrowLabel));
            if (this.extraExpanded) {
                ((GroupLayout.Group)horizontalGroup).addGroup(this.layout.createSequentialGroup().addComponent(this.label2).addComponent(this.edgesAreCombo));
                ((GroupLayout.Group)verticalGroup).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.label2).addComponent(this.edgesAreCombo));
            }
            if (this.model.hasSubfilters()) {
                ((GroupLayout.Group)horizontalGroup).addGroup(this.layout.createSequentialGroup().addComponent(this.extraExpanded ? this.label3a : this.label3b).addComponent(this.filterTargetCombo).addComponent(this.label4));
                ((GroupLayout.Group)verticalGroup).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.extraExpanded ? this.label3a : this.label3b).addComponent(this.filterTargetCombo).addComponent(this.label4));
            }
            this.layout.setHorizontalGroup(horizontalGroup);
            this.layout.setVerticalGroup(verticalGroup);
        }
    }
}

