/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.transformers.adjacency;

import org.cytoscape.filter.internal.AbstractMemoizableTransformer;
import org.cytoscape.filter.internal.filters.composite.CompositeFilterImpl;
import org.cytoscape.filter.model.CompositeFilter;
import org.cytoscape.filter.model.ElementTransformer;
import org.cytoscape.filter.model.Filter;
import org.cytoscape.filter.model.SubFilterTransformer;
import org.cytoscape.filter.model.TransformerSink;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.Tunable;

public class AdjacencyTransformer
extends AbstractMemoizableTransformer<CyNetwork, CyIdentifiable>
implements ElementTransformer<CyNetwork, CyIdentifiable>,
SubFilterTransformer<CyNetwork, CyIdentifiable> {
    private final CompositeFilter<CyNetwork, CyIdentifiable> adjacentElementFilter;
    private Action action = Action.ADD;
    private EdgesAre edgesAre = EdgesAre.INCOMING_AND_OUTGOING;
    private What filterTarget = What.NODES;
    private What output = What.NODES_AND_EDGES;

    public AdjacencyTransformer() {
        this.adjacentElementFilter = new CompositeFilterImpl<CyNetwork, CyIdentifiable>(CyNetwork.class, CyIdentifiable.class);
        this.adjacentElementFilter.setType(CompositeFilter.Type.ALL);
        this.adjacentElementFilter.addListener(() -> ((AdjacencyTransformer)this).notifyListeners());
    }

    @Override
    public CompositeFilter<CyNetwork, CyIdentifiable> getCompositeFilter() {
        return this.adjacentElementFilter;
    }

    public boolean hasSubfilters() {
        return this.adjacentElementFilter.getLength() > 0;
    }

    public String getName() {
        return "Node Adjacency Transformer";
    }

    public String getId() {
        return "org.cytoscape.AdjacencyTransformer";
    }

    public Class<CyNetwork> getContextType() {
        return CyNetwork.class;
    }

    public Class<CyIdentifiable> getElementType() {
        return CyIdentifiable.class;
    }

    public void apply(CyNetwork network, CyIdentifiable element, TransformerSink<CyIdentifiable> sink) {
        if (this.action == Action.ADD) {
            sink.collect((Object)element);
        }
        if (element instanceof CyNode) {
            CyNode currentNode = (CyNode)element;
            Iterable adjacentEdges = network.getAdjacentEdgeIterable(currentNode, this.edgesAre.type());
            Filter memoizedFilter = super.getMemoizedFilter();
            for (CyEdge edge : adjacentEdges) {
                boolean pass;
                CyNode node = AdjacencyTransformer.otherNode(currentNode, edge);
                if (this.filterTarget == What.NODES) {
                    pass = memoizedFilter.accepts((Object)network, (Object)node);
                } else if (this.filterTarget == What.EDGES) {
                    pass = memoizedFilter.accepts((Object)network, (Object)edge);
                } else {
                    boolean bl = pass = memoizedFilter.accepts((Object)network, (Object)node) && memoizedFilter.accepts((Object)network, (Object)edge);
                }
                if (!pass) continue;
                if (this.output == What.NODES || this.output == What.NODES_AND_EDGES) {
                    sink.collect((Object)node);
                }
                if (this.output != What.EDGES && this.output != What.NODES_AND_EDGES) continue;
                sink.collect((Object)edge);
            }
        }
    }

    private static CyNode otherNode(CyNode node, CyEdge edge) {
        if (node != edge.getSource() && node != edge.getTarget()) {
            throw new RuntimeException("hey, this node is not the source or the target!");
        }
        CyNode other = edge.getSource();
        if (other == node) {
            other = edge.getTarget();
        }
        return other;
    }

    public int getFilterCount() {
        return this.adjacentElementFilter.getLength();
    }

    @Tunable
    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
        this.notifyListeners();
    }

    @Tunable
    public What getOutput() {
        return this.output;
    }

    public void setOutput(What output) {
        this.output = output;
        this.notifyListeners();
    }

    @Tunable
    public EdgesAre getEdgesAre() {
        return this.edgesAre;
    }

    public void setEdgesAre(EdgesAre edgesAre) {
        this.edgesAre = edgesAre;
        this.notifyListeners();
    }

    @Tunable
    public What getFilterTarget() {
        return this.filterTarget;
    }

    public void setFilterTarget(What filterTarget) {
        this.filterTarget = filterTarget;
        this.notifyListeners();
    }

    public static enum EdgesAre {
        INCOMING,
        OUTGOING,
        INCOMING_AND_OUTGOING;


        public CyEdge.Type type() {
            switch (this) {
                default: {
                    return CyEdge.Type.INCOMING;
                }
                case OUTGOING: {
                    return CyEdge.Type.OUTGOING;
                }
                case INCOMING_AND_OUTGOING: 
            }
            return CyEdge.Type.ANY;
        }
    }

    public static enum What {
        NODES,
        EDGES,
        NODES_AND_EDGES;

    }

    public static enum Action {
        ADD,
        REPLACE;

    }
}

