/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.range;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cytoscape.filter.internal.range.JRangeSlider;
import org.cytoscape.filter.internal.range.RangeChooserController;
import org.cytoscape.filter.internal.view.look.FilterPanelStyle;

public class RangeChooser<N extends Number>
extends JPanel {
    private JRangeSlider slider;
    private JFormattedTextField lowField;
    private JFormattedTextField highField;
    private JLabel label1;
    private JLabel label2;
    private JPanel spacerPanel;
    private JLabel label3;
    private PropertyChangeListener textListener;
    private ChangeListener sliderListener;

    RangeChooser(FilterPanelStyle style, final RangeChooserController<N> controller) {
        this.slider = new JRangeSlider(controller.getSliderModel().getBoundedRangeModel(), 0);
        this.lowField = style.createFormattedTextField(controller.getFormatterFactory());
        this.lowField.setHorizontalAlignment(11);
        this.lowField.setColumns(6);
        this.highField = style.createFormattedTextField(controller.getFormatterFactory());
        this.highField.setHorizontalAlignment(11);
        this.highField.setColumns(6);
        this.sliderListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                controller.sliderChanged();
            }
        };
        this.textListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                controller.textFieldChanged();
            }
        };
        this.addListeners(controller);
        this.label1 = style.createLabel("between ");
        this.label2 = style.createLabel(" and ");
        this.label3 = style.createLabel(" inclusive.");
        this.spacerPanel = new JPanel();
        this.spacerPanel.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
    }

    void addListeners(RangeChooserController<N> controller) {
        this.slider.addChangeListener(this.sliderListener);
        this.lowField.addPropertyChangeListener("value", this.textListener);
        this.highField.addPropertyChangeListener("value", this.textListener);
    }

    void removeListeners() {
        this.slider.removeChangeListener(this.sliderListener);
        this.lowField.removePropertyChangeListener("value", this.textListener);
        this.highField.removePropertyChangeListener("value", this.textListener);
    }

    public JFormattedTextField getLowField() {
        return this.lowField;
    }

    public JFormattedTextField getHighField() {
        return this.highField;
    }

    public void setInteractive(boolean isInteractive) {
        this.removeAll();
        int row = 0;
        this.add((Component)this.label1, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lowField, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.label2, new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.highField, new GridBagConstraints(3, row, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.label3, new GridBagConstraints(4, row, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.spacerPanel, new GridBagConstraints(5, row, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.slider, new GridBagConstraints(0, ++row, 6, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 3), 0, 0));
        this.slider.invalidate();
        this.revalidate();
    }
}

