/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.range;

import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import org.cytoscape.filter.internal.range.SliderModel;

class DoubleSliderModel
implements SliderModel<Double> {
    private int NUM_TICKS = 500;
    private final BoundedRangeModel model = new DefaultBoundedRangeModel();
    private double minVal;
    private double maxVal;

    @Override
    public BoundedRangeModel getBoundedRangeModel() {
        return this.model;
    }

    @Override
    public void setValues(Double low, Double high, Double min, Double max) {
        this.minVal = min;
        this.maxVal = max;
        double value = DoubleSliderModel.map(low, min, max, 0.0, this.NUM_TICKS);
        double extent = DoubleSliderModel.map(high, min, max, 0.0, this.NUM_TICKS) - value;
        this.model.setRangeProperties(Double.valueOf(value).intValue(), Double.valueOf(extent).intValue(), 0, this.NUM_TICKS, false);
    }

    private static double map(double in, double inStart, double inEnd, double outStart, double outEnd) {
        double slope = (outEnd - outStart) / (inEnd - inStart);
        return outStart + slope * (in - inStart);
    }

    @Override
    public Double getLow() {
        double low = this.model.getValue();
        return DoubleSliderModel.map(low, 0.0, this.NUM_TICKS, this.minVal, this.maxVal);
    }

    @Override
    public Double getHigh() {
        double high = this.model.getValue() + this.model.getExtent();
        return DoubleSliderModel.map(high, 0.0, this.NUM_TICKS, this.minVal, this.maxVal);
    }

    @Override
    public Double getMin() {
        return this.minVal;
    }

    @Override
    public Double getMax() {
        return this.maxVal;
    }
}

