/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.filters.topology;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cytoscape.filter.internal.filters.topology.TopologyFilter;
import org.cytoscape.filter.internal.filters.topology.TopologyFilterController;
import org.cytoscape.filter.internal.filters.topology.TopologyFilterView;
import org.cytoscape.filter.internal.view.BooleanComboBox;
import org.cytoscape.filter.internal.view.CompositeFilterLayoutUpdator;
import org.cytoscape.filter.internal.view.ViewUtil;
import org.cytoscape.filter.internal.view.look.FilterPanelStyle;
import org.cytoscape.filter.model.Transformer;
import org.cytoscape.filter.predicates.Predicate;
import org.cytoscape.filter.view.TransformerViewFactory;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class TopologyFilterViewFactory
implements TransformerViewFactory {
    private final FilterPanelStyle style;

    public TopologyFilterViewFactory(FilterPanelStyle style) {
        this.style = style;
    }

    public static Properties getServiceProperties() {
        Properties props = new Properties();
        props.setProperty("addButtonTooltip", "Add neighbour condition...");
        return props;
    }

    public String getId() {
        return "org.cytoscape.TopologyFilter";
    }

    public JComponent createView(Transformer<?, ?> transformer) {
        TopologyFilter filter = (TopologyFilter)transformer;
        Controller controller = new Controller(filter);
        View view = new View(controller);
        filter.addListener(new CompositeFilterLayoutUpdator(view, filter));
        return view;
    }

    class View
    extends JPanel
    implements TopologyFilterView,
    CompositeFilterLayoutUpdator.LayoutUpdatable {
        private JFormattedTextField thresholdField;
        private JFormattedTextField distanceField;
        private final Controller controller;
        private GroupLayout layout;
        private JLabel label1;
        private JLabel label2;
        private JLabel label3;
        private BooleanComboBox atLeastCombo;

        public View(final Controller controller) {
            this.controller = controller;
            ViewUtil.configureFilterView(this);
            this.thresholdField = TopologyFilterViewFactory.this.style.createFormattedTextField(ViewUtil.createIntegerFormatter(0, Integer.MAX_VALUE));
            this.thresholdField.setHorizontalAlignment(11);
            this.thresholdField.setColumns(3);
            this.thresholdField.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    Integer value = (Integer)View.this.thresholdField.getValue();
                    controller.setThreshold(value);
                }
            });
            this.distanceField = TopologyFilterViewFactory.this.style.createFormattedTextField(ViewUtil.createIntegerFormatter(1, Integer.MAX_VALUE));
            this.distanceField.setHorizontalAlignment(11);
            this.distanceField.setColumns(3);
            this.distanceField.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    Integer value = (Integer)View.this.distanceField.getValue();
                    controller.setDistance(value);
                }
            });
            this.label1 = TopologyFilterViewFactory.this.style.createLabel("Nodes with ");
            this.label2 = TopologyFilterViewFactory.this.style.createLabel(" neighbours within distance ");
            this.label3 = TopologyFilterViewFactory.this.style.createLabel("where the neighbours match:");
            this.atLeastCombo = new BooleanComboBox(TopologyFilterViewFactory.this.style, "at least", "less than");
            this.atLeastCombo.addStateChangeListener(new BooleanComboBox.StateChangeListener(){

                @Override
                public void stateChanged(boolean atLeast) {
                    if (atLeast) {
                        controller.setGreaterThanOrEqual();
                    } else {
                        controller.setLessThan();
                    }
                }
            });
            this.layout = new GroupLayout(this);
            this.layout.setAutoCreateContainerGaps(false);
            this.layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
            this.setLayout(this.layout);
            this.updateLayout();
            controller.synchronize(this);
        }

        @Override
        public void updateLayout() {
            GroupLayout.ParallelGroup horizontalGroup = this.layout.createParallelGroup().addGroup(this.layout.createSequentialGroup().addComponent(this.label1).addComponent(this.atLeastCombo, -2, -2, -2)).addGroup(this.layout.createSequentialGroup().addComponent(this.thresholdField, -2, -2, -2).addComponent(this.label2).addComponent(this.distanceField, -2, -2, -2));
            GroupLayout.SequentialGroup verticalGroup = this.layout.createSequentialGroup().addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.label1).addComponent(this.atLeastCombo, -2, -2, -2)).addGroup(this.layout.createBaselineGroup(false, false).addComponent(this.thresholdField, -2, -2, -2).addComponent(this.label2).addComponent(this.distanceField, -2, -2, -2));
            if (this.controller.hasChildren()) {
                horizontalGroup.addGroup(this.layout.createSequentialGroup().addComponent(this.label3, -2, -2, -2));
                verticalGroup.addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.label3, -2, -2, -2));
            }
            this.layout.setHorizontalGroup(horizontalGroup);
            this.layout.setVerticalGroup(verticalGroup);
        }

        @Override
        public JFormattedTextField getThresholdField() {
            return this.thresholdField;
        }

        @Override
        public JFormattedTextField getDistanceField() {
            return this.distanceField;
        }

        @Override
        public BooleanComboBox getAtLeastComboBox() {
            return this.atLeastCombo;
        }
    }

    class Controller
    implements TopologyFilterController {
        private final TopologyFilter model;

        public Controller(TopologyFilter model) {
            this.model = model;
            if (model.getPredicate() == null) {
                model.setPredicate(Predicate.GREATER_THAN_OR_EQUAL);
            }
        }

        public void setThreshold(Integer threshold) {
            this.model.setThreshold(threshold);
        }

        public void setDistance(Integer distance) {
            this.model.setDistance(distance);
        }

        void synchronize(TopologyFilterView view) {
            view.getDistanceField().setValue(this.model.getDistance());
            view.getThresholdField().setValue(this.model.getThreshold());
            view.getAtLeastComboBox().setState(this.model.getPredicate() == Predicate.GREATER_THAN_OR_EQUAL);
        }

        boolean hasChildren() {
            return this.model.getLength() > 0;
        }

        public void setGreaterThanOrEqual() {
            this.model.setPredicate(Predicate.GREATER_THAN_OR_EQUAL);
        }

        public void setLessThan() {
            this.model.setPredicate(Predicate.LESS_THAN);
        }
    }
}

