/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.filters.degree;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.cytoscape.filter.internal.ModelMonitor;
import org.cytoscape.filter.internal.filters.degree.DegreeFilter;
import org.cytoscape.filter.internal.filters.degree.DegreeFilterController;
import org.cytoscape.filter.internal.filters.degree.DegreeFilterView;
import org.cytoscape.filter.internal.filters.degree.DegreeRange;
import org.cytoscape.filter.internal.range.RangeChooser;
import org.cytoscape.filter.internal.range.RangeChooserController;
import org.cytoscape.filter.internal.range.RangeListener;
import org.cytoscape.filter.internal.view.BooleanComboBox;
import org.cytoscape.filter.internal.view.ComboItem;
import org.cytoscape.filter.internal.view.DynamicComboBoxModel;
import org.cytoscape.filter.internal.view.Matcher;
import org.cytoscape.filter.internal.view.ViewUtil;
import org.cytoscape.filter.internal.view.look.FilterPanelStyle;
import org.cytoscape.filter.model.Transformer;
import org.cytoscape.filter.predicates.Predicate;
import org.cytoscape.filter.view.InteractivityChangedListener;
import org.cytoscape.filter.view.TransformerViewFactory;
import org.cytoscape.model.CyEdge;

public class DegreeFilterViewFactory
implements TransformerViewFactory {
    private final List<ComboItem<CyEdge.Type>> edgeTypeComboBoxModel;
    private final ModelMonitor modelMonitor;
    private final FilterPanelStyle style;

    public DegreeFilterViewFactory(FilterPanelStyle style, ModelMonitor modelMonitor) {
        this.modelMonitor = modelMonitor;
        this.style = style;
        this.edgeTypeComboBoxModel = new ArrayList<ComboItem<CyEdge.Type>>();
        this.edgeTypeComboBoxModel.add(new ComboItem<CyEdge.Type>(CyEdge.Type.ANY, "In + Out"));
        this.edgeTypeComboBoxModel.add(new ComboItem<CyEdge.Type>(CyEdge.Type.INCOMING, "In"));
        this.edgeTypeComboBoxModel.add(new ComboItem<CyEdge.Type>(CyEdge.Type.OUTGOING, "Out"));
    }

    public String getId() {
        return "org.cytoscape.DegreeFilter";
    }

    public JComponent createView(Transformer<?, ?> transformer) {
        DegreeFilter filter = (DegreeFilter)transformer;
        if (filter.getEdgeType() == null) {
            filter.setEdgeType(CyEdge.Type.ANY);
        }
        Controller controller = new Controller(filter);
        View view = new View(controller);
        this.modelMonitor.registerDegreeFilterView(view, controller);
        return view;
    }

    class View
    extends JPanel
    implements DegreeFilterView,
    InteractivityChangedListener {
        private JComboBox<ComboItem<CyEdge.Type>> edgeTypeComboBox;
        private Controller controller;
        private RangeChooser<Integer> chooser;
        private BooleanComboBox isOrIsNotCombo;

        public View(final Controller controller) {
            this.controller = controller;
            ViewUtil.configureFilterView(this);
            this.edgeTypeComboBox = DegreeFilterViewFactory.this.style.createCombo(new DynamicComboBoxModel<ComboItem<CyEdge.Type>>(DegreeFilterViewFactory.this.edgeTypeComboBoxModel));
            this.edgeTypeComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ComboItem<CyEdge.Type> type = View.this.edgeTypeComboBox.getItemAt(View.this.edgeTypeComboBox.getSelectedIndex());
                    controller.setEdgeType(type.getValue());
                }
            });
            this.isOrIsNotCombo = new BooleanComboBox(DegreeFilterViewFactory.this.style, "is", "is not");
            this.isOrIsNotCombo.addStateChangeListener(new BooleanComboBox.StateChangeListener(){

                @Override
                public void stateChanged(boolean is) {
                    controller.setIsOrIsNot(is);
                }
            });
            this.chooser = controller.chooserController.getRangeChooser();
            this.setLayout(new GridBagLayout());
            this.add((Component)DegreeFilterViewFactory.this.style.createLabel("Degree"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.edgeTypeComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.isOrIsNotCombo, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.chooser, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 3), 0, 0));
            controller.synchronize(this);
        }

        public void handleInteractivityChanged(boolean isInteractive) {
            this.controller.setInteractive(isInteractive, this);
        }

        RangeChooser<Integer> getRangeChooser() {
            return this.chooser;
        }

        public BooleanComboBox getIsOrIsNotCombo() {
            return this.isOrIsNotCombo;
        }
    }

    class Controller
    implements DegreeFilterController {
        private DegreeFilter filter;
        private RangeChooserController<Integer> chooserController;
        private boolean isInteractive;

        public Controller(final DegreeFilter filter) {
            Number highValue;
            Number lowValue;
            this.filter = filter;
            DegreeRange degreeRange = DegreeFilterViewFactory.this.modelMonitor.getDegreeRange();
            DegreeRange.Pair pair = degreeRange.getRange(filter.getEdgeType());
            Object criterion = filter.getCriterion();
            if (criterion instanceof Number) {
                highValue = lowValue = (Number)criterion;
            } else if (criterion instanceof Number[]) {
                Number[] range = (Number[])criterion;
                lowValue = range[0];
                highValue = range[1];
            } else {
                lowValue = pair.getLow();
                highValue = pair.getHigh();
            }
            this.chooserController = RangeChooserController.forInteger(DegreeFilterViewFactory.this.style, new RangeListener<Integer>(){

                @Override
                public void rangeChanged(Integer low, Integer high) {
                    Number[] range = new Number[]{low, high};
                    filter.setCriterion(range);
                }
            });
            this.chooserController.reset(lowValue.intValue(), highValue.intValue(), pair.getLow(), pair.getHigh());
        }

        public void synchronize(View view) {
            Object criterion;
            if (this.filter.getPredicate() == null) {
                this.filter.setPredicate(Predicate.BETWEEN);
            }
            BooleanComboBox combo = view.getIsOrIsNotCombo();
            combo.setState(this.filter.getPredicate() == Predicate.BETWEEN);
            CyEdge.Type edgeType = this.filter.getEdgeType();
            if (edgeType == null) {
                this.filter.setEdgeType(CyEdge.Type.ANY);
            }
            if ((criterion = this.filter.getCriterion()) instanceof Number[]) {
                DegreeRange degreeRange = DegreeFilterViewFactory.this.modelMonitor.getDegreeRange();
                DegreeRange.Pair pair = degreeRange.getRange(this.filter.getEdgeType());
                Number[] range = (Number[])criterion;
                this.chooserController.reset(range[0].intValue(), range[1].intValue(), pair.getLow(), pair.getHigh());
            }
            DynamicComboBoxModel.select(view.edgeTypeComboBox, 0, new Matcher<ComboItem<CyEdge.Type>>(){

                @Override
                public boolean matches(ComboItem<CyEdge.Type> item) {
                    return Controller.this.filter.getEdgeType().equals((Object)item.getValue());
                }
            });
            this.setInteractive(this.isInteractive, view);
        }

        public void setIsOrIsNot(boolean is) {
            this.filter.setPredicate(is ? Predicate.BETWEEN : Predicate.IS_NOT_BETWEEN);
        }

        public void setInteractive(boolean isInteractive, View view) {
            this.isInteractive = isInteractive;
            this.chooserController.setInteractive(isInteractive);
        }

        @Override
        public void setDegreeBounds(DegreeRange range) {
            DegreeRange.Pair pair = range.getRange(this.filter.getEdgeType());
            int min = pair.getLow();
            int max = pair.getHigh();
            int low = this.chooserController.getLow();
            int high = this.chooserController.getHigh();
            this.chooserController.reset(low, high, min, max);
        }

        public void setEdgeType(CyEdge.Type type) {
            DegreeRange range = DegreeFilterViewFactory.this.modelMonitor.getDegreeRange();
            this.filter.setEdgeType(type);
            this.setDegreeBounds(range);
        }
    }
}

