/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.filters.column;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CyColumnPresentationManager;
import org.cytoscape.filter.internal.filters.column.ColumnElement;
import org.cytoscape.filter.internal.view.Matcher;
import org.cytoscape.filter.internal.view.ViewUtil;
import org.cytoscape.filter.internal.view.look.FilterPanelStyle;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;

public class ColumnChooser
extends JPanel {
    private JComboBox<ColumnElement> comboBox;
    private Set<ColumnElement> enabledColumns = new HashSet<ColumnElement>();
    private final CyServiceRegistrar serviceRegistrar;

    public ColumnChooser(FilterPanelStyle style, CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.setOpaque(false);
        this.comboBox = style.createCombo();
        this.comboBox.setRenderer(new AttributeComboBoxCellRenderer());
        this.updateComboBox();
        this.setLayout(new BorderLayout());
        this.add(this.comboBox, "Center");
    }

    public ColumnElement getSelectedItem() {
        int index = this.comboBox.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        return this.comboBox.getItemAt(index);
    }

    public void addActionListener(ActionListener al) {
        this.comboBox.addActionListener(al);
    }

    public void removeActionListener(ActionListener al) {
        this.comboBox.removeActionListener(al);
    }

    void updateComboBox() {
        Object selected = this.comboBox.getSelectedItem();
        this.comboBox.removeAllItems();
        this.comboBox.addItem(new ColumnElement());
        CyNetwork network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
        if (network == null) {
            return;
        }
        this.enabledColumns = this.getColumns(network);
        TreeSet<ColumnElement> allColumns = new TreeSet<ColumnElement>();
        Set networks = ((CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class)).getNetworkSet();
        for (CyNetwork net : networks) {
            Set<ColumnElement> networkColumns = this.getColumns(net);
            allColumns.addAll(networkColumns);
        }
        for (ColumnElement columnElement : allColumns) {
            this.comboBox.addItem(columnElement);
        }
        this.comboBox.setSelectedItem(selected);
    }

    private Set<ColumnElement> getColumns(CyNetwork network) {
        HashSet<ColumnElement> columns = new HashSet<ColumnElement>();
        for (CyColumn col : network.getDefaultNodeTable().getColumns()) {
            columns.add(new ColumnElement(CyNode.class, col));
        }
        for (CyColumn col : network.getDefaultEdgeTable().getColumns()) {
            columns.add(new ColumnElement(CyEdge.class, col));
        }
        return columns;
    }

    public int find(Matcher<ColumnElement> matcher) {
        ComboBoxModel<ColumnElement> model = this.comboBox.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            ColumnElement element = (ColumnElement)model.getElementAt(i);
            if (!matcher.matches(element)) continue;
            return i;
        }
        return -1;
    }

    public void select(int defaultIndex, Matcher<ColumnElement> matcher) {
        int index = this.find(matcher);
        if (index == -1) {
            index = defaultIndex;
        }
        this.comboBox.setSelectedIndex(index);
    }

    private final class AttributeComboBoxCellRenderer
    extends BasicComboBoxRenderer {
        private AttributeComboBoxCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel lbl;
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return component;
            }
            ColumnElement columnElement = (ColumnElement)value;
            JLabel jLabel = lbl = component instanceof JLabel ? (JLabel)component : new JLabel();
            if (columnElement.isPlaceholder()) {
                lbl.setText(columnElement.getName());
                lbl.setIcon(null);
            } else {
                CyColumnPresentationManager presentationManager = (CyColumnPresentationManager)ColumnChooser.this.serviceRegistrar.getService(CyColumnPresentationManager.class);
                presentationManager.setLabel(columnElement.getName(), lbl::setIcon, text -> {
                    StringBuilder sb = new StringBuilder();
                    Class<?> tableType = columnElement.getTableType();
                    if (CyNode.class.equals(tableType)) {
                        sb.append("Node: ");
                    }
                    if (CyEdge.class.equals(tableType)) {
                        sb.append("Edge: ");
                    }
                    sb.append(ViewUtil.abbreviate(text, 30));
                    lbl.setText(sb.toString());
                });
                lbl.setToolTipText("Column: " + columnElement.getName());
            }
            if (!ColumnChooser.this.enabledColumns.contains(columnElement)) {
                if (isSelected) {
                    component.setBackground(UIManager.getColor("ComboBox.background"));
                } else {
                    component.setBackground(super.getBackground());
                }
                component.setForeground(UIManager.getColor("Label.disabledForeground"));
            } else {
                component.setBackground(super.getBackground());
                component.setForeground(super.getForeground());
            }
            return component;
        }
    }
}

