/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.filter.internal.FilterIO;
import org.cytoscape.filter.internal.view.FilterPanel;
import org.cytoscape.filter.internal.view.FilterPanelController;
import org.cytoscape.filter.internal.view.TransformerPanel;
import org.cytoscape.filter.internal.view.TransformerPanelController;
import org.cytoscape.session.events.SessionAboutToBeLoadedEvent;
import org.cytoscape.session.events.SessionAboutToBeLoadedListener;
import org.cytoscape.session.events.SessionAboutToBeSavedEvent;
import org.cytoscape.session.events.SessionAboutToBeSavedListener;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterSettingsManager
implements SessionAboutToBeSavedListener,
SessionAboutToBeLoadedListener,
SessionLoadedListener {
    static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    static final String SESSION_NAMESPACE = "org.cytoscape.filter";
    final FilterPanel filterPanel;
    final TransformerPanel transformerPanel;
    private FilterIO filterIo;

    public FilterSettingsManager(FilterPanel filterPanel, TransformerPanel transformerPanel, FilterIO filterIo) {
        this.filterPanel = filterPanel;
        this.transformerPanel = transformerPanel;
        this.filterIo = filterIo;
    }

    public void handleEvent(SessionAboutToBeLoadedEvent e) {
        ((FilterPanelController)this.filterPanel.getController()).reset(this.filterPanel);
        ((TransformerPanelController)this.transformerPanel.getController()).reset(this.transformerPanel);
        this.addDefaultsIfEmpty();
    }

    private void addDefaultsIfEmpty() {
        TransformerPanelController transformerPanelController;
        FilterPanelController filterPanelController = (FilterPanelController)this.filterPanel.getController();
        if (filterPanelController.getElementCount() == 0) {
            filterPanelController.addNewElement("Default filter");
        }
        if ((transformerPanelController = (TransformerPanelController)this.transformerPanel.getController()).getElementCount() == 0) {
            transformerPanelController.addNewElement("Default chain");
        }
    }

    public void handleEvent(SessionLoadedEvent event) {
        List files = (List)event.getLoadedSession().getAppFileListMap().get(SESSION_NAMESPACE);
        if (files == null) {
            return;
        }
        ((FilterPanelController)this.filterPanel.getController()).reset(this.filterPanel);
        ((TransformerPanelController)this.transformerPanel.getController()).reset(this.transformerPanel);
        for (File file : files) {
            try {
                if (file.getName().equals("filters.json")) {
                    this.filterIo.readTransformers(file, this.filterPanel);
                    continue;
                }
                if (!file.getName().equals("filterChains.json")) continue;
                this.filterIo.readTransformers(file, this.transformerPanel);
            }
            catch (IOException e) {
                logger.error("Unexpected error", (Throwable)e);
            }
        }
        this.addDefaultsIfEmpty();
    }

    public void handleEvent(SessionAboutToBeSavedEvent event) {
        FilterPanelController filterPanelController = (FilterPanelController)this.filterPanel.getController();
        TransformerPanelController transformerPanelController = (TransformerPanelController)this.transformerPanel.getController();
        ArrayList<File> files = new ArrayList<File>();
        try {
            File root = File.createTempFile(SESSION_NAMESPACE, ".temp");
            root.delete();
            root.mkdir();
            root.deleteOnExit();
            File filtersFile = new File(root, "filters.json");
            this.filterIo.writeFilters(filtersFile, filterPanelController.getNamedTransformers());
            files.add(filtersFile);
            File filterChainsFile = new File(root, "filterChains.json");
            this.filterIo.writeFilters(filterChainsFile, transformerPanelController.getNamedTransformers());
            files.add(filterChainsFile);
            for (File file : files) {
                file.deleteOnExit();
            }
            event.addAppFiles(SESSION_NAMESPACE, files);
        }
        catch (Exception e) {
            logger.error("Unexpected error", (Throwable)e);
        }
    }
}

