/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal;

import java.util.Properties;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.filter.TransformerContainer;
import org.cytoscape.filter.TransformerManager;
import org.cytoscape.filter.internal.CyNetworkSource;
import org.cytoscape.filter.internal.FilterCytoPanelComponent;
import org.cytoscape.filter.internal.FilterIO;
import org.cytoscape.filter.internal.FilterSettingsManager;
import org.cytoscape.filter.internal.ModelMonitor;
import org.cytoscape.filter.internal.filters.column.ColumnFilterFactory;
import org.cytoscape.filter.internal.filters.column.ColumnFilterViewFactory;
import org.cytoscape.filter.internal.filters.composite.CompositeFilterFactory;
import org.cytoscape.filter.internal.filters.degree.DegreeFilterFactory;
import org.cytoscape.filter.internal.filters.degree.DegreeFilterViewFactory;
import org.cytoscape.filter.internal.filters.topology.TopologyFilterFactory;
import org.cytoscape.filter.internal.filters.topology.TopologyFilterViewFactory;
import org.cytoscape.filter.internal.tasks.ExportNamedTransformersTaskFactory;
import org.cytoscape.filter.internal.tasks.ImportNamedTransformersTaskFactory;
import org.cytoscape.filter.internal.transformers.adjacency.AdjacencyTransformerFactory;
import org.cytoscape.filter.internal.transformers.adjacency.AdjacencyTransformerViewFactory;
import org.cytoscape.filter.internal.transformers.interaction.InteractionTransformerFactory;
import org.cytoscape.filter.internal.transformers.interaction.InteractionTransformerViewFactory;
import org.cytoscape.filter.internal.view.FilterPanel;
import org.cytoscape.filter.internal.view.FilterPanelController;
import org.cytoscape.filter.internal.view.TransformerPanel;
import org.cytoscape.filter.internal.view.TransformerPanelController;
import org.cytoscape.filter.internal.view.TransformerViewManager;
import org.cytoscape.filter.internal.view.look.FlatStyle;
import org.cytoscape.filter.internal.work.FilterWorker;
import org.cytoscape.filter.internal.work.LazyWorkQueue;
import org.cytoscape.filter.internal.work.TransformerManagerImpl;
import org.cytoscape.filter.internal.work.TransformerWorker;
import org.cytoscape.filter.internal.work.ValidationManager;
import org.cytoscape.filter.model.ElementTransformerFactory;
import org.cytoscape.filter.model.FilterFactory;
import org.cytoscape.filter.model.HolisticTransformerFactory;
import org.cytoscape.filter.model.TransformerSource;
import org.cytoscape.filter.view.TransformerViewFactory;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionAboutToBeLoadedListener;
import org.cytoscape.session.events.SessionAboutToBeSavedListener;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.work.TaskFactory;
import org.osgi.framework.BundleContext;

public class CyActivator
extends AbstractCyActivator {
    public void start(BundleContext bc) {
        CyServiceRegistrar serviceRegistrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        TransformerManagerImpl transformerManager = new TransformerManagerImpl();
        this.registerService(bc, transformerManager, TransformerManager.class, new Properties());
        this.registerServiceListener(bc, transformerManager::registerTransformerSource, transformerManager::unregisterTransformerSource, TransformerSource.class);
        this.registerServiceListener(bc, transformerManager::registerFilterFactory, transformerManager::unregisterFilterFactory, FilterFactory.class);
        this.registerServiceListener(bc, transformerManager::registerElementTransformerFactory, transformerManager::unregisterElementTransformerFactory, ElementTransformerFactory.class);
        this.registerServiceListener(bc, transformerManager::registerHolisticTransformerFactory, transformerManager::unregisterHolisticTransformerFactory, HolisticTransformerFactory.class);
        TransformerViewManager transformerViewManager = new TransformerViewManager(transformerManager);
        this.registerServiceListener(bc, transformerViewManager::registerTransformerViewFactory, transformerViewManager::unregisterTransformerViewFactory, TransformerViewFactory.class);
        this.registerService(bc, new CyNetworkSource(), TransformerSource.class, new Properties());
        this.registerService(bc, new DegreeFilterFactory(), FilterFactory.class, new Properties());
        this.registerService(bc, new ColumnFilterFactory(), FilterFactory.class, new Properties());
        this.registerService(bc, new TopologyFilterFactory(), FilterFactory.class, new Properties());
        this.registerService(bc, new CompositeFilterFactory<CyNetwork, CyIdentifiable>(CyNetwork.class, CyIdentifiable.class), FilterFactory.class, new Properties());
        this.registerService(bc, new InteractionTransformerFactory(), ElementTransformerFactory.class, new Properties());
        this.registerService(bc, new AdjacencyTransformerFactory(), ElementTransformerFactory.class, new Properties());
        ModelMonitor modelMonitor = new ModelMonitor();
        this.registerAllServices(bc, modelMonitor, new Properties());
        ValidationManager validationManager = new ValidationManager();
        this.registerAllServices(bc, validationManager, new Properties());
        FlatStyle style = new FlatStyle();
        this.registerService(bc, new DegreeFilterViewFactory(style, modelMonitor), TransformerViewFactory.class, new Properties());
        this.registerService(bc, new ColumnFilterViewFactory(style, modelMonitor, serviceRegistrar), TransformerViewFactory.class, new Properties());
        this.registerService(bc, new TopologyFilterViewFactory(style), TransformerViewFactory.class, TopologyFilterViewFactory.getServiceProperties());
        this.registerService(bc, new InteractionTransformerViewFactory(style), TransformerViewFactory.class, new Properties());
        this.registerService(bc, new AdjacencyTransformerViewFactory(style, serviceRegistrar), TransformerViewFactory.class, AdjacencyTransformerViewFactory.getServiceProperties());
        LazyWorkQueue queue = new LazyWorkQueue();
        FilterIO filterIo = new FilterIO(serviceRegistrar);
        FilterWorker filterWorker = new FilterWorker(queue, serviceRegistrar);
        FilterPanelController filterPanelController = new FilterPanelController(transformerManager, transformerViewManager, validationManager, filterWorker, modelMonitor, filterIo, style, serviceRegistrar);
        FilterPanel filterPanel = new FilterPanel(filterPanelController, filterWorker, serviceRegistrar);
        TransformerWorker transformerWorker = new TransformerWorker(queue, transformerManager, serviceRegistrar);
        TransformerPanelController transformerPanelController = new TransformerPanelController(transformerManager, transformerViewManager, validationManager, filterPanelController, transformerWorker, filterIo, style, serviceRegistrar);
        TransformerPanel transformerPanel = new TransformerPanel(transformerPanelController, transformerWorker, serviceRegistrar);
        FilterCytoPanelComponent selectPanel = new FilterCytoPanelComponent(transformerViewManager, modelMonitor, filterPanel, transformerPanel, serviceRegistrar);
        this.registerService(bc, selectPanel, CytoPanelComponent.class, new Properties());
        FilterSettingsManager settingsManager = new FilterSettingsManager(filterPanel, transformerPanel, filterIo);
        this.registerService(bc, settingsManager, SessionAboutToBeSavedListener.class, new Properties());
        this.registerService(bc, settingsManager, SessionAboutToBeLoadedListener.class, new Properties());
        this.registerService(bc, settingsManager, SessionLoadedListener.class, new Properties());
        Properties props = new Properties();
        props.setProperty("service.type", "manager");
        props.setProperty("container.type", "filter");
        this.registerService(bc, filterPanel, TransformerContainer.class, props);
        props = new Properties();
        props.setProperty("service.type", "manager");
        props.setProperty("container.type", "chain");
        this.registerService(bc, transformerPanel, TransformerContainer.class, props);
        props = new Properties();
        props.setProperty("command", "import");
        props.setProperty("commandNamespace", "filter");
        props.setProperty("commandDescription", "Import filter JSON from a file.");
        props.setProperty("commandLongDescription", "Import filter JSON from a file.");
        this.registerService(bc, (Object)new ImportNamedTransformersTaskFactory(filterIo, filterPanel), TaskFactory.class, props);
        props = new Properties();
        props.setProperty("command", "export");
        props.setProperty("commandNamespace", "filter");
        props.setProperty("commandDescription", "Export filter JSON to a file.");
        props.setProperty("commandLongDescription", "Export filter JSON to a file.");
        this.registerService(bc, (Object)new ExportNamedTransformersTaskFactory(filterIo, filterPanelController), TaskFactory.class, props);
    }
}

