/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.graphics;

import java.awt.Dimension;
import java.awt.Graphics;
import java.io.OutputStream;
import java.util.Properties;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PSWriter
extends AbstractTask
implements CyWriter {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    @Tunable(description="Export text as font:", longDescription="If true (the default value), texts will be exported as fonts.", groups={"_Others"}, gravity=2.1)
    public boolean exportTextAsFont = true;
    @Tunable(description="Hide Labels:", longDescription="If true then node and edge labels will not be visible in the image.", exampleStringValue="true", groups={"_Others"}, gravity=2.2)
    public boolean hideLabels;
    private final Double width;
    private final Double height;
    private final RenderingEngine<?> engine;
    private final OutputStream stream;

    @ProvidesTitle
    public String getTitle() {
        return "Export Network";
    }

    public PSWriter(RenderingEngine<?> engine, OutputStream stream) {
        if (engine == null) {
            throw new NullPointerException("Rendering Engine is null.");
        }
        if (stream == null) {
            throw new NullPointerException("Stream is null.");
        }
        this.engine = engine;
        this.stream = stream;
        this.width = (Double)engine.getViewModel().getVisualProperty(BasicVisualLexicon.NETWORK_WIDTH);
        this.height = (Double)engine.getViewModel().getVisualProperty(BasicVisualLexicon.NETWORK_HEIGHT);
        logger.debug("Post Script Writer created.");
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("PS Writer");
        tm.setStatusMessage("PS image rendering start...");
        tm.setProgress(0.0);
        logger.debug("PS image rendering start.");
        this.engine.getProperties().setProperty("exportHideLabels", String.valueOf(this.hideLabels));
        Properties p = new Properties();
        p.setProperty(PSGraphics2D.PAGE_SIZE, "Letter");
        p.setProperty("org.freehep.graphicsio.AbstractVectorGraphicsIO.TEXT_AS_SHAPES", Boolean.toString(!this.exportTextAsFont));
        tm.setProgress(0.1);
        PSGraphics2D g = new PSGraphics2D(this.stream, new Dimension(this.width.intValue(), this.height.intValue()));
        g.setMultiPage(false);
        g.setProperties(p);
        tm.setProgress(0.2);
        g.startExport();
        this.engine.printCanvas((Graphics)g);
        g.endExport();
        this.engine.getProperties().remove("exportHideLabels");
        logger.debug("PS image created.");
        tm.setStatusMessage("PS image created.");
        tm.setProgress(1.0);
    }
}

