/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.datatable;

import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.cytoscape.io.internal.util.cytables.model.BypassValue;
import org.cytoscape.io.internal.util.cytables.model.ColumnView;
import org.cytoscape.io.internal.util.cytables.model.CyTables;
import org.cytoscape.io.internal.util.cytables.model.RowView;
import org.cytoscape.io.internal.util.cytables.model.TableView;
import org.cytoscape.io.internal.util.cytables.model.TableViews;
import org.cytoscape.io.internal.util.cytables.model.VirtualColumn;
import org.cytoscape.io.internal.util.cytables.model.VirtualColumns;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableMetadata;
import org.cytoscape.model.VirtualColumnInfo;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.table.CyColumnViewMetadata;
import org.cytoscape.view.model.table.CyRowViewMetadata;
import org.cytoscape.view.model.table.CyTableViewMetadata;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class CyTablesXMLWriter
extends AbstractTask
implements CyWriter {
    private final CyServiceRegistrar registrar;
    private final Set<CyTableMetadata> tables;
    private final Set<CyTableViewMetadata> tableViews;
    private final OutputStream outputStream;
    private Map<Long, String> tableFileNamesBySUID;

    public CyTablesXMLWriter(CyServiceRegistrar registrar, Set<CyTableMetadata> tables, Set<CyTableViewMetadata> tableViews, Map<Long, String> tableFileNamesBySUID, OutputStream outputStream) {
        this.registrar = registrar;
        this.tables = tables;
        this.tableViews = tableViews;
        this.outputStream = outputStream;
        this.tableFileNamesBySUID = tableFileNamesBySUID;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((String)CyTables.class.getPackage().getName(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        Marshaller m = jc.createMarshaller();
        taskMonitor.setProgress(0.25);
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        taskMonitor.setProgress(0.5);
        CyTables model = this.buildModel();
        taskMonitor.setProgress(0.75);
        m.marshal((Object)model, this.outputStream);
        taskMonitor.setProgress(1.0);
    }

    private CyTables buildModel() {
        CyTables model = new CyTables();
        VirtualColumns virtualColumns = new VirtualColumns();
        model.setVirtualColumns(virtualColumns);
        for (CyTableMetadata metadata : this.tables) {
            CyTable table = metadata.getTable();
            String targetTable = this.tableFileNamesBySUID.get(table.getSUID());
            if (targetTable == null) continue;
            for (CyColumn cyColumn : table.getColumns()) {
                String sourceTable;
                VirtualColumnInfo info = cyColumn.getVirtualColumnInfo();
                if (!info.isVirtual() || (sourceTable = this.tableFileNamesBySUID.get(info.getSourceTable().getSUID())) == null) continue;
                VirtualColumn column = new VirtualColumn();
                column.setName(cyColumn.getName());
                column.setSourceColumn(info.getSourceColumn());
                column.setSourceTable(sourceTable);
                column.setSourceJoinKey(info.getSourceJoinKey());
                column.setTargetTable(targetTable);
                column.setTargetJoinKey(info.getTargetJoinKey());
                virtualColumns.getVirtualColumn().add(column);
            }
        }
        TableViews xmlTableViews = new TableViews();
        model.setTableViews(xmlTableViews);
        for (CyTableViewMetadata tableViewMetadata : this.tableViews) {
            BypassValue bypassValue;
            String value;
            String vpName;
            Long actualSuid = tableViewMetadata.getSavedTableSUID();
            String tableFileName = this.tableFileNamesBySUID.get(actualSuid);
            if (tableFileName == null) continue;
            TableView xmlTableView = new TableView();
            xmlTableView.setRendererId(tableViewMetadata.getRendererID());
            xmlTableView.setTableNamespace(tableViewMetadata.getNamespace());
            xmlTableView.setTable(tableFileName);
            xmlTableViews.getTableView().add(xmlTableView);
            for (Map.Entry entry : tableViewMetadata.getBypassValues().entrySet()) {
                String vpName2 = (String)entry.getKey();
                String value2 = (String)entry.getValue();
                if (value2 == null) continue;
                BypassValue bypassValue2 = new BypassValue();
                bypassValue2.setName(vpName2);
                bypassValue2.setValue(value2);
                xmlTableView.getBypassValue().add(bypassValue2);
            }
            for (CyColumnViewMetadata colViewMetadata : tableViewMetadata.getColumnViews()) {
                ColumnView xmlColumnView = new ColumnView();
                xmlColumnView.setColumnName(colViewMetadata.getName());
                xmlColumnView.setStyleTitle(colViewMetadata.getStyleName());
                for (Map.Entry entry : colViewMetadata.getBypassValues().entrySet()) {
                    vpName = (String)entry.getKey();
                    value = (String)entry.getValue();
                    if (value == null) continue;
                    bypassValue = new BypassValue();
                    bypassValue.setName(vpName);
                    bypassValue.setValue(value);
                    xmlColumnView.getBypassValue().add(bypassValue);
                }
                if (xmlColumnView.getStyleTitle() == null && xmlColumnView.getBypassValue().isEmpty()) continue;
                xmlTableView.getColumnView().add(xmlColumnView);
            }
            for (CyRowViewMetadata rowViewMetadata : tableViewMetadata.getRowViews()) {
                RowView xmlRowView = null;
                for (Map.Entry entry : rowViewMetadata.getBypassValues().entrySet()) {
                    vpName = (String)entry.getKey();
                    if (Objects.equals(vpName, "ROW_SELECTED") || (value = (String)entry.getValue()) == null) continue;
                    if (xmlRowView == null) {
                        xmlRowView = new RowView();
                        String serializedKey = CyTablesXMLWriter.serializeKey(rowViewMetadata.getKeyValue(), tableViewMetadata.getPrimaryKeyType());
                        xmlRowView.setKey(serializedKey);
                        xmlTableView.getRowView().add(xmlRowView);
                    }
                    bypassValue = new BypassValue();
                    bypassValue.setName(vpName);
                    bypassValue.setValue(value);
                    xmlRowView.getBypassValue().add(bypassValue);
                }
            }
        }
        return model;
    }

    private static String serializeKey(Object key, Class<?> keyType) {
        if (keyType.equals(List.class)) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            List list = (List)key;
            for (Object value : list) {
                if (!first) {
                    sb.append("|");
                }
                if (value != null) {
                    sb.append(value);
                }
                first = false;
            }
            return sb.toString();
        }
        return key.toString();
    }
}

