/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.SUIDFactory;
import org.cytoscape.model.SavePolicy;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.events.NetworkViewAboutToBeDestroyedEvent;
import org.cytoscape.view.model.events.NetworkViewAboutToBeDestroyedListener;

public class UnrecognizedVisualPropertyManager
implements NetworkViewAboutToBeDestroyedListener {
    public static final String RENDERER_TABLE_TITLE = "UnrecognizedRenderer";
    public static final String VISUAL_PROPERTY_TABLE_TITLE = "UnrecognizedVisualProperties";
    private static final String RENDERER_TABLE_PK = "SUID";
    private static final String VISUAL_PROPERTY_TABLE_PK = "SUID";
    private final CyServiceRegistrar serviceRegistrar;
    Map<Long, CyTable> rendererTablesMap;
    Map<Long, CyTable> vpTablesMap;

    public UnrecognizedVisualPropertyManager(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.rendererTablesMap = new HashMap<Long, CyTable>();
        this.vpTablesMap = new HashMap<Long, CyTable>();
    }

    public void addUnrecognizedVisualProperty(CyNetworkView netView, View<? extends CyIdentifiable> view, String attName, String attValue) {
        if (netView == null) {
            throw new IllegalArgumentException("The 'netView' argument cannot be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("The 'view' argument cannot be null");
        }
        if (attName == null) {
            throw new IllegalArgumentException("The 'attName' argument cannot be null");
        }
        CyTable rendererTbl = this.rendererTablesMap.get(netView.getSUID());
        if (rendererTbl == null) {
            this.createTables(netView.getSUID());
            rendererTbl = this.rendererTablesMap.get(netView.getSUID());
        }
        Collection rendererRows = rendererTbl.getMatchingRows("att_name", (Object)attName);
        String targetType = this.getTargetType(view);
        Long rendererId = null;
        for (CyRow r : rendererRows) {
            if (!targetType.equals(r.get("target_type", String.class))) continue;
            rendererId = (Long)((CyRow)rendererRows.iterator().next()).get("SUID", Long.class);
            break;
        }
        if (rendererId == null) {
            rendererId = SUIDFactory.getNextSUID();
            CyRow newRow = rendererTbl.getRow((Object)rendererId);
            newRow.set("att_name", (Object)attName);
            newRow.set("target_type", (Object)targetType);
        }
        CyTable vpTbl = this.vpTablesMap.get(netView.getSUID());
        CyRow newRow = vpTbl.getRow((Object)SUIDFactory.getNextSUID());
        newRow.set("att_id", (Object)rendererId);
        newRow.set("att_value", (Object)attValue);
        newRow.set("target_id", (Object)view.getSUID());
    }

    public Map<String, String> getUnrecognizedVisualProperties(CyNetworkView netView, View<? extends CyIdentifiable> view) {
        if (netView == null) {
            throw new IllegalArgumentException("The 'netView' argument cannot be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("The 'view' argument cannot be null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        CyTable rendererTbl = this.rendererTablesMap.get(netView.getSUID());
        CyTable vpTbl = this.vpTablesMap.get(netView.getSUID());
        if (rendererTbl != null && vpTbl != null) {
            String targetType = this.getTargetType(view);
            Collection rows = vpTbl.getMatchingRows("target_id", (Object)view.getSUID());
            for (CyRow r : rows) {
                Long rendererId = (Long)r.get("att_id", Long.class);
                CyRow rendererRow = rendererTbl.getRow((Object)rendererId);
                if (!targetType.equals(rendererRow.get("target_type", String.class))) continue;
                String attName = (String)r.get("att_name_vc", String.class);
                String attValue = (String)r.get("att_value", String.class);
                map.put(attName, attValue);
            }
        }
        return map;
    }

    public void handleEvent(NetworkViewAboutToBeDestroyedEvent e) {
        this.dropTables(e.getNetworkView());
    }

    private String getTargetType(View<? extends CyIdentifiable> view) {
        CyIdentifiable model = (CyIdentifiable)view.getModel();
        String type = "network";
        if (model instanceof CyNode) {
            type = "node";
        }
        if (model instanceof CyEdge) {
            type = "edge";
        }
        return type;
    }

    private void createTables(Long netViewId) {
        CyTableFactory tableFactory = (CyTableFactory)this.serviceRegistrar.getService(CyTableFactory.class);
        CyTable rendererTbl = tableFactory.createTable(RENDERER_TABLE_TITLE + netViewId, "SUID", Long.class, false, true);
        CyTableManager tableMgr = (CyTableManager)this.serviceRegistrar.getService(CyTableManager.class);
        tableMgr.addTable(rendererTbl);
        rendererTbl.setSavePolicy(SavePolicy.DO_NOT_SAVE);
        rendererTbl.createColumn("att_name", String.class, false);
        rendererTbl.createColumn("target_type", String.class, false);
        CyTable vpTbl = tableFactory.createTable(VISUAL_PROPERTY_TABLE_TITLE + netViewId, "SUID", Long.class, false, true);
        tableMgr.addTable(vpTbl);
        vpTbl.setSavePolicy(SavePolicy.DO_NOT_SAVE);
        vpTbl.createColumn("att_id", Long.class, false);
        vpTbl.createColumn("att_value", String.class, false);
        vpTbl.createColumn("target_id", Long.class, false);
        vpTbl.addVirtualColumn("att_name_vc", "att_name", rendererTbl, "att_id", false);
        this.rendererTablesMap.put(netViewId, rendererTbl);
        this.vpTablesMap.put(netViewId, vpTbl);
    }

    private void dropTables(CyNetworkView view) {
        CyTable rendererTbl;
        Long netViewId = view.getSUID();
        CyTable vpTbl = this.vpTablesMap.get(netViewId);
        CyTableManager tableMgr = (CyTableManager)this.serviceRegistrar.getService(CyTableManager.class);
        if (vpTbl != null) {
            tableMgr.deleteTable(vpTbl.getSUID().longValue());
            this.vpTablesMap.remove(netViewId);
        }
        if ((rendererTbl = this.rendererTablesMap.get(netViewId)) != null) {
            tableMgr.deleteTable(rendererTbl.getSUID().longValue());
            this.rendererTablesMap.remove(netViewId);
        }
    }
}

