/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.xgmml.handler;

import org.cytoscape.io.internal.read.xgmml.ParseState;
import org.cytoscape.io.internal.read.xgmml.handler.AbstractHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HandleViewEdgeGraphics
extends AbstractHandler {
    @Override
    public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
        Object edgeId = this.manager.getCurrentElementId();
        if (edgeId == null) {
            logger.error("Cannot parse edge view: edge id is null");
            return current;
        }
        if (tag.equals("graphics")) {
            this.manager.addViewGraphicsAttributes(edgeId, atts, false);
        } else if (tag.equals("att")) {
            String name = atts.getValue("name");
            if ("lockedVisualProperties".equalsIgnoreCase(name)) {
                return ParseState.LOCKED_VISUAL_PROP_ATT;
            }
            String value = atts.getValue("value");
            if (name != null && value != null) {
                this.manager.addViewGraphicsAttribute(edgeId, name, value, false);
            }
        }
        return current;
    }
}

