/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.xgmml.handler;

import org.cytoscape.io.internal.read.xgmml.ParseState;
import org.cytoscape.io.internal.read.xgmml.handler.AbstractHandler;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HandleNodeAttribute
extends AbstractHandler {
    @Override
    public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
        if (atts == null) {
            return current;
        }
        this.manager.attState = current;
        if (!this.manager.isSessionFormat() || this.manager.getDocumentVersion() < 3.0) {
            ParseState nextState;
            String name = atts.getValue("name");
            if (name == null && atts.getValue("value") == null) {
                return current;
            }
            if (this.manager.getDocumentVersion() < 3.0) {
                if (name.startsWith("node.")) {
                    name = name.replace(".", "").toLowerCase();
                    String value = atts.getValue("value");
                    this.manager.addGraphicsAttribute((CyIdentifiable)this.manager.getCurrentNode(), name, value);
                } else if (name.equals("nested_network_id")) {
                    String netId = atts.getValue("value");
                    CyNode node = this.manager.getCurrentNode();
                    if (netId != null && !netId.equals(this.manager.getCache().getNetworkPointerId(node))) {
                        this.manager.getCache().addNetworkPointer(node, netId);
                    }
                }
            }
            if ((nextState = this.attributeValueUtil.handleAttribute(atts)) != ParseState.NONE) {
                return nextState;
            }
        }
        return current;
    }
}

